/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.RestrictionImpl;

public class MinCardinalityRestrictionImpl
extends RestrictionImpl
implements MinCardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MinCardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MinCardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, MinCardinalityRestriction.class);
        }
    };

    public MinCardinalityRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setMinCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMinCardinality() {
        return this.objectAsInt(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
    }

    @Override
    public boolean hasMinCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMinCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

