/*
 * Decompiled with CFR 0.152.
 */
package seamarks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import messages.Messages;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagMap;
import panels.PanelMain;
import smed.SmedAction;

public class SeaMark
extends JPanel {
    public SmedAction dlg = null;
    public static final EnumMap<Reg, String> RegSTR = new EnumMap(Reg.class);
    private Reg region = Reg.A;
    private String name = "";
    public static final EnumMap<Obj, String> ObjSTR;
    private Obj object = Obj.UNKOBJ;
    public static final EnumMap<Obj, Ent> EntMAP;
    public static final EnumMap<Obj, Grp> GrpMAP;
    public static final EnumMap<Cat, String> CatSTR;
    private Cat category = Cat.NOCAT;
    public static final EnumMap<Shp, String> ShpSTR;
    private Shp shape = Shp.UNKSHP;
    public static final EnumMap<Col, Color> ColMAP;
    public static final EnumMap<Col, String> ColSTR;
    private ArrayList<Col> bodyColour = new ArrayList();
    private ArrayList<Col> topmarkColour = new ArrayList();
    public static final Map<EnumSet<Chr>, String> ChrMAP;
    public static final EnumMap<Vis, String> VisSTR;
    public static final EnumMap<Lit, String> LitSTR;
    public static final EnumMap<Exh, String> ExhSTR;
    public Object[] sector = new Object[]{Col.UNKCOL, "", "", "", "", Lit.UNKLIT, "", "", "", "", "", Vis.UNKVIS, Exh.UNKEXH, "", "", Col.UNKCOL};
    private ArrayList<Object[]> sectors = new ArrayList();
    public static final EnumMap<Pat, String> PatSTR;
    private Pat bodyPattern = Pat.NOPAT;
    private Pat topPattern = Pat.NOPAT;
    public static final EnumMap<Top, String> TopSTR;
    private Top topShape = Top.NOTOP;
    private Cat RoType = Cat.NOROS;
    public static final EnumMap<Rtb, String> RtbSTR;
    private Rtb RaType = Rtb.NORTB;
    private String raconGroup = "";
    private String raconSequence = "";
    private String raconPeriod = "";
    private String raconRange = "";
    private String raconSector1 = "";
    private String raconSector2 = "";
    public static final EnumMap<Fog, String> FogSTR;
    private Fog fogSound = Fog.NOFOG;
    private String fogGroup = "";
    private String fogSequence = "";
    private String fogRange = "";
    private String fogPeriod = "";
    public static final EnumMap<Sts, String> StsSTR;
    private Sts status = Sts.UNKSTS;
    public static final EnumMap<Cns, String> CnsSTR;
    private Cns construction = Cns.UNKCNS;
    public static final EnumMap<Con, String> ConSTR;
    private Con conspicuity = Con.UNKCON;
    private Con reflectivity = Con.UNKCON;
    public static final EnumMap<Fnc, String> FncSTR;
    private Fnc function = Fnc.UNKFNC;
    public String information = "";
    public String source = "";
    public String elevation = "";
    public String height = "";
    private String channel = "";
    public String ref = "";
    public String lightRef = "";
    public String fixme = "";

    public SeaMark(SmedAction dia) {
        this.dlg = dia;
        this.clrLight();
    }

    public Reg getRegion() {
        return this.region;
    }

    public void setRegion(Reg reg) {
        this.region = reg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String str) {
        this.name = str.trim();
        this.repaint();
    }

    public Obj getObject() {
        return this.object;
    }

    public void setObject(Obj obj) {
        this.object = obj;
        if (obj == Obj.UNKOBJ) {
            this.setCategory(Cat.NOCAT);
            this.setFunc(Fnc.UNKFNC);
            this.setShape(Shp.UNKSHP);
            this.setColour(Ent.BODY, Col.UNKCOL);
            this.setPattern(Ent.BODY, Pat.NOPAT);
            this.setTopmark(Top.NOTOP);
            this.setColour(Ent.TOPMARK, Col.UNKCOL);
            this.setPattern(Ent.TOPMARK, Pat.NOPAT);
        }
        this.repaint();
    }

    public Cat getCategory() {
        return this.category;
    }

    public void setCategory(Cat cat) {
        this.category = cat;
        this.repaint();
    }

    public Shp getShape() {
        return this.shape;
    }

    public void setShape(Shp shp) {
        this.shape = shp;
        this.repaint();
    }

    public Col getColour(Ent ent, int idx) {
        if (ent == Ent.BODY) {
            return this.getObjColour(idx);
        }
        return this.getTopColour(idx);
    }

    public void setColour(Ent ent, Col col) {
        if (ent == Ent.BODY) {
            this.setObjColour(col);
        } else {
            this.setTopColour(col);
        }
    }

    public void setColour(Ent ent, int idx, Col col) {
        if (ent == Ent.BODY) {
            this.setObjColour(idx, col);
        } else {
            this.setTopColour(idx, col);
        }
    }

    public void addColour(Ent ent, int idx, Col col) {
        if (ent == Ent.BODY) {
            this.addObjColour(idx, col);
        } else {
            this.addTopColour(idx, col);
        }
    }

    public void subColour(Ent ent, int idx) {
        if (ent == Ent.BODY) {
            this.subObjColour(idx);
        } else {
            this.subTopColour(idx);
        }
    }

    public Col getObjColour(int i) {
        if (i < this.bodyColour.size()) {
            return this.bodyColour.get(i);
        }
        return Col.UNKCOL;
    }

    public void setObjColour(Col col) {
        this.bodyColour.clear();
        this.bodyColour.add(col);
        this.repaint();
    }

    public void setObjColour(int i, Col col) {
        if (i < this.bodyColour.size()) {
            this.bodyColour.set(i, col);
        }
        this.repaint();
    }

    public void addObjColour(int i, Col col) {
        if (this.bodyColour.size() >= i) {
            this.bodyColour.add(i, col);
        }
        this.repaint();
    }

    public void addObjColour(Col col) {
        this.bodyColour.add(col);
        this.repaint();
    }

    public void subObjColour(int i) {
        if (this.bodyColour.size() > i) {
            this.bodyColour.remove(i);
        }
        this.repaint();
    }

    public Col getTopColour(int i) {
        if (i < this.topmarkColour.size()) {
            return this.topmarkColour.get(i);
        }
        return Col.UNKCOL;
    }

    public void setTopColour(Col col) {
        this.topmarkColour.clear();
        this.topmarkColour.add(col);
        this.repaint();
    }

    public void setTopColour(int i, Col col) {
        if (this.topmarkColour.size() > i) {
            this.topmarkColour.set(i, col);
        }
        this.repaint();
    }

    public void addTopColour(int i, Col col) {
        if (this.topmarkColour.size() >= i) {
            this.topmarkColour.add(i, col);
        }
        this.repaint();
    }

    public void addTopColour(Col col) {
        this.topmarkColour.add(col);
        this.repaint();
    }

    public void subTopColour(int i) {
        if (this.topmarkColour.size() > i) {
            this.topmarkColour.remove(i);
        }
        this.repaint();
    }

    public int getSectorCount() {
        return this.sectors.size();
    }

    public boolean isSectored() {
        return this.sectors.size() > 1;
    }

    public Object getLightAtt(Att att, int i) {
        return this.getLightAtt(att.ordinal(), i);
    }

    public Object getLightAtt(int att, int i) {
        if (i < this.sectors.size()) {
            return this.sectors.get(i)[att];
        }
        return null;
    }

    public void setLightAtt(Att att, int i, Object obj) {
        this.setLightAtt(att.ordinal(), i, obj);
    }

    public void setLightAtt(int att, int i, Object obj) {
        if (this.sectors.size() == i) {
            this.addLight(i);
        }
        if (this.sectors.size() > i) {
            switch (att) {
                case 4: 
                case 8: 
                case 9: 
                case 10: {
                    this.sectors.get((int)i)[att] = this.validDecimal((String)obj);
                    break;
                }
                case 6: 
                case 7: 
                case 13: {
                    this.sectors.get((int)i)[att] = this.validDecimal((String)obj, 360.0f);
                    break;
                }
                default: {
                    this.sectors.get((int)i)[att] = obj;
                }
            }
        }
        this.repaint();
    }

    public void addLight(int i) {
        if (this.sectors.size() >= i) {
            if (this.sectors.size() == 0) {
                this.sectors.add((Object[])this.sector.clone());
            } else {
                this.sectors.add(i, (Object[])this.sectors.get(0).clone());
            }
        }
    }

    public void nulLight(int i) {
        if (i == 0) {
            this.clrLight();
        } else {
            this.sectors.add(i, (Object[])this.sector.clone());
        }
    }

    public void addLight() {
        if (this.sectors.size() == 0) {
            this.sectors.add((Object[])this.sector.clone());
        } else {
            this.sectors.add((Object[])this.sectors.get(0).clone());
        }
    }

    public void delLight(int i) {
        if (this.sectors.size() > i) {
            this.sectors.remove(i);
        }
        this.repaint();
    }

    public void clrLight() {
        this.sectors.clear();
        this.addLight();
        this.setLightRef("");
        this.repaint();
    }

    public Pat getPattern(Ent ent) {
        if (ent == Ent.BODY) {
            return this.getObjPattern();
        }
        return this.getTopPattern();
    }

    public void setPattern(Ent ent, Pat pat) {
        if (ent == Ent.BODY) {
            this.setObjPattern(pat);
        } else {
            this.setTopPattern(pat);
        }
    }

    public Pat getObjPattern() {
        return this.bodyPattern;
    }

    public void setObjPattern(Pat pat) {
        this.bodyPattern = pat;
    }

    public Pat getTopPattern() {
        return this.topPattern;
    }

    public void setTopPattern(Pat pat) {
        this.topPattern = pat;
    }

    public Top getTopmark() {
        return this.topShape;
    }

    public void setTopmark(Top top) {
        this.topShape = top;
        this.repaint();
    }

    public Cat getRadio() {
        return this.RoType;
    }

    public void setRadio(Cat type) {
        this.RoType = type;
        this.repaint();
    }

    public Rtb getRadar() {
        return this.RaType;
    }

    public void setRadar(Rtb type) {
        this.RaType = type;
        if (type == Rtb.NORTB) {
            this.setRaconGroup("");
            this.setRaconSequence("");
            this.setRaconPeriod("");
            this.setRaconRange("");
            this.setRaconSector1("");
            this.setRaconSector2("");
        }
        this.repaint();
    }

    public String getRaconGroup() {
        return this.raconGroup;
    }

    public void setRaconGroup(String grp) {
        this.raconGroup = grp;
        this.repaint();
    }

    public String getRaconSequence() {
        return this.raconSequence;
    }

    public void setRaconSequence(String seq) {
        this.raconSequence = seq;
        this.repaint();
    }

    public String getRaconPeriod() {
        return this.raconPeriod;
    }

    public void setRaconPeriod(String per) {
        this.raconPeriod = this.validDecimal(per);
        this.repaint();
    }

    public String getRaconRange() {
        return this.raconRange;
    }

    public void setRaconRange(String rng) {
        this.raconRange = this.validDecimal(rng);
        this.repaint();
    }

    public String getRaconSector1() {
        return this.raconSector1;
    }

    public void setRaconSector1(String sec) {
        this.raconSector1 = this.validDecimal(sec);
        this.repaint();
    }

    public String getRaconSector2() {
        return this.raconSector2;
    }

    public void setRaconSector2(String sec) {
        this.raconSector2 = this.validDecimal(sec);
        this.repaint();
    }

    public Fog getFogSound() {
        return this.fogSound;
    }

    public void setFogSound(Fog sound) {
        this.fogSound = sound;
        if (sound == Fog.NOFOG) {
            this.setFogGroup("");
            this.setFogSequence("");
            this.setFogPeriod("");
            this.setFogRange("");
        }
        this.repaint();
    }

    public String getFogGroup() {
        return this.fogGroup;
    }

    public void setFogGroup(String grp) {
        this.fogGroup = grp;
        this.repaint();
    }

    public String getFogSequence() {
        return this.fogSequence;
    }

    public void setFogSequence(String seq) {
        this.fogSequence = seq;
        this.repaint();
    }

    public String getFogRange() {
        return this.fogRange;
    }

    public void setFogRange(String rng) {
        this.fogRange = this.validDecimal(rng);
        this.repaint();
    }

    public String getFogPeriod() {
        return this.fogPeriod;
    }

    public void setFogPeriod(String per) {
        this.fogPeriod = this.validDecimal(per);
        this.repaint();
    }

    public Sts getStatus() {
        return this.status;
    }

    public void setStatus(Sts sts) {
        this.status = sts;
    }

    public Cns getConstr() {
        return this.construction;
    }

    public void setConstr(Cns cns) {
        this.construction = cns;
    }

    public Con getConsp() {
        return this.conspicuity;
    }

    public void setConsp(Con con) {
        this.conspicuity = con;
    }

    public Con getRefl() {
        return this.reflectivity;
    }

    public void setRefl(Con con) {
        this.reflectivity = con;
    }

    public Fnc getFunc() {
        return this.function;
    }

    public void setFunc(Fnc fnc) {
        this.function = fnc;
        this.repaint();
    }

    public String getInfo() {
        return this.information;
    }

    public void setInfo(String str) {
        this.information = str.trim();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String str) {
        this.source = str.trim();
    }

    public String getElevation() {
        return this.elevation;
    }

    public void setElevation(String str) {
        this.elevation = this.validDecimal(str);
    }

    public String getObjectHeight() {
        return this.height;
    }

    public void setObjectHeight(String str) {
        this.height = this.validDecimal(str);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String per) {
        this.channel = this.validDecimal(per);
        this.repaint();
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String str) {
        this.ref = str;
    }

    public String getLightRef() {
        return this.lightRef;
    }

    public void setLightRef(String str) {
        this.lightRef = str;
    }

    public String getFixme() {
        return this.fixme;
    }

    public void setFixme(String str) {
        this.fixme = str;
    }

    public boolean testValid() {
        if (this.dlg.node == null) {
            return false;
        }
        boolean tmp = false;
        PanelMain.messageBar.setText("");
        switch (this.getObject()) {
            case BCNCAR: 
            case BCNLAT: 
            case BOYCAR: 
            case BOYLAT: {
                if (this.getCategory() == Cat.NOCAT || this.getShape() == Shp.UNKSHP) break;
                tmp = true;
                break;
            }
            case BCNISD: 
            case BCNSAW: 
            case BCNSPP: 
            case BOYISD: 
            case BOYSAW: 
            case BOYSPP: {
                if (this.getShape() == Shp.UNKSHP) break;
                tmp = true;
                break;
            }
            case FLTCAR: 
            case FLTISD: 
            case FLTLAT: 
            case FLTSAW: 
            case FLTSPP: {
                if (this.getObjColour(0) == Col.UNKCOL) break;
                tmp = true;
                break;
            }
            case LITMAJ: 
            case LITMIN: 
            case LITFLT: 
            case LITVES: 
            case LITHSE: 
            case SISTAW: 
            case SISTAT: 
            case OFSPLF: 
            case MORFAC: 
            case BOYINB: 
            case PILBOP: 
            case RSCSTA: 
            case RDOSTA: 
            case RADSTA: {
                tmp = true;
                break;
            }
            case NOTMRK: {
                if (this.getCategory() != Cat.NOCAT) {
                    tmp = true;
                }
            }
            case LNDMRK: {
                if (this.getCategory() == Cat.NOCAT && this.getFunc() == Fnc.UNKFNC) break;
                tmp = true;
            }
        }
        if (tmp) {
            SmedAction.panelMain.moreButton.setVisible(true);
            SmedAction.panelMain.saveButton.setEnabled(true);
            SmedAction.panelMain.topButton.setEnabled(true);
            SmedAction.panelMain.fogButton.setEnabled(true);
            SmedAction.panelMain.radButton.setEnabled(true);
            SmedAction.panelMain.litButton.setEnabled(true);
            return true;
        }
        SmedAction.panelMain.moreButton.setVisible(false);
        SmedAction.panelMain.moreButton.setText(">>");
        SmedAction.panelMain.topButton.setEnabled(false);
        SmedAction.panelMain.fogButton.setEnabled(false);
        SmedAction.panelMain.radButton.setEnabled(false);
        SmedAction.panelMain.litButton.setEnabled(false);
        PanelMain.messageBar.setText("Seamark not recognised");
        return false;
    }

    public void clrMark() {
        this.setName("");
        this.setObject(Obj.UNKOBJ);
        this.clrLight();
        this.setFogSound(Fog.NOFOG);
        this.setRadar(Rtb.NORTB);
        this.setRadio(Cat.NOROS);
        this.setStatus(Sts.UNKSTS);
        this.setConstr(Cns.UNKCNS);
        this.setConsp(Con.UNKCON);
        this.setRefl(Con.UNKCON);
        this.setRef("");
        this.setObjectHeight("");
        this.setElevation("");
        this.setChannel("");
        this.setInfo("");
        this.setSource("");
        this.setFixme("");
        SmedAction.panelMain.syncPanel();
        this.repaint();
    }

    public String validDecimal(String str) {
        if (!(str = str.trim().replace(',', '.')).isEmpty() && !str.matches("^[+-]??\\d+(\\.\\d+)??$")) {
            PanelMain.messageBar.setText(Messages.getString("NotDecimal"));
            return "";
        }
        PanelMain.messageBar.setText("");
        return str;
    }

    public String validDecimal(String str, float max) {
        if (!(str = this.validDecimal(str)).isEmpty() && Float.valueOf(str).floatValue() > max) {
            PanelMain.messageBar.setText(Messages.getString("TooBig") + " (" + max + ")");
            return "";
        }
        PanelMain.messageBar.setText("");
        return str;
    }

    public void parseMark(OsmPrimitive node) {
        PanelMain.messageBar.setText("");
        String str = Main.pref.get("smedplugin.IALA");
        if (str.equals("C")) {
            this.setRegion(Reg.C);
        } else if (str.equals("B")) {
            this.setRegion(Reg.B);
        } else {
            this.setRegion(Reg.A);
        }
        TagMap keys = node.getKeys();
        str = "";
        if (keys.containsKey("seamark:type")) {
            str = (String)keys.get("seamark:type");
        }
        this.clrMark();
        for (Obj obj : ObjSTR.keySet()) {
            if (!ObjSTR.get((Object)obj).equals(str)) continue;
            this.setObject(obj);
        }
        if (str.equals("")) {
            PanelMain.messageBar.setText("No seamark");
        }
        if (this.getObject() == Obj.UNKOBJ) {
            PanelMain.messageBar.setText("Seamark not recognised");
        }
        this.setName("");
        for (Obj obj : ObjSTR.keySet()) {
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":name")) continue;
            str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":name");
            this.setName(str);
        }
        if (keys.containsKey("seamark:name")) {
            str = (String)keys.get("seamark:name");
            this.setName(str);
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":category")) continue;
            str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":category");
            if (obj != this.getObject()) continue;
            this.setCategory(Cat.NOCAT);
            for (Cat cat : CatSTR.keySet()) {
                if (!CatSTR.get((Object)cat).equals(str)) continue;
                this.setCategory(cat);
            }
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":shape")) continue;
            str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":shape");
            this.setShape(Shp.UNKSHP);
            for (Shp shp : ShpSTR.keySet()) {
                if (!ShpSTR.get((Object)shp).equals(str)) continue;
                this.setShape(shp);
            }
        }
        if (this.getShape() == Shp.UNKSHP) {
            if (EntMAP.get((Object)this.getObject()) == Ent.BUOY) {
                this.setShape(Shp.BUOY);
            }
            if (EntMAP.get((Object)this.getObject()) == Ent.BEACON) {
                this.setShape(Shp.BEACON);
            }
            if (EntMAP.get((Object)this.getObject()) == Ent.LFLOAT) {
                if (this.getObject() == Obj.LITVES) {
                    this.setShape(Shp.SUPER);
                } else {
                    this.setShape(Shp.FLOAT);
                }
            }
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":colour")) continue;
            str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":colour");
            this.bodyColour.clear();
            for (Iterator<Enum> iterator : str.split(";")) {
                for (Col col : ColSTR.keySet()) {
                    if (!ColSTR.get((Object)col).equals(iterator)) continue;
                    this.bodyColour.add(col);
                }
            }
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":colour_pattern")) {
                str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":colour_pattern");
                this.setObjPattern(Pat.NOPAT);
                for (Pat pat : PatSTR.keySet()) {
                    if (!PatSTR.get((Object)pat).equals(str)) continue;
                    this.setObjPattern(pat);
                }
            }
            if (keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":height")) {
                this.setObjectHeight((String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":height"));
            }
            if (keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":elevation")) {
                this.setElevation((String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":elevation"));
            }
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":channel")) continue;
            this.setChannel((String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":channel"));
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (!keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":function")) continue;
            str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":function");
            this.setFunc(Fnc.UNKFNC);
            for (Fnc fnc : FncSTR.keySet()) {
                if (!FncSTR.get((Object)fnc).equals(str)) continue;
                this.setFunc(fnc);
            }
        }
        if (this.getObject() == Obj.LNDMRK && this.getCategory() == Cat.NOCAT && this.getFunc() == Fnc.UNKFNC) {
            this.setObject(Obj.LITHSE);
        }
        if (this.getObject() == Obj.LITFLT) {
            switch (this.getObjColour(0)) {
                case RED: {
                    if (this.getObjColour(1) == Col.WHITE && this.getObjColour(2) == Col.UNKCOL) {
                        this.setObject(Obj.FLTSAW);
                        this.setCategory(Cat.NOCAT);
                        break;
                    }
                    if (this.getObjColour(1) == Col.UNKCOL) {
                        this.setObject(Obj.FLTLAT);
                        if (this.getRegion() == Reg.B) {
                            this.setCategory(Cat.LAM_STBD);
                            break;
                        }
                        this.setCategory(Cat.LAM_PORT);
                        break;
                    }
                    if (this.getObjColour(1) == Col.GREEN && this.getObjColour(2) == Col.RED) {
                        this.setObject(Obj.FLTLAT);
                        if (this.getRegion() == Reg.B) {
                            this.setCategory(Cat.LAM_PSTBD);
                            break;
                        }
                        this.setCategory(Cat.LAM_PPORT);
                        break;
                    }
                    if (this.getObjColour(1) == Col.WHITE && this.getObjColour(2) == Col.RED) {
                        this.setObject(Obj.FLTLAT);
                        this.setCategory(Cat.LAM_PORT);
                        break;
                    }
                    this.setObject(Obj.FLTSPP);
                    this.setCategory(Cat.NOCAT);
                    break;
                }
                case GREEN: {
                    if (this.getObjColour(1) == Col.UNKCOL) {
                        this.setObject(Obj.FLTLAT);
                        if (this.getRegion() == Reg.B) {
                            this.setCategory(Cat.LAM_PORT);
                            break;
                        }
                        this.setCategory(Cat.LAM_STBD);
                        break;
                    }
                    if (this.getObjColour(1) == Col.RED && this.getObjColour(2) == Col.GREEN) {
                        this.setObject(Obj.FLTLAT);
                        if (this.getRegion() == Reg.B) {
                            this.setCategory(Cat.LAM_PPORT);
                            break;
                        }
                        this.setCategory(Cat.LAM_PSTBD);
                        break;
                    }
                    if (this.getObjColour(1) == Col.WHITE && this.getObjColour(2) == Col.GREEN) {
                        this.setObject(Obj.FLTLAT);
                        this.setCategory(Cat.LAM_STBD);
                        break;
                    }
                    this.setObject(Obj.FLTSPP);
                    this.setCategory(Cat.NOCAT);
                    break;
                }
                case YELLOW: {
                    if (this.getObjColour(1) == Col.BLACK) {
                        this.setObject(Obj.FLTCAR);
                        if (this.getObjColour(2) == Col.YELLOW) {
                            this.setCategory(Cat.CAM_WEST);
                            break;
                        }
                        this.setCategory(Cat.CAM_SOUTH);
                        break;
                    }
                    this.setObject(Obj.FLTSPP);
                    this.setCategory(Cat.NOCAT);
                    break;
                }
                case BLACK: {
                    if (this.getObjColour(1) == Col.RED) {
                        this.setObject(Obj.FLTISD);
                        this.setCategory(Cat.NOCAT);
                        break;
                    }
                    if (this.getObjColour(1) == Col.YELLOW) {
                        this.setObject(Obj.FLTCAR);
                        if (this.getObjColour(2) == Col.BLACK) {
                            this.setCategory(Cat.CAM_EAST);
                            break;
                        }
                        this.setCategory(Cat.CAM_NORTH);
                        break;
                    }
                    this.setObject(Obj.FLTSPP);
                    this.setCategory(Cat.NOCAT);
                    break;
                }
                default: {
                    this.setCategory(Cat.NOCAT);
                }
            }
        }
        for (Obj obj : ObjSTR.keySet()) {
            if (keys.containsKey("seamark:" + ObjSTR.get((Object)obj) + ":system")) {
                str = (String)keys.get("seamark:" + ObjSTR.get((Object)obj) + ":system");
                if (str.equals("iala-a")) {
                    this.setRegion(Reg.A);
                    continue;
                }
                if (str.equals("iala-b")) {
                    this.setRegion(Reg.B);
                    continue;
                }
                this.setRegion(Reg.C);
                continue;
            }
            if (GrpMAP.get((Object)this.object) != Grp.LAT) continue;
            switch (this.getCategory()) {
                case LAM_PORT: {
                    if (this.getObjColour(0) == Col.RED) {
                        if (this.getObjColour(1) == Col.WHITE) {
                            this.setRegion(Reg.C);
                        } else {
                            this.setRegion(Reg.A);
                        }
                    }
                    if (this.getObjColour(0) != Col.GREEN) break;
                    this.setRegion(Reg.B);
                    break;
                }
                case LAM_PPORT: {
                    if (this.getObjColour(0) == Col.RED) {
                        if (this.getObjColour(3) == Col.GREEN) {
                            this.setRegion(Reg.C);
                        } else {
                            this.setRegion(Reg.B);
                        }
                    }
                    if (this.getObjColour(0) != Col.GREEN) break;
                    this.setRegion(Reg.A);
                    break;
                }
                case LAM_STBD: {
                    if (this.getObjColour(0) == Col.GREEN) {
                        if (this.getObjColour(1) == Col.WHITE) {
                            this.setRegion(Reg.C);
                        } else {
                            this.setRegion(Reg.A);
                        }
                    }
                    if (this.getObjColour(0) != Col.RED) break;
                    this.setRegion(Reg.B);
                    break;
                }
                case LAM_PSTBD: {
                    if (this.getObjColour(0) == Col.GREEN) {
                        this.setRegion(Reg.B);
                    }
                    if (this.getObjColour(0) != Col.RED) break;
                    if (this.getObjColour(3) == Col.GREEN) {
                        this.setRegion(Reg.C);
                        break;
                    }
                    this.setRegion(Reg.A);
                }
            }
        }
        if (keys.containsKey("seamark:topmark:shape")) {
            str = (String)keys.get("seamark:topmark:shape");
            this.setTopmark(Top.NOTOP);
            for (Top top : TopSTR.keySet()) {
                if (!TopSTR.get((Object)top).equals(str)) continue;
                this.setTopmark(top);
            }
        }
        if (keys.containsKey("seamark:topmark:colour")) {
            str = (String)keys.get("seamark:topmark:colour");
            this.setTopColour(Col.UNKCOL);
            for (Col col : ColSTR.keySet()) {
                if (!ColSTR.get((Object)col).equals(str)) continue;
                this.setTopColour(col);
            }
        }
        if (keys.containsKey("seamark:topmark:colour_pattern")) {
            str = (String)keys.get("seamark:topmark:colour_pattern");
            this.setTopPattern(Pat.NOPAT);
            for (Pat pat : PatSTR.keySet()) {
                if (!PatSTR.get((Object)pat).equals(str)) continue;
                this.setTopPattern(pat);
            }
        }
        this.clrLight();
        for (int i = 0; i < 30; ++i) {
            String secStr;
            String string = secStr = i == 0 ? "" : ":" + Integer.toString(i);
            if (keys.containsKey("seamark:light" + secStr + ":colour")) {
                this.nulLight(i);
                str = (String)keys.get("seamark:light" + secStr + ":colour");
                if (str.contains(";")) {
                    String[] strs = str.split(";");
                    for (Col col : ColSTR.keySet()) {
                        if (strs.length <= 1 || !ColSTR.get((Object)col).equals(strs[1])) continue;
                        this.setLightAtt(Att.ALT, i, (Object)col);
                    }
                    str = strs[0];
                }
                for (Col col : ColSTR.keySet()) {
                    if (!ColSTR.get((Object)col).equals(str)) continue;
                    this.setLightAtt(Att.COL, i, (Object)col);
                }
            }
            if (keys.containsKey("seamark:light" + secStr + ":character")) {
                str = (String)keys.get("seamark:light" + secStr + ":character");
                if (str.contains("(") && str.contains(")")) {
                    int i1 = str.indexOf("(");
                    int i2 = str.indexOf(")");
                    this.setLightAtt(Att.GRP, i, (Object)str.substring(i1 + 1, i2));
                    str = str.substring(0, i1) + str.substring(i2 + 1, str.length());
                }
                this.setLightAtt(Att.CHR, i, (Object)str);
            }
            if (keys.containsKey("seamark:light" + secStr + ":group")) {
                this.setLightAtt(Att.GRP, i, keys.get("seamark:light" + secStr + ":group"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":sequence")) {
                this.setLightAtt(Att.SEQ, i, keys.get("seamark:light" + secStr + ":sequence"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":period")) {
                this.setLightAtt(Att.PER, i, keys.get("seamark:light" + secStr + ":period"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":category")) {
                str = (String)keys.get("seamark:light" + secStr + ":category");
                if (str.equals("vert")) {
                    str = "vertical";
                }
                if (str.equals("horiz")) {
                    str = "horizontal";
                }
                for (Lit lit : LitSTR.keySet()) {
                    if (!LitSTR.get((Object)lit).equals(str)) continue;
                    this.setLightAtt(Att.LIT, i, (Object)lit);
                }
            }
            if (keys.containsKey("seamark:light" + secStr + ":sector_start")) {
                this.setLightAtt(Att.BEG, i, keys.get("seamark:light" + secStr + ":sector_start"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":sector_end")) {
                this.setLightAtt(Att.END, i, keys.get("seamark:light" + secStr + ":sector_end"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":radius")) {
                this.setLightAtt(Att.RAD, i, keys.get("seamark:light" + secStr + ":radius"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":height")) {
                this.setLightAtt(Att.HGT, i, keys.get("seamark:light" + secStr + ":height"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":range")) {
                this.setLightAtt(Att.RNG, i, keys.get("seamark:light" + secStr + ":range"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":visibility")) {
                str = (String)keys.get("seamark:light" + secStr + ":visibility");
                for (Vis vis : VisSTR.keySet()) {
                    if (!VisSTR.get((Object)vis).equals(str)) continue;
                    this.setLightAtt(Att.VIS, i, (Object)vis);
                }
            }
            if (keys.containsKey("seamark:light" + secStr + ":exhibition")) {
                str = (String)keys.get("seamark:light" + secStr + ":exhibition");
                for (Exh exh : ExhSTR.keySet()) {
                    if (!ExhSTR.get((Object)exh).equals(str)) continue;
                    this.setLightAtt(Att.EXH, i, (Object)exh);
                }
            }
            if (keys.containsKey("seamark:light" + secStr + ":orientation")) {
                this.setLightAtt(Att.ORT, i, keys.get("seamark:light" + secStr + ":orientation"));
            }
            if (keys.containsKey("seamark:light" + secStr + ":multiple")) {
                this.setLightAtt(Att.MLT, i, keys.get("seamark:light" + secStr + ":multiple"));
            }
            if (this.sectors.size() == i) break;
        }
        if (keys.containsKey("seamark:fog_signal")) {
            this.setFogSound(Fog.FOGSIG);
        }
        if (keys.containsKey("seamark:fog_signal:category")) {
            str = (String)keys.get("seamark:fog_signal:category");
            this.setFogSound(Fog.NOFOG);
            for (Fog fog : FogSTR.keySet()) {
                if (!FogSTR.get((Object)fog).equals(str)) continue;
                this.setFogSound(fog);
            }
        }
        if (keys.containsKey("seamark:fog_signal:group")) {
            this.setFogGroup((String)keys.get("seamark:fog_signal:group"));
        }
        if (keys.containsKey("seamark:fog_signal:period")) {
            this.setFogPeriod((String)keys.get("seamark:fog_signal:period"));
        }
        if (keys.containsKey("seamark:fog_signal:sequence")) {
            this.setFogSequence((String)keys.get("seamark:fog_signal:sequence"));
        }
        if (keys.containsKey("seamark:fog_signal:range")) {
            this.setFogRange((String)keys.get("seamark:fog_signal:range"));
        }
        if (keys.containsKey("seamark:radio_station:category")) {
            str = (String)keys.get("seamark:radio_station:category");
            this.setRadio(Cat.NOROS);
            for (Cat rdo : CatSTR.keySet()) {
                if (!CatSTR.get((Object)rdo).equals(str)) continue;
                this.setRadio(rdo);
            }
        }
        if (keys.containsKey("seamark:radar_reflector")) {
            this.setRadar(Rtb.REFLECTOR);
        }
        if (keys.containsKey("seamark:radar_transponder:category")) {
            str = (String)keys.get("seamark:radar_transponder:category");
            this.setRadar(Rtb.NORTB);
            for (Rtb rtb : RtbSTR.keySet()) {
                if (!RtbSTR.get((Object)rtb).equals(str)) continue;
                this.setRadar(rtb);
            }
        }
        if (keys.containsKey("seamark:radar_transponder:group")) {
            this.setRaconGroup((String)keys.get("seamark:radar_transponder:group"));
        }
        if (keys.containsKey("seamark:radar_transponder:period")) {
            this.setRaconPeriod((String)keys.get("seamark:radar_transponder:period"));
        }
        if (keys.containsKey("seamark:radar_transponder:sequence")) {
            this.setRaconSequence((String)keys.get("seamark:radar_transponder:sequence"));
        }
        if (keys.containsKey("seamark:radar_transponder:range")) {
            this.setRaconRange((String)keys.get("seamark:radar_transponder:range"));
        }
        if (keys.containsKey("seamark:radar_transponder:sector_start")) {
            this.setRaconSector1((String)keys.get("seamark:radar_transponder:sector_start"));
        }
        if (keys.containsKey("seamark:radar_transponder:sector_end")) {
            this.setRaconSector2((String)keys.get("seamark:radar_transponder:sector_end"));
        }
        if (keys.containsKey("seamark:information")) {
            this.setInfo((String)keys.get("seamark:information"));
        }
        if (keys.containsKey("seamark:light:information")) {
            this.setInfo(this.getInfo() + (String)keys.get("seamark:light:information"));
        }
        if (keys.containsKey("seamark:" + ObjSTR.get((Object)this.getObject()) + "information")) {
            this.setInfo(this.getInfo() + (String)keys.get("seamark:" + ObjSTR.get((Object)this.getObject()) + "information"));
        }
        if (keys.containsKey("seamark:source")) {
            this.setSource((String)keys.get("seamark:source"));
        }
        if (keys.containsKey("seamark:light:source")) {
            this.setSource(this.getSource() + (String)keys.get("seamark:light:source"));
        }
        if (keys.containsKey("seamark:" + ObjSTR.get((Object)this.getObject()) + "source")) {
            this.setSource(this.getSource() + (String)keys.get("seamark:" + ObjSTR.get((Object)this.getObject()) + "source"));
        }
        if (keys.containsKey("seamark:height")) {
            this.setObjectHeight((String)keys.get("seamark:height"));
        }
        if (keys.containsKey("seamark:elevation")) {
            this.setElevation((String)keys.get("seamark:elevation"));
        }
        if (keys.containsKey("seamark:status")) {
            str = (String)keys.get("seamark:status");
            this.setStatus(Sts.UNKSTS);
            for (Sts sts : StsSTR.keySet()) {
                if (!StsSTR.get((Object)sts).equals(str)) continue;
                this.setStatus(sts);
            }
        }
        if (keys.containsKey("seamark:construction")) {
            str = (String)keys.get("seamark:construction");
            this.setConstr(Cns.UNKCNS);
            for (Cns cns : CnsSTR.keySet()) {
                if (!CnsSTR.get((Object)cns).equals(str)) continue;
                this.setConstr(cns);
            }
        }
        if (keys.containsKey("seamark:conspicuity")) {
            str = (String)keys.get("seamark:conspicuity");
            this.setConsp(Con.UNKCON);
            for (Con con : ConSTR.keySet()) {
                if (!ConSTR.get((Object)con).equals(str)) continue;
                this.setConsp(con);
            }
        }
        if (keys.containsKey("seamark:reflectivity")) {
            str = (String)keys.get("seamark:reflectivity");
            this.setRefl(Con.UNKCON);
            for (Con con : ConSTR.keySet()) {
                if (!ConSTR.get((Object)con).equals(str)) continue;
                this.setRefl(con);
            }
        }
        if (keys.containsKey("seamark:ref")) {
            this.setRef((String)keys.get("seamark:ref"));
        }
        if (keys.containsKey("seamark:reference")) {
            this.setRef((String)keys.get("seamark:reference"));
        }
        if (keys.containsKey("seamark:light:ref")) {
            this.setLightRef((String)keys.get("seamark:light:ref"));
        }
        if (keys.containsKey("seamark:light:reference")) {
            this.setLightRef((String)keys.get("seamark:light:reference"));
        }
        if (keys.containsKey("seamark:fixme")) {
            this.setFixme((String)keys.get("seamark:fixme"));
        }
        SmedAction.panelMain.syncPanel();
    }

    @Override
    public void paintComponent(Graphics g) {
        String colStr;
        super.paintComponent(g);
        if (this.dlg.node == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String imgStr = "/images/";
        if (this.getShape() != Shp.UNKSHP) {
            switch (this.getShape()) {
                case TOWER: {
                    imgStr = imgStr + "Tower";
                    break;
                }
                case BUOY: 
                case PILLAR: {
                    imgStr = imgStr + "Pillar";
                    break;
                }
                case SPAR: {
                    imgStr = imgStr + "Spar";
                    break;
                }
                case CAN: {
                    imgStr = imgStr + "Can";
                    break;
                }
                case CONI: {
                    imgStr = imgStr + "Cone";
                    break;
                }
                case SPHERI: {
                    imgStr = imgStr + "Sphere";
                    break;
                }
                case BARREL: {
                    imgStr = imgStr + "Barrel";
                    break;
                }
                case CAIRN: {
                    imgStr = imgStr + "Cairn";
                    break;
                }
                case FLOAT: {
                    imgStr = imgStr + "Float";
                    break;
                }
                case BEACON: 
                case PILE: 
                case LATTICE: 
                case BUOYANT: {
                    imgStr = imgStr + "Beacon";
                    break;
                }
                case SUPER: {
                    imgStr = imgStr + "Super";
                    break;
                }
                case STAKE: 
                case POLE: 
                case POST: {
                    imgStr = imgStr + "Stake";
                    break;
                }
                case PERCH: {
                    imgStr = this.getCategory() == Cat.LAM_PORT ? imgStr + "Perch_Port" : imgStr + "Perch_Starboard";
                }
            }
            colStr = imgStr;
            String lblStr = "";
            for (Col col : this.bodyColour) {
                switch (col) {
                    case WHITE: {
                        colStr = colStr + "_White";
                        lblStr = lblStr + "W";
                        break;
                    }
                    case RED: {
                        colStr = colStr + "_Red";
                        lblStr = lblStr + "R";
                        break;
                    }
                    case ORANGE: {
                        colStr = colStr + "_Orange";
                        lblStr = lblStr + "Or";
                        break;
                    }
                    case AMBER: {
                        colStr = colStr + "_Amber";
                        lblStr = lblStr + "Am";
                        break;
                    }
                    case YELLOW: {
                        colStr = colStr + "_Yellow";
                        lblStr = lblStr + "Y";
                        break;
                    }
                    case GREEN: {
                        colStr = colStr + "_Green";
                        lblStr = lblStr + "G";
                        break;
                    }
                    case BLUE: {
                        colStr = colStr + "_Blue";
                        lblStr = lblStr + "Bu";
                        break;
                    }
                    case VIOLET: {
                        colStr = colStr + "_Violet";
                        lblStr = lblStr + "Vi";
                        break;
                    }
                    case BLACK: {
                        colStr = colStr + "_Black";
                        lblStr = lblStr + "B";
                        break;
                    }
                    case GREY: {
                        colStr = colStr + "_Grey";
                        lblStr = lblStr + "Gr";
                        break;
                    }
                    case BROWN: {
                        colStr = colStr + "_Brown";
                        lblStr = lblStr + "Br";
                        break;
                    }
                    case MAGENTA: {
                        colStr = colStr + "_Magenta";
                        lblStr = lblStr + "Mg";
                        break;
                    }
                    case PINK: {
                        colStr = colStr + "_Pink";
                        lblStr = lblStr + "Pk";
                    }
                }
            }
            if (!imgStr.equals("/images/")) {
                colStr = colStr + ".png";
                if (this.getClass().getResource(colStr) == null) {
                    System.out.println("Missing image1: " + colStr);
                    imgStr = imgStr + ".png";
                    if (this.getClass().getResource(imgStr) == null) {
                        System.out.println("Missing image2: " + imgStr);
                    } else {
                        g2.drawImage(new ImageIcon(this.getClass().getResource(imgStr)).getImage(), 7, -15, null);
                        g2.drawString(lblStr, 75, 110);
                    }
                } else {
                    g2.drawImage(new ImageIcon(this.getClass().getResource(colStr)).getImage(), 7, -15, null);
                }
            }
        } else if (this.getObject() != Obj.UNKOBJ) {
            switch (this.getObject()) {
                case LNDMRK: {
                    block47 : switch (this.getCategory()) {
                        case LMK_CHMY: {
                            imgStr = imgStr + "Chimney";
                            break;
                        }
                        case LMK_CARN: {
                            imgStr = imgStr + "Cairn";
                            break;
                        }
                        case LMK_DSHA: {
                            imgStr = imgStr + "DishAerial";
                            break;
                        }
                        case LMK_FLGS: {
                            imgStr = imgStr + "Flagstaff";
                            break;
                        }
                        case LMK_FLRS: {
                            imgStr = imgStr + "FlareStack";
                            break;
                        }
                        case LMK_MNMT: 
                        case LMK_CLMN: 
                        case LMK_OBLK: 
                        case LMK_STAT: {
                            imgStr = imgStr + "Monument";
                            break;
                        }
                        case LMK_MAST: {
                            imgStr = imgStr + "RadioMast";
                            break;
                        }
                        case LMK_TOWR: {
                            if (this.getFunc() == Fnc.CHCH || this.getFunc() == Fnc.CHPL) {
                                imgStr = imgStr + "ChurchTower";
                                break;
                            }
                            imgStr = imgStr + "LandTower";
                            break;
                        }
                        case LMK_WNDM: {
                            imgStr = imgStr + "Wind_Motor";
                            break;
                        }
                        case LMK_WTRT: {
                            imgStr = imgStr + "WaterTower";
                            break;
                        }
                        case LMK_DOME: {
                            if (this.getFunc() == Fnc.CHCH || this.getFunc() == Fnc.CHPL) {
                                imgStr = imgStr + "ChurchDome";
                                break;
                            }
                            imgStr = imgStr + "Dome";
                            break;
                        }
                        case LMK_SPIR: {
                            if (this.getFunc() == Fnc.CHCH || this.getFunc() == Fnc.CHPL) {
                                imgStr = imgStr + "ChurchSpire";
                                break;
                            }
                            imgStr = imgStr + "Spire";
                            break;
                        }
                        case LMK_MNRT: {
                            imgStr = imgStr + "Minaret";
                            break;
                        }
                        case LMK_WNDS: {
                            imgStr = imgStr + "Windsock";
                            break;
                        }
                        case LMK_CROS: {
                            imgStr = imgStr + "Cross";
                            break;
                        }
                        case LMK_SCNR: {
                            imgStr = imgStr + "Signal_Station";
                            break;
                        }
                        case LMK_WNDL: {
                            imgStr = imgStr + "Windmill";
                            break;
                        }
                        case NOCAT: {
                            switch (this.getFunc()) {
                                case CHCH: 
                                case CHPL: {
                                    imgStr = imgStr + "Church";
                                    break block47;
                                }
                                case TMPL: 
                                case PGDA: 
                                case SHSH: 
                                case BTMP: {
                                    imgStr = imgStr + "Temple";
                                    break block47;
                                }
                                case MOSQ: {
                                    imgStr = imgStr + "Minaret";
                                    break block47;
                                }
                                case MRBT: {
                                    imgStr = imgStr + "Spire";
                                }
                            }
                        }
                    }
                    break;
                }
                case LITHSE: {
                    imgStr = imgStr + "Light_House";
                    break;
                }
                case LITMAJ: {
                    imgStr = imgStr + "Light_Major";
                    break;
                }
                case LITMIN: {
                    imgStr = imgStr + "Light_Minor";
                    break;
                }
                case LITFLT: {
                    imgStr = imgStr + "Float";
                    break;
                }
                case LITVES: {
                    imgStr = imgStr + "Super";
                    break;
                }
                case SISTAW: {
                    imgStr = imgStr + "Signal_Station";
                    break;
                }
                case SISTAT: {
                    imgStr = imgStr + "Signal_Station";
                    break;
                }
                case OFSPLF: {
                    if (this.getCategory() == Cat.OFP_FPSO) {
                        imgStr = imgStr + "Storage";
                        break;
                    }
                    imgStr = imgStr + "Platform";
                    break;
                }
                case MORFAC: {
                    switch (this.getCategory()) {
                        case MOR_DLPN: {
                            imgStr = imgStr + "Dolphin";
                            break;
                        }
                        case MOR_DDPN: {
                            imgStr = imgStr + "DeviationDolphin";
                            break;
                        }
                        case MOR_POST: {
                            imgStr = imgStr + "Post";
                            break;
                        }
                        case MOR_BUOY: {
                            imgStr = imgStr + "Sphere";
                        }
                    }
                    break;
                }
                case BOYINB: {
                    imgStr = imgStr + "Super";
                    break;
                }
                case CGUSTA: {
                    imgStr = imgStr + "Signal_Station";
                    break;
                }
                case PILBOP: {
                    imgStr = imgStr + "Pilot";
                    break;
                }
                case RSCSTA: {
                    imgStr = imgStr + "Rescue";
                    break;
                }
                case RDOSTA: 
                case RADSTA: {
                    imgStr = imgStr + "Signal_Station";
                    g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Radar_Station.png")).getImage(), 7, -15, null);
                }
            }
            if (!imgStr.equals("/images/")) {
                imgStr = imgStr + ".png";
                if (this.getClass().getResource(imgStr) == null) {
                    System.out.println("Missing image3: " + imgStr);
                } else {
                    g2.drawImage(new ImageIcon(this.getClass().getResource(imgStr)).getImage(), 7, -15, null);
                }
            }
        }
        if (this.getTopmark() != Top.NOTOP) {
            imgStr = "/images/Top_";
            switch (this.getTopmark()) {
                case CYL: {
                    imgStr = imgStr + "Can";
                    break;
                }
                case CONE: {
                    imgStr = imgStr + "Cone";
                    break;
                }
                case SPHERE: {
                    imgStr = imgStr + "Sphere";
                    break;
                }
                case X_SHAPE: {
                    imgStr = imgStr + "X";
                    break;
                }
                case NORTH: {
                    imgStr = imgStr + "North";
                    break;
                }
                case SOUTH: {
                    imgStr = imgStr + "South";
                    break;
                }
                case EAST: {
                    imgStr = imgStr + "East";
                    break;
                }
                case WEST: {
                    imgStr = imgStr + "West";
                    break;
                }
                case SPHERES2: {
                    imgStr = imgStr + "Isol";
                }
            }
            colStr = imgStr;
            for (Col col : this.topmarkColour) {
                switch (col) {
                    case WHITE: {
                        colStr = colStr + "_White";
                        break;
                    }
                    case RED: {
                        colStr = colStr + "_Red";
                        break;
                    }
                    case ORANGE: {
                        colStr = colStr + "_Orange";
                        break;
                    }
                    case AMBER: {
                        colStr = colStr + "_Amber";
                        break;
                    }
                    case YELLOW: {
                        colStr = colStr + "_Yellow";
                        break;
                    }
                    case GREEN: {
                        colStr = colStr + "_Green";
                        break;
                    }
                    case BLUE: {
                        colStr = colStr + "_Blue";
                        break;
                    }
                    case VIOLET: {
                        colStr = colStr + "_Violet";
                        break;
                    }
                    case BLACK: {
                        colStr = colStr + "_Black";
                    }
                }
            }
            switch (this.getShape()) {
                case CAN: 
                case CONI: 
                case SPHERI: 
                case BARREL: {
                    imgStr = imgStr + "_Buoy_Small";
                    colStr = colStr + "_Buoy_Small";
                    break;
                }
                case PILLAR: 
                case SPAR: {
                    imgStr = imgStr + "_Buoy";
                    colStr = colStr + "_Buoy";
                    break;
                }
                case FLOAT: 
                case SUPER: {
                    imgStr = imgStr + "_Float";
                    colStr = colStr + "_Float";
                    break;
                }
                case TOWER: 
                case CAIRN: 
                case BEACON: 
                case PILE: 
                case LATTICE: 
                case BUOYANT: 
                case STAKE: 
                case POLE: 
                case POST: {
                    imgStr = imgStr + "_Beacon";
                    colStr = colStr + "_Beacon";
                }
            }
            colStr = colStr + ".png";
            if (this.getClass().getResource(colStr) == null) {
                System.out.println("Missing image4: " + colStr);
                imgStr = imgStr + ".png";
                if (this.getClass().getResource(imgStr) == null) {
                    System.out.println("Missing image5: " + imgStr);
                    return;
                }
                g2.drawImage(new ImageIcon(this.getClass().getResource(imgStr)).getImage(), 7, -15, null);
            } else {
                g2.drawImage(new ImageIcon(this.getClass().getResource(colStr)).getImage(), 7, -15, null);
            }
        } else if (this.getObject() == Obj.BOYINB || this.getObject() == Obj.MORFAC && this.getCategory() == Cat.MOR_BUOY) {
            imgStr = "/images/Top_Mooring";
            switch (this.getShape()) {
                case CAN: 
                case CONI: 
                case SPHERI: 
                case BARREL: {
                    imgStr = imgStr + "_Buoy_Small";
                    break;
                }
                case FLOAT: 
                case SUPER: {
                    imgStr = imgStr + "_Float";
                    break;
                }
                default: {
                    imgStr = this.getObject() == Obj.MORFAC ? imgStr + "_Buoy_Small" : imgStr + "_Float";
                }
            }
            imgStr = imgStr + ".png";
            if (this.getClass().getResource(imgStr) == null) {
                System.out.println("Missing image6: " + imgStr);
                return;
            }
            g2.drawImage(new ImageIcon(this.getClass().getResource(imgStr)).getImage(), 7, -15, null);
        }
        for (int i = 1; i < this.sectors.size(); ++i) {
            Double da;
            Double a0;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(6.0f));
            if (!((String)this.getLightAtt(Att.BEG, i)).isEmpty() && !((String)this.getLightAtt(Att.END, i)).isEmpty()) {
                if (this.getLightAtt(Att.COL, i) != Col.UNKCOL) {
                    g2.setPaint(ColMAP.get(this.getLightAtt(Att.COL, i)));
                    a0 = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.BEG, i));
                    da = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.END, i)) - a0;
                    da = da - (da > 0.0 ? 360.0 : 0.0);
                    g2.draw(new Arc2D.Double(12.0, 15.0, 140.0, 140.0, a0, da, 0));
                }
                if (this.getLightAtt(Att.ALT, i) == Col.UNKCOL) continue;
                g2.setPaint(ColMAP.get(this.getLightAtt(Att.ALT, i)));
                a0 = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.BEG, i));
                da = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.END, i)) - a0;
                da = da - (da > 0.0 ? 360.0 : 0.0);
                g2.draw(new Arc2D.Double(17.0, 20.0, 130.0, 130.0, a0, da, 0));
                continue;
            }
            if (this.getLightAtt(Att.LIT, i) != Lit.DIR || ((String)this.getLightAtt(Att.ORT, i)).isEmpty()) continue;
            if (this.getLightAtt(Att.COL, i) != Col.UNKCOL) {
                g2.setPaint(ColMAP.get(this.getLightAtt(Att.COL, i)));
                a0 = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.ORT, i)) + 2.0;
                da = -4.0;
                g2.draw(new Arc2D.Double(12.0, 15.0, 140.0, 140.0, a0, da, 0));
            }
            if (this.getLightAtt(Att.ALT, i) == Col.UNKCOL) continue;
            g2.setPaint(ColMAP.get(this.getLightAtt(Att.ALT, i)));
            a0 = 270.0 - Double.parseDouble((String)this.getLightAtt(Att.ORT, i)) + 2.0;
            da = -4.0;
            g2.draw(new Arc2D.Double(17.0, 20.0, 130.0, 130.0, a0, da, 0));
        }
        g2.setPaint(Color.BLACK);
        if (this.getLightAtt(Att.COL, 0) != Col.UNKCOL || !((String)this.getLightAtt(Att.CHR, 0)).isEmpty()) {
            if (this.sectors.size() == 1) {
                if (((String)this.getLightAtt(Att.CHR, 0)).contains("Al")) {
                    g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Light_Magenta_120.png")).getImage(), 7, -15, null);
                } else {
                    switch ((Col)((Object)this.getLightAtt(Att.COL, 0))) {
                        case RED: {
                            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Light_Red_120.png")).getImage(), 7, -15, null);
                            break;
                        }
                        case GREEN: {
                            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Light_Green_120.png")).getImage(), 7, -15, null);
                            break;
                        }
                        case YELLOW: 
                        case WHITE: {
                            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Light_White_120.png")).getImage(), 7, -15, null);
                            break;
                        }
                        default: {
                            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Light_Magenta_120.png")).getImage(), 7, -15, null);
                        }
                    }
                }
            }
            String c = (String)this.getLightAtt(Att.CHR, 0);
            String tmp = "";
            if (c.contains("+")) {
                int i1 = c.indexOf("+");
                tmp = c.substring(i1, c.length());
                c = c.substring(0, i1);
                if (!((String)this.getLightAtt(Att.GRP, 0)).isEmpty()) {
                    c = c + "(" + (String)this.getLightAtt(Att.GRP, 0) + ")";
                }
                if (tmp != null) {
                    c = c + tmp;
                }
            } else if (!((String)this.getLightAtt(Att.GRP, 0)).isEmpty()) {
                c = c + "(" + (String)this.getLightAtt(Att.GRP, 0) + ")";
            }
            switch ((Col)((Object)this.getLightAtt(Att.COL, 0))) {
                case WHITE: {
                    c = c + ".W";
                    break;
                }
                case YELLOW: {
                    c = c + ".Y";
                    break;
                }
                case RED: {
                    c = c + ".R";
                    break;
                }
                case GREEN: {
                    c = c + ".G";
                    break;
                }
                case AMBER: {
                    c = c + ".Am";
                    break;
                }
                case ORANGE: {
                    c = c + ".Or";
                    break;
                }
                case BLUE: {
                    c = c + ".Bu";
                    break;
                }
                case VIOLET: {
                    c = c + ".Vi";
                }
            }
            switch ((Col)((Object)this.getLightAtt(Att.ALT, 0))) {
                case WHITE: {
                    c = c + "W";
                    break;
                }
                case YELLOW: {
                    c = c + "Y";
                    break;
                }
                case RED: {
                    c = c + "R";
                    break;
                }
                case GREEN: {
                    c = c + "G";
                    break;
                }
                case AMBER: {
                    c = c + "Am";
                    break;
                }
                case ORANGE: {
                    c = c + "Or";
                    break;
                }
                case BLUE: {
                    c = c + "Bu";
                    break;
                }
                case VIOLET: {
                    c = c + "Vi";
                }
            }
            tmp = (String)this.getLightAtt(Att.MLT, 0);
            if (!tmp.isEmpty()) {
                c = tmp + c;
            }
            if (this.getLightAtt(Att.LIT, 0) != Lit.UNKLIT) {
                switch ((Lit)((Object)this.getLightAtt(Att.LIT, 0))) {
                    case VERT: {
                        c = c + "(Vert)";
                        break;
                    }
                    case HORIZ: {
                        c = c + "(Horiz)";
                    }
                }
            }
            if (!(tmp = (String)this.getLightAtt(Att.PER, 0)).isEmpty()) {
                c = c + " " + tmp + "s";
            }
            g2.drawString(c, 100, 70);
        }
        if (this.getFogSound() != Fog.NOFOG) {
            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Fog_Signal.png")).getImage(), 7, -15, null);
            String str = "";
            if (this.getFogSound() != Fog.FOGSIG) {
                switch (this.getFogSound()) {
                    case HORN: {
                        str = "Horn";
                        break;
                    }
                    case SIREN: {
                        str = "Siren";
                        break;
                    }
                    case DIA: {
                        str = "Dia";
                        break;
                    }
                    case BELL: {
                        str = "Bell";
                        break;
                    }
                    case WHIS: {
                        str = "Whis";
                        break;
                    }
                    case GONG: {
                        str = "Gong";
                        break;
                    }
                    case EXPLOS: {
                        str = "Explos";
                    }
                }
            }
            str = !this.getFogGroup().isEmpty() ? str + "(" + this.getFogGroup() + ")" : str + " ";
            if (!this.getFogPeriod().isEmpty()) {
                str = str + this.getFogPeriod() + "s";
            }
            g2.drawString(str, 0, 70);
        }
        if (this.RaType != Rtb.NORTB) {
            if (this.getRadar() == Rtb.REFLECTOR) {
                g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Radar_Reflector_355.png")).getImage(), 7, -15, null);
            } else {
                g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Radar_Station.png")).getImage(), 7, -15, null);
                String str = "";
                str = this.getRadar() == Rtb.RAMARK ? str + "Ramark" : str + "Racon";
                str = !this.getRaconGroup().isEmpty() ? str + "(" + this.getRaconGroup() + ")" : str + " ";
                if (!this.getRaconPeriod().isEmpty()) {
                    str = str + this.getRaconPeriod() + "s";
                }
                g2.drawString(str, 0, 50);
            }
        }
        if (this.RoType != Cat.NOROS) {
            g2.drawImage(new ImageIcon(this.getClass().getResource("/images/Radar_Station.png")).getImage(), 7, -15, null);
            g2.drawString("AIS", 0, 30);
        }
    }

    public void saveSign(OsmPrimitive node) {
        if (this.getObject() != Obj.UNKOBJ) {
            int i;
            int i2;
            String objStr;
            String str2;
            Main.pref.put("smedplugin.IALA", this.getRegion() == Reg.C ? "C" : (this.getRegion() == Reg.B ? "B" : "A"));
            for (String str2 : node.getKeys().keySet()) {
                if (!str2.trim().matches("^seamark:\\S+")) continue;
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, str2, null));
            }
            if (!this.getName().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:name", this.getName()));
            }
            if ((objStr = ObjSTR.get((Object)this.object)) != null) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:type", objStr));
                if (this.getShape() != Shp.FLOAT) {
                    str2 = CatSTR.get((Object)this.getCategory());
                    if (str2 != null) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":category", str2));
                    }
                    if (this.getShape() != Shp.BUOY && this.getShape() != Shp.BEACON) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":shape", ShpSTR.get((Object)this.getShape())));
                    }
                }
                if (this.getObjColour(0) != Col.UNKCOL && this.getShape() != Shp.PERCH) {
                    str2 = ColSTR.get((Object)this.getObjColour(0));
                    for (i2 = 1; this.bodyColour.size() > i2; ++i2) {
                        str2 = str2 + ";" + ColSTR.get((Object)this.getObjColour(i2));
                    }
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":colour", str2));
                }
                if (this.getObjPattern() != Pat.NOPAT) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":colour_pattern", PatSTR.get((Object)this.getObjPattern())));
                }
                if (this.getFunc() != Fnc.UNKFNC) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":function", FncSTR.get((Object)this.getFunc())));
                }
                if (GrpMAP.get((Object)this.object) == Grp.LAT && this.getShape() != Shp.PERCH || this.getObject() == Obj.FLTLAT) {
                    switch (this.region) {
                        case A: {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":system", "iala-a"));
                            break;
                        }
                        case B: {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":system", "iala-b"));
                            break;
                        }
                        case C: {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":system", "other"));
                        }
                    }
                }
                if (!this.getObjectHeight().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":height", this.getObjectHeight()));
                }
                if (!this.getElevation().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":elevation", this.getElevation()));
                }
                if (!this.getChannel().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:" + objStr + ":channel", this.getChannel()));
                }
            }
            if (this.getTopmark() != Top.NOTOP) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:topmark:shape", TopSTR.get((Object)this.getTopmark())));
                if (this.getTopPattern() != Pat.NOPAT) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:topmark:colour_pattern", PatSTR.get((Object)this.getTopPattern())));
                }
                if (this.getTopColour(0) != Col.UNKCOL) {
                    str2 = ColSTR.get((Object)this.getTopColour(0));
                    for (i2 = 1; this.topmarkColour.size() > i2; ++i2) {
                        str2 = str2 + ";" + ColSTR.get((Object)this.getTopColour(i2));
                    }
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:topmark:colour", str2));
                }
            }
            int n = i = this.sectors.size() > 1 ? 1 : 0;
            while (i < this.sectors.size()) {
                String secStr;
                String string = secStr = i == 0 ? "" : ":" + Integer.toString(i);
                if (this.sectors.get(i)[0] != Col.UNKCOL) {
                    if (this.sectors.get(i)[15] != Col.UNKCOL && ((String)this.sectors.get(i)[1]).contains("Al")) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":colour", ColSTR.get(this.sectors.get(i)[0]) + ";" + ColSTR.get(this.sectors.get(i)[15])));
                    } else {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":colour", ColSTR.get(this.sectors.get(i)[0])));
                    }
                }
                if (!((String)this.sectors.get(i)[1]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":character", (String)this.sectors.get(i)[1]));
                } else if (!((String)this.sectors.get(0)[1]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":character", (String)this.sectors.get(0)[1]));
                }
                if (!((String)this.sectors.get(i)[2]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":group", (String)this.sectors.get(i)[2]));
                } else if (!((String)this.sectors.get(0)[2]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":group", (String)this.sectors.get(0)[2]));
                }
                if (!((String)this.sectors.get(i)[3]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":sequence", (String)this.sectors.get(i)[3]));
                } else if (!((String)this.sectors.get(0)[3]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":sequence", (String)this.sectors.get(0)[3]));
                }
                if (!((String)this.sectors.get(i)[4]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":period", (String)this.sectors.get(i)[4]));
                } else if (!((String)this.sectors.get(0)[4]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":period", (String)this.sectors.get(0)[4]));
                }
                if (this.sectors.get(i)[5] != Lit.UNKLIT) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":category", LitSTR.get(this.sectors.get(i)[5])));
                } else if (this.sectors.get(0)[5] != Lit.UNKLIT) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":category", LitSTR.get(this.sectors.get(0)[5])));
                }
                if (!((String)this.sectors.get(i)[6]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":sector_start", (String)this.sectors.get(i)[6]));
                }
                if (!((String)this.sectors.get(i)[7]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":sector_end", (String)this.sectors.get(i)[7]));
                }
                if (!((String)this.sectors.get(i)[8]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":radius", (String)this.sectors.get(i)[8]));
                } else if (!((String)this.sectors.get(0)[8]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":radius", (String)this.sectors.get(0)[8]));
                }
                if (!((String)this.sectors.get(i)[9]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":height", (String)this.sectors.get(i)[9]));
                } else if (!((String)this.sectors.get(0)[9]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":height", (String)this.sectors.get(0)[9]));
                }
                if (!((String)this.sectors.get(i)[10]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":range", (String)this.sectors.get(i)[10]));
                } else if (!((String)this.sectors.get(0)[10]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":range", (String)this.sectors.get(0)[10]));
                }
                if (this.sectors.get(i)[11] != Vis.UNKVIS) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":visibility", VisSTR.get(this.sectors.get(i)[11])));
                } else if (this.sectors.get(0)[11] != Vis.UNKVIS) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":visibility", VisSTR.get(this.sectors.get(0)[11])));
                }
                if (this.sectors.get(i)[12] != Exh.UNKEXH) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":exhibition", ExhSTR.get(this.sectors.get(i)[12])));
                } else if (this.sectors.get(0)[12] != Exh.UNKEXH) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":exhibition", ExhSTR.get(this.sectors.get(0)[12])));
                }
                if (!((String)this.sectors.get(i)[13]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":orientation", (String)this.sectors.get(i)[13]));
                }
                if (!((String)this.sectors.get(i)[14]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":multiple", (String)this.sectors.get(i)[14]));
                } else if (!((String)this.sectors.get(0)[14]).isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light" + secStr + ":multiple", (String)this.sectors.get(0)[14]));
                }
                ++i;
            }
            if (this.getFogSound() != Fog.NOFOG) {
                if (this.getFogSound() == Fog.FOGSIG) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal", "yes"));
                } else {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal:category", FogSTR.get((Object)this.getFogSound())));
                }
                if (!this.getFogGroup().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal:group", this.getFogGroup()));
                }
                if (!this.getFogPeriod().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal:period", this.getFogPeriod()));
                }
                if (!this.getFogSequence().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal:sequence", this.getFogSequence()));
                }
                if (!this.getFogRange().isEmpty()) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fog_signal:range", this.getFogRange()));
                }
            }
            if (this.RoType != Cat.NOROS) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radio_station:category", CatSTR.get((Object)this.getRadio())));
            }
            if (this.RaType != Rtb.NORTB) {
                if (this.getRadar() == Rtb.REFLECTOR) {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_reflector", "yes"));
                } else {
                    Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:category", RtbSTR.get((Object)this.getRadar())));
                    if (!this.getRaconGroup().isEmpty()) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:group", this.getRaconGroup()));
                    }
                    if (!this.getRaconPeriod().isEmpty()) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:period", this.getRaconPeriod()));
                    }
                    if (!this.getRaconSequence().isEmpty()) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:sequence", this.getRaconSequence()));
                    }
                    if (!this.getRaconRange().isEmpty()) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:range", this.getRaconRange()));
                    }
                    if (!this.getRaconSector1().isEmpty() && !this.getRaconSector2().isEmpty()) {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:sector_start", this.getRaconSector1()));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:radar_transponder:sector_end", this.getRaconSector2()));
                    }
                }
            }
            if (!this.getInfo().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:information", this.getInfo()));
            }
            if (!this.getSource().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:source", this.getSource()));
            }
            if (this.getStatus() != Sts.UNKSTS) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:status", StsSTR.get((Object)this.getStatus())));
            }
            if (this.getConstr() != Cns.UNKCNS) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:construction", CnsSTR.get((Object)this.getConstr())));
            }
            if (this.getConsp() != Con.UNKCON) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:conspicuity", ConSTR.get((Object)this.getConsp())));
            }
            if (this.getRefl() != Con.UNKCON) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:reflectivity", ConSTR.get((Object)this.getRefl())));
            }
            if (!this.getRef().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:reference", this.getRef()));
            }
            if (!this.getLightRef().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:light:reference", this.getLightRef()));
            }
            if (!this.getFixme().isEmpty()) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand(node, "seamark:fixme", this.getFixme()));
            }
        }
    }

    static {
        RegSTR.put(Reg.A, "iala-a");
        RegSTR.put(Reg.B, "iala-b");
        RegSTR.put(Reg.C, "cevni");
        RegSTR.put(Reg.R, "riwr");
        RegSTR.put(Reg.X, "other");
        ObjSTR = new EnumMap(Obj.class);
        ObjSTR.put(Obj.BCNCAR, "beacon_cardinal");
        ObjSTR.put(Obj.BCNISD, "beacon_isolated_danger");
        ObjSTR.put(Obj.BCNLAT, "beacon_lateral");
        ObjSTR.put(Obj.BCNSAW, "beacon_safe_water");
        ObjSTR.put(Obj.BCNSPP, "beacon_special_purpose");
        ObjSTR.put(Obj.BOYCAR, "buoy_cardinal");
        ObjSTR.put(Obj.BOYISD, "buoy_isolated_danger");
        ObjSTR.put(Obj.BOYLAT, "buoy_lateral");
        ObjSTR.put(Obj.BOYSAW, "buoy_safe_water");
        ObjSTR.put(Obj.BOYSPP, "buoy_special_purpose");
        ObjSTR.put(Obj.FLTCAR, "light_float");
        ObjSTR.put(Obj.FLTLAT, "light_float");
        ObjSTR.put(Obj.FLTSAW, "light_float");
        ObjSTR.put(Obj.FLTISD, "light_float");
        ObjSTR.put(Obj.FLTSPP, "light_float");
        ObjSTR.put(Obj.LITMAJ, "light_major");
        ObjSTR.put(Obj.LITMIN, "light_minor");
        ObjSTR.put(Obj.LITFLT, "light_float");
        ObjSTR.put(Obj.LITVES, "light_vessel");
        ObjSTR.put(Obj.NOTMRK, "notice");
        ObjSTR.put(Obj.LNDMRK, "landmark");
        ObjSTR.put(Obj.LITHSE, "landmark");
        ObjSTR.put(Obj.MORFAC, "mooring");
        ObjSTR.put(Obj.BOYINB, "buoy_installation");
        ObjSTR.put(Obj.OFSPLF, "platform");
        ObjSTR.put(Obj.SISTAW, "signal_station_warning");
        ObjSTR.put(Obj.SISTAT, "signal_station_traffic");
        ObjSTR.put(Obj.CGUSTA, "coastguard_station");
        ObjSTR.put(Obj.PILBOP, "pilot_boarding");
        ObjSTR.put(Obj.RSCSTA, "rescue_station");
        ObjSTR.put(Obj.RDOSTA, "radio_station");
        ObjSTR.put(Obj.RADSTA, "radar_station");
        EntMAP = new EnumMap(Obj.class);
        EntMAP.put(Obj.BCNCAR, Ent.BEACON);
        EntMAP.put(Obj.BCNISD, Ent.BEACON);
        EntMAP.put(Obj.BCNLAT, Ent.BEACON);
        EntMAP.put(Obj.BCNSAW, Ent.BEACON);
        EntMAP.put(Obj.BCNSPP, Ent.BEACON);
        EntMAP.put(Obj.BOYCAR, Ent.BUOY);
        EntMAP.put(Obj.BOYISD, Ent.BUOY);
        EntMAP.put(Obj.BOYLAT, Ent.BUOY);
        EntMAP.put(Obj.BOYSAW, Ent.BUOY);
        EntMAP.put(Obj.BOYSPP, Ent.BUOY);
        EntMAP.put(Obj.LITMAJ, Ent.LIGHT);
        EntMAP.put(Obj.LITMIN, Ent.LIGHT);
        EntMAP.put(Obj.LITFLT, Ent.LFLOAT);
        EntMAP.put(Obj.FLTCAR, Ent.LFLOAT);
        EntMAP.put(Obj.FLTLAT, Ent.LFLOAT);
        EntMAP.put(Obj.FLTSAW, Ent.LFLOAT);
        EntMAP.put(Obj.FLTISD, Ent.LFLOAT);
        EntMAP.put(Obj.FLTSPP, Ent.LFLOAT);
        EntMAP.put(Obj.LITVES, Ent.LFLOAT);
        EntMAP.put(Obj.LITHSE, Ent.LIGHT);
        EntMAP.put(Obj.LNDMRK, Ent.LIGHT);
        EntMAP.put(Obj.MORFAC, Ent.MOORING);
        EntMAP.put(Obj.BOYINB, Ent.MOORING);
        EntMAP.put(Obj.OFSPLF, Ent.PLATFORM);
        EntMAP.put(Obj.SISTAW, Ent.STATION);
        EntMAP.put(Obj.SISTAT, Ent.STATION);
        EntMAP.put(Obj.CGUSTA, Ent.STATION);
        EntMAP.put(Obj.PILBOP, Ent.STATION);
        EntMAP.put(Obj.RSCSTA, Ent.STATION);
        EntMAP.put(Obj.RDOSTA, Ent.STATION);
        EntMAP.put(Obj.RADSTA, Ent.STATION);
        EntMAP.put(Obj.NOTMRK, Ent.NOTICE);
        GrpMAP = new EnumMap(Obj.class);
        GrpMAP.put(Obj.UNKOBJ, Grp.NUL);
        GrpMAP.put(Obj.BCNCAR, Grp.CAR);
        GrpMAP.put(Obj.BCNISD, Grp.ISD);
        GrpMAP.put(Obj.BCNLAT, Grp.LAT);
        GrpMAP.put(Obj.BCNSAW, Grp.SAW);
        GrpMAP.put(Obj.BCNSPP, Grp.SPP);
        GrpMAP.put(Obj.BOYCAR, Grp.CAR);
        GrpMAP.put(Obj.BOYISD, Grp.ISD);
        GrpMAP.put(Obj.BOYLAT, Grp.LAT);
        GrpMAP.put(Obj.BOYSAW, Grp.SAW);
        GrpMAP.put(Obj.BOYSPP, Grp.SPP);
        GrpMAP.put(Obj.FLTCAR, Grp.CAR);
        GrpMAP.put(Obj.FLTLAT, Grp.LAT);
        GrpMAP.put(Obj.FLTSAW, Grp.SAW);
        GrpMAP.put(Obj.FLTISD, Grp.ISD);
        GrpMAP.put(Obj.FLTSPP, Grp.SPP);
        GrpMAP.put(Obj.LITFLT, Grp.LGT);
        GrpMAP.put(Obj.LITMAJ, Grp.LGT);
        GrpMAP.put(Obj.LITMIN, Grp.LGT);
        GrpMAP.put(Obj.LITVES, Grp.LGT);
        GrpMAP.put(Obj.LITHSE, Grp.LGT);
        GrpMAP.put(Obj.LNDMRK, Grp.LGT);
        GrpMAP.put(Obj.MORFAC, Grp.SPP);
        GrpMAP.put(Obj.BOYINB, Grp.SPP);
        GrpMAP.put(Obj.OFSPLF, Grp.PLF);
        GrpMAP.put(Obj.SISTAW, Grp.STN);
        GrpMAP.put(Obj.SISTAT, Grp.STN);
        GrpMAP.put(Obj.CGUSTA, Grp.STN);
        GrpMAP.put(Obj.PILBOP, Grp.STN);
        GrpMAP.put(Obj.RSCSTA, Grp.STN);
        GrpMAP.put(Obj.RDOSTA, Grp.STN);
        GrpMAP.put(Obj.RADSTA, Grp.STN);
        GrpMAP.put(Obj.NOTMRK, Grp.NTC);
        CatSTR = new EnumMap(Cat.class);
        CatSTR.put(Cat.LAM_PORT, "port");
        CatSTR.put(Cat.LAM_STBD, "starboard");
        CatSTR.put(Cat.LAM_PPORT, "preferred_channel_port");
        CatSTR.put(Cat.LAM_PSTBD, "preferred_channel_starboard");
        CatSTR.put(Cat.CAM_NORTH, "north");
        CatSTR.put(Cat.CAM_EAST, "east");
        CatSTR.put(Cat.CAM_SOUTH, "south");
        CatSTR.put(Cat.CAM_WEST, "west");
        CatSTR.put(Cat.SPM_UNKN, "unknown_purpose");
        CatSTR.put(Cat.SPM_WARN, "warning");
        CatSTR.put(Cat.SPM_CHBF, "channel_separation");
        CatSTR.put(Cat.SPM_YCHT, "yachting");
        CatSTR.put(Cat.SPM_CABL, "cable");
        CatSTR.put(Cat.SPM_OFAL, "outfall");
        CatSTR.put(Cat.SPM_ODAS, "odas");
        CatSTR.put(Cat.SPM_RECN, "recreation_zone");
        CatSTR.put(Cat.SPM_MOOR, "mooring");
        CatSTR.put(Cat.SPM_LNBY, "lanby");
        CatSTR.put(Cat.SPM_LDNG, "leading");
        CatSTR.put(Cat.SPM_NOTC, "notice");
        CatSTR.put(Cat.SPM_TSS, "tss");
        CatSTR.put(Cat.SPM_FOUL, "foul_ground");
        CatSTR.put(Cat.SPM_DIVE, "diving");
        CatSTR.put(Cat.SPM_FRRY, "ferry_crossing");
        CatSTR.put(Cat.SPM_ANCH, "anchorage");
        CatSTR.put(Cat.MOR_DLPN, "dolphin");
        CatSTR.put(Cat.MOR_DDPN, "deviation_dolphin");
        CatSTR.put(Cat.MOR_BLRD, "bollard");
        CatSTR.put(Cat.MOR_WALL, "wall");
        CatSTR.put(Cat.MOR_POST, "post");
        CatSTR.put(Cat.MOR_CHWR, "chain");
        CatSTR.put(Cat.MOR_ROPE, "shore_rope");
        CatSTR.put(Cat.MOR_AUTO, "automatic");
        CatSTR.put(Cat.MOR_BUOY, "buoy");
        CatSTR.put(Cat.INB_CALM, "calm");
        CatSTR.put(Cat.INB_SBM, "sbm");
        CatSTR.put(Cat.SIS_PTCL, "port_control");
        CatSTR.put(Cat.SIS_PTED, "port_entry");
        CatSTR.put(Cat.SIS_IPT, "ipt");
        CatSTR.put(Cat.SIS_BRTH, "berthing");
        CatSTR.put(Cat.SIS_DOCK, "dock");
        CatSTR.put(Cat.SIS_LOCK, "lock");
        CatSTR.put(Cat.SIS_FBAR, "barrage");
        CatSTR.put(Cat.SIS_BRDG, "bridge");
        CatSTR.put(Cat.SIS_DRDG, "dredging");
        CatSTR.put(Cat.SIS_TRFC, "traffic");
        CatSTR.put(Cat.SIS_DNGR, "danger");
        CatSTR.put(Cat.SIS_OBST, "obstruction");
        CatSTR.put(Cat.SIS_CABL, "cable");
        CatSTR.put(Cat.SIS_MILY, "military");
        CatSTR.put(Cat.SIS_DSTR, "distress");
        CatSTR.put(Cat.SIS_WTHR, "weather");
        CatSTR.put(Cat.SIS_STRM, "storm");
        CatSTR.put(Cat.SIS_ICE, "ice");
        CatSTR.put(Cat.SIS_TIME, "time");
        CatSTR.put(Cat.SIS_TIDE, "tide");
        CatSTR.put(Cat.SIS_TSTM, "stream");
        CatSTR.put(Cat.SIS_TGAG, "gauge");
        CatSTR.put(Cat.SIS_TSCL, "scale");
        CatSTR.put(Cat.SIS_DIVE, "diving");
        CatSTR.put(Cat.SIS_LGAG, "level");
        CatSTR.put(Cat.LMK_CHMY, "chimney");
        CatSTR.put(Cat.LMK_CARN, "cairn");
        CatSTR.put(Cat.LMK_DSHA, "dish_aerial");
        CatSTR.put(Cat.LMK_FLGS, "flagstaff");
        CatSTR.put(Cat.LMK_FLRS, "flare_stack");
        CatSTR.put(Cat.LMK_MNMT, "monument");
        CatSTR.put(Cat.LMK_TOWR, "tower");
        CatSTR.put(Cat.LMK_WNDM, "windmotor");
        CatSTR.put(Cat.LMK_WTRT, "water_tower");
        CatSTR.put(Cat.LMK_MAST, "mast");
        CatSTR.put(Cat.LMK_WNDS, "windsock");
        CatSTR.put(Cat.LMK_CLMN, "column");
        CatSTR.put(Cat.LMK_OBLK, "obelisk");
        CatSTR.put(Cat.LMK_STAT, "statue");
        CatSTR.put(Cat.LMK_CROS, "cross");
        CatSTR.put(Cat.LMK_DOME, "dome");
        CatSTR.put(Cat.LMK_SCNR, "radar_scanner");
        CatSTR.put(Cat.LMK_WNDL, "windmill");
        CatSTR.put(Cat.LMK_SPIR, "spire");
        CatSTR.put(Cat.LMK_MNRT, "minaret");
        CatSTR.put(Cat.OFP_OIL, "oil");
        CatSTR.put(Cat.OFP_PRD, "production");
        CatSTR.put(Cat.OFP_OBS, "observation");
        CatSTR.put(Cat.OFP_ALP, "alp");
        CatSTR.put(Cat.OFP_SALM, "salm");
        CatSTR.put(Cat.OFP_MOR, "mooring");
        CatSTR.put(Cat.OFP_ISL, "island");
        CatSTR.put(Cat.OFP_FPSO, "fpso");
        CatSTR.put(Cat.OFP_ACC, "accommodation");
        CatSTR.put(Cat.OFP_NCCB, "nccb");
        CatSTR.put(Cat.PIL_VESS, "cruising_vessel");
        CatSTR.put(Cat.PIL_HELI, "helicopter");
        CatSTR.put(Cat.PIL_SHORE, "from_shore");
        CatSTR.put(Cat.RSC_LFB, "lifeboat");
        CatSTR.put(Cat.RSC_RKT, "rocket");
        CatSTR.put(Cat.RSC_RSW, "refuge_shipwrecked");
        CatSTR.put(Cat.RSC_RIT, "refuge_intertidal");
        CatSTR.put(Cat.RSC_MLB, "lifeboat_moored");
        CatSTR.put(Cat.RSC_RAD, "radio");
        CatSTR.put(Cat.RSC_FAE, "firstaid");
        CatSTR.put(Cat.RSC_SPL, "seaplane");
        CatSTR.put(Cat.RSC_AIR, "aircraft");
        CatSTR.put(Cat.RSC_TUG, "tug");
        CatSTR.put(Cat.RAS_SRV, "surveillance");
        CatSTR.put(Cat.RAS_CST, "coast");
        CatSTR.put(Cat.ROS_OMNI, "omnidirectional");
        CatSTR.put(Cat.ROS_DIRL, "directional");
        CatSTR.put(Cat.ROS_ROTP, "rotating_pattern");
        CatSTR.put(Cat.ROS_CNSL, "consol");
        CatSTR.put(Cat.ROS_RDF, "rdf");
        CatSTR.put(Cat.ROS_QTG, "qtg");
        CatSTR.put(Cat.ROS_AERO, "aeronautical");
        CatSTR.put(Cat.ROS_DECA, "decca");
        CatSTR.put(Cat.ROS_LORN, "loran");
        CatSTR.put(Cat.ROS_DGPS, "dgps");
        CatSTR.put(Cat.ROS_TORN, "toran");
        CatSTR.put(Cat.ROS_OMGA, "omega");
        CatSTR.put(Cat.ROS_SYLD, "syledis");
        CatSTR.put(Cat.ROS_CHKA, "chiaka");
        CatSTR.put(Cat.ROS_PCOM, "public_communication");
        CatSTR.put(Cat.ROS_COMB, "commercial_broadcast");
        CatSTR.put(Cat.ROS_FACS, "facsimile");
        CatSTR.put(Cat.ROS_TIME, "time_signal");
        CatSTR.put(Cat.ROS_PAIS, "ais");
        CatSTR.put(Cat.ROS_SAIS, "s-ais");
        CatSTR.put(Cat.ROS_VAIS, "v-ais");
        CatSTR.put(Cat.ROS_VANC, "v-ais_north_cardinal");
        CatSTR.put(Cat.ROS_VASC, "v-ais_south_cardinal");
        CatSTR.put(Cat.ROS_VAEC, "v-ais_east_cardinal");
        CatSTR.put(Cat.ROS_VAWC, "v-ais_west_cardinal");
        CatSTR.put(Cat.ROS_VAPL, "v-ais_port_lateral");
        CatSTR.put(Cat.ROS_VASL, "v-ais_starboard_lateral");
        CatSTR.put(Cat.ROS_VAID, "v-ais_isolated_danger");
        CatSTR.put(Cat.ROS_VASW, "v-ais_safe_water");
        CatSTR.put(Cat.ROS_VASP, "v-ais_special_purpose");
        CatSTR.put(Cat.ROS_VAWK, "v-ais_wreck");
        CatSTR.put(Cat.NTC_A1, "no_entry");
        CatSTR.put(Cat.NTC_A1a, "closed_area");
        CatSTR.put(Cat.NTC_A2, "no_overtaking");
        CatSTR.put(Cat.NTC_A3, "no_convoy_overtaking");
        CatSTR.put(Cat.NTC_A4, "no_passing");
        CatSTR.put(Cat.NTC_A4, "no_convoy_passing");
        CatSTR.put(Cat.NTC_A5, "no_berthing");
        CatSTR.put(Cat.NTC_A5_1, "no_berthing_lateral_limit");
        CatSTR.put(Cat.NTC_A6, "no_anchoring");
        CatSTR.put(Cat.NTC_A7, "no_mooring");
        CatSTR.put(Cat.NTC_A8, "no_turning");
        CatSTR.put(Cat.NTC_A9, "no_wash");
        CatSTR.put(Cat.NTC_A10a, "no_passage_left");
        CatSTR.put(Cat.NTC_A10b, "no_passage_right");
        CatSTR.put(Cat.NTC_A12, "no_motor_craft");
        CatSTR.put(Cat.NTC_A13, "no_sport_craft");
        CatSTR.put(Cat.NTC_A14, "no_waterskiing");
        CatSTR.put(Cat.NTC_A15, "no_sailing_craft");
        CatSTR.put(Cat.NTC_A16, "no_unpowered_craft");
        CatSTR.put(Cat.NTC_A17, "no_sailboards");
        CatSTR.put(Cat.NTC_A18, "no_high_speeds");
        CatSTR.put(Cat.NTC_A19, "no_launching_beaching");
        CatSTR.put(Cat.NTC_A20, "no_waterbikes");
        CatSTR.put(Cat.NTC_B1a, "");
        CatSTR.put(Cat.NTC_B1b, "");
        CatSTR.put(Cat.NTC_B2a, "");
        CatSTR.put(Cat.NTC_B2a, "");
        CatSTR.put(Cat.NTC_B3a, "");
        CatSTR.put(Cat.NTC_B3a, "");
        CatSTR.put(Cat.NTC_B4a, "");
        CatSTR.put(Cat.NTC_B4a, "");
        CatSTR.put(Cat.NTC_B5, "");
        CatSTR.put(Cat.NTC_B6, "");
        CatSTR.put(Cat.NTC_B7, "");
        CatSTR.put(Cat.NTC_B8, "");
        CatSTR.put(Cat.NTC_B9a, "");
        CatSTR.put(Cat.NTC_B9b, "");
        CatSTR.put(Cat.NTC_B11, "");
        CatSTR.put(Cat.NTC_C1, "");
        CatSTR.put(Cat.NTC_C2, "");
        CatSTR.put(Cat.NTC_C3, "");
        CatSTR.put(Cat.NTC_C4, "");
        CatSTR.put(Cat.NTC_C5a, "");
        CatSTR.put(Cat.NTC_C5b, "");
        CatSTR.put(Cat.NTC_D1a, "");
        CatSTR.put(Cat.NTC_D1b, "");
        CatSTR.put(Cat.NTC_D2a, "");
        CatSTR.put(Cat.NTC_D2b, "");
        CatSTR.put(Cat.NTC_D3a, "");
        CatSTR.put(Cat.NTC_D3b, "");
        ShpSTR = new EnumMap(Shp.class);
        ShpSTR.put(Shp.PILLAR, "pillar");
        ShpSTR.put(Shp.SPAR, "spar");
        ShpSTR.put(Shp.CAN, "can");
        ShpSTR.put(Shp.CONI, "conical");
        ShpSTR.put(Shp.SPHERI, "spherical");
        ShpSTR.put(Shp.BARREL, "barrel");
        ShpSTR.put(Shp.FLOAT, "float");
        ShpSTR.put(Shp.SUPER, "super-buoy");
        ShpSTR.put(Shp.BUOYANT, "buoyant");
        ShpSTR.put(Shp.CAIRN, "cairn");
        ShpSTR.put(Shp.PILE, "pile");
        ShpSTR.put(Shp.LATTICE, "lattice");
        ShpSTR.put(Shp.TOWER, "tower");
        ShpSTR.put(Shp.STAKE, "stake");
        ShpSTR.put(Shp.PERCH, "perch");
        ColMAP = new EnumMap(Col.class);
        ColMAP.put(Col.UNKCOL, new Color(0xC0C0C0));
        ColMAP.put(Col.WHITE, Color.WHITE);
        ColMAP.put(Col.RED, Color.RED);
        ColMAP.put(Col.ORANGE, Color.ORANGE);
        ColMAP.put(Col.AMBER, new Color(0xFBF00F));
        ColMAP.put(Col.YELLOW, Color.YELLOW);
        ColMAP.put(Col.GREEN, Color.GREEN);
        ColMAP.put(Col.BLUE, Color.BLUE);
        ColMAP.put(Col.VIOLET, new Color(0x8F00FF));
        ColMAP.put(Col.BLACK, Color.BLACK);
        ColMAP.put(Col.GREY, Color.GRAY);
        ColMAP.put(Col.BROWN, new Color(10771032));
        ColMAP.put(Col.MAGENTA, Color.MAGENTA);
        ColMAP.put(Col.PINK, Color.PINK);
        ColSTR = new EnumMap(Col.class);
        ColSTR.put(Col.WHITE, "white");
        ColSTR.put(Col.RED, "red");
        ColSTR.put(Col.ORANGE, "orange");
        ColSTR.put(Col.AMBER, "amber");
        ColSTR.put(Col.YELLOW, "yellow");
        ColSTR.put(Col.GREEN, "green");
        ColSTR.put(Col.BLUE, "blue");
        ColSTR.put(Col.VIOLET, "violet");
        ColSTR.put(Col.BLACK, "black");
        ColSTR.put(Col.GREY, "grey");
        ColSTR.put(Col.BROWN, "brown");
        ColSTR.put(Col.MAGENTA, "magenta");
        ColSTR.put(Col.PINK, "pink");
        ChrMAP = new HashMap<EnumSet<Chr>, String>();
        ChrMAP.put(EnumSet.of(Chr.FIXED), "F");
        ChrMAP.put(EnumSet.of(Chr.FLASH), "Fl");
        ChrMAP.put(EnumSet.of(Chr.LFLASH), "LFl");
        ChrMAP.put(EnumSet.of(Chr.QUICK), "Q");
        ChrMAP.put(EnumSet.of(Chr.VQUICK), "VQ");
        ChrMAP.put(EnumSet.of(Chr.UQUICK), "UQ");
        ChrMAP.put(EnumSet.of(Chr.ISOPHASED), "Iso");
        ChrMAP.put(EnumSet.of(Chr.OCCULTING), "Oc");
        ChrMAP.put(EnumSet.of(Chr.IQUICK), "IQ");
        ChrMAP.put(EnumSet.of(Chr.IVQUICK), "IVQ");
        ChrMAP.put(EnumSet.of(Chr.IUQUICK), "IUQ");
        ChrMAP.put(EnumSet.of(Chr.MORSE), "Mo");
        ChrMAP.put(EnumSet.of(Chr.FIXED, Chr.FLASH), "FFl");
        ChrMAP.put(EnumSet.of(Chr.FLASH, Chr.LFLASH), "FlLFl");
        ChrMAP.put(EnumSet.of(Chr.FIXED, Chr.OCCULTING), "FOc");
        ChrMAP.put(EnumSet.of(Chr.FIXED, Chr.LFLASH), "FLFl");
        ChrMAP.put(EnumSet.of(Chr.OCCULTING, Chr.FLASH), "OcFl");
        ChrMAP.put(EnumSet.of(Chr.QUICK, Chr.LFLASH), "Q+LFl");
        ChrMAP.put(EnumSet.of(Chr.VQUICK, Chr.LFLASH), "VQ+LFl");
        ChrMAP.put(EnumSet.of(Chr.UQUICK, Chr.LFLASH), "UQ+LFl");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING), "Al");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.OCCULTING), "Al.Oc");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.LFLASH), "Al.LFl");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.FLASH), "Al.Fl");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.FIXED), "Al.F");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.FIXED, Chr.FLASH), "Al.FFl");
        ChrMAP.put(EnumSet.of(Chr.ALTERNATING, Chr.ISOPHASED), "Al.Iso");
        VisSTR = new EnumMap(Vis.class);
        VisSTR.put(Vis.HIGH, "high");
        VisSTR.put(Vis.LOW, "low");
        VisSTR.put(Vis.FAINT, "faint");
        VisSTR.put(Vis.INTEN, "intensified");
        VisSTR.put(Vis.UNINTEN, "unintensified");
        VisSTR.put(Vis.REST, "restricted");
        VisSTR.put(Vis.OBS, "obscured");
        VisSTR.put(Vis.PARTOBS, "part_obscured");
        LitSTR = new EnumMap(Lit.class);
        LitSTR.put(Lit.VERT, "vertical");
        LitSTR.put(Lit.HORIZ, "horizontal");
        LitSTR.put(Lit.DIR, "directional");
        LitSTR.put(Lit.UPPER, "upper");
        LitSTR.put(Lit.LOWER, "lower");
        LitSTR.put(Lit.LEAD, "leading");
        LitSTR.put(Lit.REAR, "rear");
        LitSTR.put(Lit.FRONT, "front");
        LitSTR.put(Lit.AERO, "aero");
        LitSTR.put(Lit.AIROBS, "air_obstruction");
        LitSTR.put(Lit.FOGDET, "fog_detector");
        LitSTR.put(Lit.FLOOD, "floodlight");
        LitSTR.put(Lit.STRIP, "striplight");
        LitSTR.put(Lit.SUBS, "subsidairy");
        LitSTR.put(Lit.SPOT, "spotlight");
        LitSTR.put(Lit.MOIRE, "moire");
        LitSTR.put(Lit.EMERG, "emergency");
        LitSTR.put(Lit.BEAR, "bearing");
        ExhSTR = new EnumMap(Exh.class);
        ExhSTR.put(Exh.H24, "24h");
        ExhSTR.put(Exh.DAY, "day");
        ExhSTR.put(Exh.NIGHT, "night");
        ExhSTR.put(Exh.FOG, "fog");
        ExhSTR.put(Exh.WARN, "warning");
        ExhSTR.put(Exh.STORM, "storm");
        PatSTR = new EnumMap(Pat.class);
        PatSTR.put(Pat.HSTRP, "horizontal");
        PatSTR.put(Pat.VSTRP, "vertical");
        PatSTR.put(Pat.DIAG, "diagonal");
        PatSTR.put(Pat.SQUARED, "squared");
        PatSTR.put(Pat.BORDER, "border");
        PatSTR.put(Pat.CROSS, "cross");
        PatSTR.put(Pat.SALTIRE, "saltire");
        TopSTR = new EnumMap(Top.class);
        TopSTR.put(Top.CYL, "cylinder");
        TopSTR.put(Top.CONE, "cone, point up");
        TopSTR.put(Top.SPHERE, "sphere");
        TopSTR.put(Top.X_SHAPE, "x-shape");
        TopSTR.put(Top.NORTH, "2 cones up");
        TopSTR.put(Top.SOUTH, "2 cones down");
        TopSTR.put(Top.EAST, "2 cones base together");
        TopSTR.put(Top.WEST, "2 cones point together");
        TopSTR.put(Top.SPHERES2, "2 spheres");
        TopSTR.put(Top.BOARD, "board");
        TopSTR.put(Top.RHOMBUS, "rhombus");
        TopSTR.put(Top.CIRCLE, "circle");
        TopSTR.put(Top.TRIANGLE, "triangle, point up");
        TopSTR.put(Top.TRIANGLE_INV, "triangle, point down");
        TopSTR.put(Top.SQUARE, "square");
        RtbSTR = new EnumMap(Rtb.class);
        RtbSTR.put(Rtb.RACON, "racon");
        RtbSTR.put(Rtb.RAMARK, "ramark");
        RtbSTR.put(Rtb.LEADING, "leading");
        FogSTR = new EnumMap(Fog.class);
        FogSTR.put(Fog.FOGSIG, "yes");
        FogSTR.put(Fog.HORN, "horn");
        FogSTR.put(Fog.SIREN, "siren");
        FogSTR.put(Fog.DIA, "diaphone");
        FogSTR.put(Fog.BELL, "bell");
        FogSTR.put(Fog.WHIS, "whistle");
        FogSTR.put(Fog.GONG, "gong");
        FogSTR.put(Fog.EXPLOS, "explosion");
        StsSTR = new EnumMap(Sts.class);
        StsSTR.put(Sts.PERM, "permanent");
        StsSTR.put(Sts.OCC, "occasional");
        StsSTR.put(Sts.REC, "recommended");
        StsSTR.put(Sts.NIU, "not_in_use");
        StsSTR.put(Sts.INT, "intermittent");
        StsSTR.put(Sts.RESV, "reserved");
        StsSTR.put(Sts.TEMP, "tempory");
        StsSTR.put(Sts.PRIV, "private");
        StsSTR.put(Sts.MAND, "mandatory");
        StsSTR.put(Sts.DEST, "destroyed");
        StsSTR.put(Sts.EXT, "extinguished");
        StsSTR.put(Sts.ILLUM, "illuminated");
        StsSTR.put(Sts.HIST, "historic");
        StsSTR.put(Sts.PUB, "public");
        StsSTR.put(Sts.SYNC, "synchronized");
        StsSTR.put(Sts.WATCH, "watched");
        StsSTR.put(Sts.UNWAT, "unwatched");
        StsSTR.put(Sts.DOUBT, "existence_doubtful");
        CnsSTR = new EnumMap(Cns.class);
        CnsSTR.put(Cns.BRICK, "masonry");
        CnsSTR.put(Cns.CONC, "concreted");
        CnsSTR.put(Cns.BOULD, "boulders");
        CnsSTR.put(Cns.HSURF, "hard_surfaced");
        CnsSTR.put(Cns.USURF, "unsurfaced");
        CnsSTR.put(Cns.WOOD, "wooden");
        CnsSTR.put(Cns.METAL, "metal");
        CnsSTR.put(Cns.GLAS, "grp");
        CnsSTR.put(Cns.PAINT, "painted");
        ConSTR = new EnumMap(Con.class);
        ConSTR.put(Con.CONSP, "conspicuous");
        ConSTR.put(Con.NCONS, "not_conspicuous");
        ConSTR.put(Con.REFL, "reflector");
        FncSTR = new EnumMap(Fnc.class);
        FncSTR.put(Fnc.UNKFNC, "");
        FncSTR.put(Fnc.HMO, "harbour-master");
        FncSTR.put(Fnc.CSTM, "customs");
        FncSTR.put(Fnc.HLTH, "health");
        FncSTR.put(Fnc.HOSP, "hospital");
        FncSTR.put(Fnc.POFF, "post_office");
        FncSTR.put(Fnc.HOTEL, "hotel");
        FncSTR.put(Fnc.RWSTA, "railway_station");
        FncSTR.put(Fnc.POLICE, "police_station");
        FncSTR.put(Fnc.WPOL, "water-police_station");
        FncSTR.put(Fnc.PILO, "pilot_office");
        FncSTR.put(Fnc.PILL, "pilot_lookout");
        FncSTR.put(Fnc.BANK, "bank");
        FncSTR.put(Fnc.DCHQ, "district_control");
        FncSTR.put(Fnc.TRNS, "transit_shed");
        FncSTR.put(Fnc.FACT, "factory");
        FncSTR.put(Fnc.PWRS, "power_station");
        FncSTR.put(Fnc.ADMIN, "administrative");
        FncSTR.put(Fnc.EDUC, "educational");
        FncSTR.put(Fnc.CHCH, "church");
        FncSTR.put(Fnc.CHPL, "chapel");
        FncSTR.put(Fnc.TMPL, "temple");
        FncSTR.put(Fnc.PGDA, "pagoda");
        FncSTR.put(Fnc.SHSH, "shinto_shrine");
        FncSTR.put(Fnc.BTMP, "buddhist_temple");
        FncSTR.put(Fnc.MOSQ, "mosque");
        FncSTR.put(Fnc.MRBT, "marabout");
        FncSTR.put(Fnc.LOOK, "lookout");
        FncSTR.put(Fnc.COMS, "communication");
        FncSTR.put(Fnc.TV, "television");
        FncSTR.put(Fnc.RADO, "radio");
        FncSTR.put(Fnc.RADR, "radar");
        FncSTR.put(Fnc.LSUP, "light_support");
        FncSTR.put(Fnc.MWAV, "microwave");
        FncSTR.put(Fnc.COOL, "cooling");
        FncSTR.put(Fnc.OBSV, "observation");
        FncSTR.put(Fnc.TIMB, "time_ball");
        FncSTR.put(Fnc.CLK, "clock");
        FncSTR.put(Fnc.CTRL, "control");
        FncSTR.put(Fnc.AMOR, "airship_mooring");
        FncSTR.put(Fnc.STAD, "stadium");
        FncSTR.put(Fnc.BUSS, "bus_station");
        FncSTR.put(Fnc.PRHB, "prohibition");
        FncSTR.put(Fnc.RGLN, "regulation");
        FncSTR.put(Fnc.RSTN, "restriction");
        FncSTR.put(Fnc.RCMD, "recommendation");
        FncSTR.put(Fnc.INFO, "information");
    }

    public static enum Fnc {
        UNKFNC,
        HMO,
        CSTM,
        HLTH,
        HOSP,
        POFF,
        HOTEL,
        RWSTA,
        POLICE,
        WPOL,
        PILO,
        PILL,
        BANK,
        DCHQ,
        TRNS,
        FACT,
        PWRS,
        ADMIN,
        EDUC,
        CHCH,
        CHPL,
        TMPL,
        PGDA,
        SHSH,
        BTMP,
        MOSQ,
        MRBT,
        LOOK,
        COMS,
        TV,
        RADO,
        RADR,
        LSUP,
        MWAV,
        COOL,
        OBSV,
        TIMB,
        CLK,
        CTRL,
        AMOR,
        STAD,
        BUSS,
        PRHB,
        RGLN,
        RSTN,
        RCMD,
        INFO;

    }

    public static enum Con {
        UNKCON,
        CONSP,
        NCONS,
        REFL;

    }

    public static enum Cns {
        UNKCNS,
        BRICK,
        CONC,
        BOULD,
        HSURF,
        USURF,
        WOOD,
        METAL,
        GLAS,
        PAINT;

    }

    public static enum Sts {
        UNKSTS,
        PERM,
        OCC,
        REC,
        NIU,
        INT,
        RESV,
        TEMP,
        PRIV,
        MAND,
        DEST,
        EXT,
        ILLUM,
        HIST,
        PUB,
        SYNC,
        WATCH,
        UNWAT,
        DOUBT;

    }

    public static enum Fog {
        NOFOG,
        FOGSIG,
        HORN,
        SIREN,
        DIA,
        BELL,
        WHIS,
        GONG,
        EXPLOS;

    }

    public static enum Rtb {
        NORTB,
        REFLECTOR,
        RACON,
        RAMARK,
        LEADING;

    }

    public static enum Top {
        NOTOP,
        CYL,
        CONE,
        SPHERE,
        X_SHAPE,
        NORTH,
        SOUTH,
        EAST,
        WEST,
        SPHERES2,
        BOARD,
        RHOMBUS,
        CIRCLE,
        TRIANGLE,
        TRIANGLE_INV,
        SQUARE;

    }

    public static enum Pat {
        NOPAT,
        HSTRP,
        VSTRP,
        DIAG,
        SQUARED,
        BORDER,
        CROSS,
        SALTIRE;

    }

    public static enum Att {
        COL,
        CHR,
        GRP,
        SEQ,
        PER,
        LIT,
        BEG,
        END,
        RAD,
        HGT,
        RNG,
        VIS,
        EXH,
        ORT,
        MLT,
        ALT;

    }

    public static enum Exh {
        UNKEXH,
        H24,
        DAY,
        NIGHT,
        FOG,
        WARN,
        STORM;

    }

    public static enum Lit {
        UNKLIT,
        VERT,
        HORIZ,
        DIR,
        UPPER,
        LOWER,
        LEAD,
        REAR,
        FRONT,
        AERO,
        AIROBS,
        FOGDET,
        FLOOD,
        STRIP,
        SUBS,
        SPOT,
        MOIRE,
        EMERG,
        BEAR;

    }

    public static enum Vis {
        UNKVIS,
        HIGH,
        LOW,
        FAINT,
        INTEN,
        UNINTEN,
        REST,
        OBS,
        PARTOBS;

    }

    public static enum Chr {
        UNKCHR,
        FIXED,
        FLASH,
        LFLASH,
        QUICK,
        VQUICK,
        UQUICK,
        ISOPHASED,
        OCCULTING,
        MORSE,
        ALTERNATING,
        IQUICK,
        IVQUICK,
        IUQUICK;

    }

    public static enum Col {
        UNKCOL,
        BLANK,
        WHITE,
        RED,
        ORANGE,
        AMBER,
        YELLOW,
        GREEN,
        BLUE,
        VIOLET,
        BLACK,
        GREY,
        BROWN,
        MAGENTA,
        PINK;

    }

    public static enum Shp {
        UNKSHP,
        PILLAR,
        SPAR,
        CAN,
        CONI,
        SPHERI,
        BARREL,
        FLOAT,
        SUPER,
        BUOYANT,
        CAIRN,
        PILE,
        LATTICE,
        TOWER,
        STAKE,
        POLE,
        POST,
        PERCH,
        BUOY,
        BEACON;

    }

    public static enum Cat {
        NOCAT,
        LAM_PORT,
        LAM_STBD,
        LAM_PPORT,
        LAM_PSTBD,
        CAM_NORTH,
        CAM_EAST,
        CAM_SOUTH,
        CAM_WEST,
        ACH_URST,
        ACH_DEEP,
        ACH_TANK,
        ACH_EXPL,
        ACH_QUAR,
        ACH_SPLN,
        ACH_SCAN,
        ACH_SCMO,
        ACH_T24H,
        ACH_TLIM,
        SPM_UNKN,
        SPM_WARN,
        SPM_CHBF,
        SPM_YCHT,
        SPM_CABL,
        SPM_OFAL,
        SPM_ODAS,
        SPM_RECN,
        SPM_MOOR,
        SPM_LNBY,
        SPM_LDNG,
        SPM_NOTC,
        SPM_TSS,
        SPM_FOUL,
        SPM_DIVE,
        SPM_FRRY,
        SPM_ANCH,
        MOR_DLPN,
        MOR_DDPN,
        MOR_BLRD,
        MOR_WALL,
        MOR_POST,
        MOR_CHWR,
        MOR_ROPE,
        MOR_AUTO,
        MOR_BUOY,
        INB_CALM,
        INB_SBM,
        SIS_PTCL,
        SIS_PTED,
        SIS_IPT,
        SIS_BRTH,
        SIS_DOCK,
        SIS_LOCK,
        SIS_FBAR,
        SIS_BRDG,
        SIS_DRDG,
        SIS_TRFC,
        SIS_DNGR,
        SIS_OBST,
        SIS_CABL,
        SIS_MILY,
        SIS_DSTR,
        SIS_WTHR,
        SIS_STRM,
        SIS_ICE,
        SIS_TIME,
        SIS_TIDE,
        SIS_TSTM,
        SIS_TGAG,
        SIS_TSCL,
        SIS_DIVE,
        SIS_LGAG,
        LIT_DIRF,
        LIT_LEDG,
        LMK_CHMY,
        LMK_CARN,
        LMK_DSHA,
        LMK_FLGS,
        LMK_FLRS,
        LMK_MNMT,
        LMK_TOWR,
        LMK_WNDM,
        LMK_WTRT,
        LMK_MNRT,
        LMK_MAST,
        LMK_WNDS,
        LMK_CLMN,
        LMK_OBLK,
        LMK_STAT,
        LMK_CROS,
        LMK_DOME,
        LMK_SCNR,
        LMK_WNDL,
        LMK_SPIR,
        OFP_OIL,
        OFP_PRD,
        OFP_OBS,
        OFP_ALP,
        OFP_SALM,
        OFP_MOR,
        OFP_ISL,
        OFP_FPSO,
        OFP_ACC,
        OFP_NCCB,
        RSC_LFB,
        RSC_RKT,
        RSC_RSW,
        RSC_RIT,
        RSC_MLB,
        RSC_RAD,
        RSC_FAE,
        RSC_SPL,
        RSC_AIR,
        RSC_TUG,
        RAS_SRV,
        RAS_CST,
        PIL_VESS,
        PIL_HELI,
        PIL_SHORE,
        NTC_A1,
        NTC_A1a,
        NTC_A2,
        NTC_A3,
        NTC_A4,
        NTC_A4_1,
        NTC_A5,
        NTC_A5_1,
        NTC_A6,
        NTC_A7,
        NTC_A8,
        NTC_A9,
        NTC_A10a,
        NTC_A10b,
        NTC_A12,
        NTC_A13,
        NTC_A14,
        NTC_A15,
        NTC_A16,
        NTC_A17,
        NTC_A18,
        NTC_A19,
        NTC_A20,
        NTC_B1a,
        NTC_B1b,
        NTC_B2a,
        NTC_B2b,
        NTC_B3a,
        NTC_B3b,
        NTC_B4a,
        NTC_B4b,
        NTC_B5,
        NTC_B6,
        NTC_B7,
        NTC_B8,
        NTC_B9a,
        NTC_B9b,
        NTC_B11,
        NTC_C1,
        NTC_C2,
        NTC_C3,
        NTC_C4,
        NTC_C5a,
        NTC_C5b,
        NTC_D1a,
        NTC_D1b,
        NTC_D2a,
        NTC_D2b,
        NTC_D3a,
        NTC_D3b,
        NOROS,
        ROS_UNKN,
        ROS_OMNI,
        ROS_DIRL,
        ROS_ROTP,
        ROS_CNSL,
        ROS_RDF,
        ROS_QTG,
        ROS_AERO,
        ROS_DECA,
        ROS_LORN,
        ROS_DGPS,
        ROS_TORN,
        ROS_OMGA,
        ROS_SYLD,
        ROS_CHKA,
        ROS_PCOM,
        ROS_COMB,
        ROS_FACS,
        ROS_TIME,
        ROS_PAIS,
        ROS_SAIS,
        ROS_VAIS,
        ROS_VANC,
        ROS_VASC,
        ROS_VAEC,
        ROS_VAWC,
        ROS_VAPL,
        ROS_VASL,
        ROS_VAID,
        ROS_VASW,
        ROS_VASP,
        ROS_VAWK;

    }

    public static enum Grp {
        NUL,
        LAT,
        CAR,
        SAW,
        ISD,
        SPP,
        LGT,
        STN,
        PLF,
        NTC;

    }

    public static enum Ent {
        BODY,
        BUOY,
        BEACON,
        LFLOAT,
        TOPMARK,
        LIGHT,
        MOORING,
        STATION,
        PLATFORM,
        NOTICE;

    }

    public static enum Obj {
        UNKOBJ,
        BCNCAR,
        BCNISD,
        BCNLAT,
        BCNSAW,
        BCNSPP,
        BOYCAR,
        BOYISD,
        BOYLAT,
        BOYSAW,
        BOYSPP,
        NOTMRK,
        FLTCAR,
        FLTISD,
        FLTLAT,
        FLTSAW,
        FLTSPP,
        LITMAJ,
        LITMIN,
        LITFLT,
        LITVES,
        LITHSE,
        LNDMRK,
        MORFAC,
        BOYINB,
        SISTAW,
        SISTAT,
        OFSPLF,
        CGUSTA,
        PILBOP,
        RSCSTA,
        RDOSTA,
        RADSTA;

    }

    public static enum Reg {
        A,
        B,
        C,
        R,
        X;

    }
}

