/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import public_transport.AStarAlgorithm;

public class PublicTransportAStar
extends AStarAlgorithm {
    TreeMap<Node, TreeSet<Way>> waysPerNode = null;

    public PublicTransportAStar(Node start, Node end) {
        super(new NodeVertex(start), new NodeVertex(end));
    }

    @Override
    public Vector<AStarAlgorithm.Edge> getNeighbors(AStarAlgorithm.Vertex vertex) {
        if (this.waysPerNode == null) {
            this.waysPerNode = new TreeMap();
            for (Way way : Main.getLayerManager().getEditDataSet().getWays()) {
                if (!way.isUsable()) continue;
                for (int i = 0; i < way.getNodesCount(); ++i) {
                    if (this.waysPerNode.get(way.getNode(i)) == null) {
                        this.waysPerNode.put(way.getNode(i), new TreeSet());
                    }
                    this.waysPerNode.get(way.getNode(i)).add(way);
                }
            }
        }
        NodeVertex nodeVertex = (NodeVertex)vertex;
        System.out.println(nodeVertex.node.getUniqueId());
        Vector<AStarAlgorithm.Edge> result = new Vector<AStarAlgorithm.Edge>();
        for (Way way : this.waysPerNode.get(nodeVertex.node)) {
            if (!way.isUsable()) continue;
            for (int i = 0; i < way.getNodesCount(); ++i) {
                if (!way.getNode(i).equals((Object)nodeVertex.node)) continue;
                if (i > 0) {
                    result.add(new PartialWayEdge(way, i, i - 1));
                }
                if (i >= way.getNodesCount() - 1) continue;
                result.add(new PartialWayEdge(way, i, i + 1));
            }
        }
        return result;
    }

    @Override
    public double estimateDistance(AStarAlgorithm.Vertex vertex) {
        NodeVertex nodeVertex = (NodeVertex)vertex;
        return ((NodeVertex)this.end).node.getCoor().greatCircleDistance(nodeVertex.node.getCoor());
    }

    public static class PartialWayEdge
    extends AStarAlgorithm.Edge {
        public Way way;
        public int beginIndex;
        public int endIndex;

        public PartialWayEdge(Way way, int beginIndex, int endIndex) {
            this.way = way;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public AStarAlgorithm.Vertex getBegin() {
            return new NodeVertex(this.way.getNode(this.beginIndex));
        }

        @Override
        public AStarAlgorithm.Vertex getEnd() {
            return new NodeVertex(this.way.getNode(this.endIndex));
        }

        @Override
        public double getLength() {
            int min = this.beginIndex;
            int max = this.endIndex;
            if (this.endIndex < this.beginIndex) {
                min = this.endIndex;
                max = this.beginIndex;
            }
            double totalDistance = 0.0;
            for (int i = min; i < max; ++i) {
                totalDistance += this.way.getNode(i).getCoor().greatCircleDistance(this.way.getNode(i + 1).getCoor());
            }
            return totalDistance;
        }
    }

    public static class NodeVertex
    extends AStarAlgorithm.Vertex {
        public Node node;

        public NodeVertex(Node node) {
            this.node = node;
        }

        @Override
        public int compareTo(AStarAlgorithm.Vertex v) {
            return this.node.compareTo((OsmPrimitive)((NodeVertex)v).node);
        }

        public boolean equals(Object o) {
            if ((NodeVertex)o == null) {
                return false;
            }
            return this.node.equals((Object)((NodeVertex)o).node);
        }

        public int hashCode() {
            return Objects.hashCode(this.node);
        }
    }
}

