/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.insignificant.josm.plugins.imagewaypoint.ImageWayPointDialog;
import org.insignificant.josm.plugins.imagewaypoint.ImageWayPointLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public final class ImageWayPointPlugin
extends Plugin {
    public ImageWayPointPlugin(PluginInformation info) {
        super(info);
        ExtensionFileFilter.addImporter((FileImporter)new ImageWaypointImporter());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.addToggleDialog(ImageWayPointDialog.getInstance().getDisplayComponent());
        } else {
            ImageEntries.getInstance().setCurrentImageEntry(null);
        }
    }

    private void addFiles(List<File> allFiles, File[] selectedFiles) {
        for (int index = 0; index < selectedFiles.length; ++index) {
            File selectedFile = selectedFiles[index];
            if (selectedFile.isDirectory()) {
                this.addFiles(allFiles, selectedFile.listFiles());
                continue;
            }
            if (!selectedFile.getName().toLowerCase().endsWith(".jpg")) continue;
            allFiles.add(selectedFile);
        }
    }

    private final class ImageWaypointImporter
    extends FileImporter {
        ImageWaypointImporter() {
            super(new ExtensionFileFilter("jpg,jpeg,png,gif", "jpg", "Image files [by ImageWayPoint plugin] (*.jpg, *.jpeg, *.png, *.gif)"));
        }

        public boolean isBatchImporter() {
            return true;
        }

        public double getPriority() {
            return -3.0;
        }

        public void importData(List<File> files, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
            if (null != files && !files.isEmpty()) {
                ArrayList allFiles = new ArrayList();
                ImageWayPointPlugin.this.addFiles(allFiles, files.toArray(new File[0]));
                ImageEntries.getInstance().add(allFiles.toArray(new File[allFiles.size()]));
                boolean foundImageWayPointLayer = false;
                List layerCollection = Main.getLayerManager().getLayers();
                Iterator layerIterator = layerCollection.iterator();
                while (layerIterator.hasNext() && !foundImageWayPointLayer) {
                    if (!(layerIterator.next() instanceof ImageWayPointLayer)) continue;
                    foundImageWayPointLayer = true;
                }
                if (!foundImageWayPointLayer) {
                    GuiHelper.runInEDT((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            new ImageWayPointLayer();
                        }
                    });
                }
            }
        }
    }
}

