/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntry;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;

public final class ImageEntries {
    private static final ImageEntries INSTANCE = new ImageEntries();
    private final List<ImageEntry> images = new ArrayList<ImageEntry>();
    private final List<ImageEntry> locatedImages = new ArrayList<ImageEntry>();
    private final List<IImageChangeListener> listeners = new ArrayList<IImageChangeListener>();
    private final ImageEntry.IImageReadyListener listener = new ImageReadyListener(this);
    private ImageEntry currentImageEntry = null;
    private Image currentImage = null;

    private ImageEntries() {
    }

    public static ImageEntries getInstance() {
        return INSTANCE;
    }

    public void addListener(IImageChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IImageChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void add(File[] imageFiles) {
        if (null != imageFiles) {
            for (int index = 0; index < imageFiles.length; ++index) {
                this.images.add(new ImageEntry(imageFiles[index]));
            }
            this.associateAllLayers();
        }
    }

    public void associateAllLayers() {
        for (int index = 0; index < this.images.size(); ++index) {
            this.images.get(index).setWayPoint(null);
        }
        this.locatedImages.clear();
        List layerCollection = Main.getLayerManager().getLayers();
        Layer[] layers = layerCollection.toArray(new Layer[layerCollection.size()]);
        for (int index = 0; index < layers.length; ++index) {
            if (!(layers[index] instanceof GpxLayer) || null == ((GpxLayer)layers[index]).data || ((GpxLayer)layers[index]).data.fromServer) continue;
            this.doAssociateLayer((GpxLayer)layers[index]);
        }
        for (IImageChangeListener listener : this.listeners) {
            listener.onSelectedImageEntryChanged(this);
        }
    }

    private void doAssociateLayer(GpxLayer gpxLayer) {
        if (null != gpxLayer && null != gpxLayer.data && !gpxLayer.data.fromServer) {
            for (WayPoint wayPoint : gpxLayer.data.waypoints) {
                List<String> texts = this.getTextContentsFromWayPoint(wayPoint);
                for (String text : texts) {
                    ImageEntry image = this.findImageEntryWithFileName(text);
                    if (null == image) continue;
                    image.setWayPoint(wayPoint);
                    this.locatedImages.add(image);
                }
            }
        }
    }

    private List<String> getTextContentsFromWayPoint(WayPoint wayPoint) {
        ArrayList<String> texts = new ArrayList<String>();
        for (String s : new String[]{"name", "cmt", "desc"}) {
            String t = wayPoint.getString(s);
            if (null == t || 0 >= t.length()) continue;
            texts.add(t);
        }
        return texts;
    }

    private ImageEntry findImageEntryWithFileName(String fileName) {
        ImageEntry foundimage = null;
        for (int index = 0; index < this.images.size() && null == foundimage; ++index) {
            ImageEntry image = this.images.get(index);
            if (null != image.getWayPoint() || !image.getFileName().startsWith(fileName)) continue;
            foundimage = image;
        }
        return foundimage;
    }

    private void setCurrentImage(ImageEntry imageEntry, Image image) {
        if (imageEntry == this.currentImageEntry) {
            this.currentImage = image;
        }
        for (IImageChangeListener listener : this.listeners) {
            listener.onSelectedImageEntryChanged(this);
        }
    }

    public ImageEntry[] getImages() {
        return this.locatedImages.toArray(new ImageEntry[this.locatedImages.size()]);
    }

    public ImageEntry getCurrentImageEntry() {
        return this.currentImageEntry;
    }

    public Image getCurrentImage() {
        return this.currentImage;
    }

    public boolean hasNext() {
        return null != this.currentImageEntry && this.locatedImages.indexOf(this.currentImageEntry) < this.locatedImages.size() - 1;
    }

    public boolean hasPrevious() {
        return null != this.currentImageEntry && this.locatedImages.indexOf(this.currentImageEntry) > 0;
    }

    public void next() {
        if (null != this.currentImageEntry && this.locatedImages.indexOf(this.currentImageEntry) < this.locatedImages.size() - 1) {
            this.setCurrentImageEntry(this.locatedImages.get(this.locatedImages.indexOf(this.currentImageEntry) + 1));
        }
    }

    public void previous() {
        if (null != this.currentImageEntry && this.locatedImages.indexOf(this.currentImageEntry) > 0) {
            this.setCurrentImageEntry(this.locatedImages.get(this.locatedImages.indexOf(this.currentImageEntry) - 1));
        }
    }

    public void rotateCurrentImageLeft() {
        if (null != this.currentImageEntry) {
            this.currentImageEntry.setOrientation(this.currentImageEntry.getOrientation().rotateLeft());
        }
        this.setCurrentImageEntry(this.currentImageEntry);
    }

    public void rotateCurrentImageRight() {
        if (null != this.currentImageEntry) {
            this.currentImageEntry.setOrientation(this.currentImageEntry.getOrientation().rotateRight());
        }
        this.setCurrentImageEntry(this.currentImageEntry);
    }

    public void setCurrentImageEntry(ImageEntry imageEntry) {
        if (null == imageEntry || this.locatedImages.contains(imageEntry)) {
            if (null != this.currentImageEntry) {
                this.currentImageEntry.flush();
            }
            this.currentImageEntry = imageEntry;
            this.currentImage = null;
            for (IImageChangeListener listener : this.listeners) {
                listener.onSelectedImageEntryChanged(this);
            }
            if (imageEntry != null) {
                this.currentImageEntry.requestImage(this.listener);
            }
        }
    }

    private static final class ImageReadyListener
    implements ImageEntry.IImageReadyListener {
        private final ImageEntries imageEntries;

        ImageReadyListener(ImageEntries imageEntries) {
            this.imageEntries = imageEntries;
        }

        @Override
        public void onImageReady(ImageEntry imageEntry, Image image) {
            this.imageEntries.setCurrentImage(imageEntry, image);
        }
    }
}

