/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class TranverseCentralCylindricalProjection
extends CylindricalProjection {
    public TranverseCentralCylindricalProjection() {
        this.minLongitude = ProjectionMath.degToRad(-60.0);
        this.maxLongitude = ProjectionMath.degToRad(60.0);
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double d;
        double b = Math.cos(lpphi) * Math.sin(lplam);
        double bt = 1.0 - b * b;
        if (d < 1.0E-10) {
            throw new ProjectionException("F");
        }
        out.x = b / Math.sqrt(bt);
        out.y = Math.atan2(Math.tan(lpphi), Math.cos(lplam));
        return out;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public String toString() {
        return "Transverse Central Cylindrical";
    }
}

