/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import org.osgeo.proj4j.datum.Datum;
import org.osgeo.proj4j.proj.LongLatProjection;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.units.Units;

public class CoordinateReferenceSystem {
    public static final CoordinateReferenceSystem CS_GEO = new CoordinateReferenceSystem("CS_GEO", null, null, null);
    private String name;
    private String[] params;
    private Datum datum;
    private Projection proj;

    public CoordinateReferenceSystem(String name, String[] params, Datum datum, Projection proj) {
        this.name = name;
        this.params = params;
        this.datum = datum;
        this.proj = proj;
        if (name == null) {
            String projName = "null-proj";
            if (proj != null) {
                projName = proj.getName();
            }
            this.name = projName + "-CS";
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.params;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public String getParameterString() {
        if (this.params == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.params.length; ++i) {
            buf.append(this.params[i]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public CoordinateReferenceSystem createGeographic() {
        Datum datum = this.getDatum();
        LongLatProjection geoProj = new LongLatProjection();
        geoProj.setEllipsoid(this.getProjection().getEllipsoid());
        geoProj.setUnits(Units.DEGREES);
        ((Projection)geoProj).initialize();
        return new CoordinateReferenceSystem("GEO-" + datum.getCode(), null, datum, geoProj);
    }

    public String toString() {
        return this.name;
    }
}

