/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;

public class KmzReader
extends AbstractReader {
    private ZipInputStream zis;

    public KmzReader(ZipInputStream zis) {
        this.zis = zis;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        return new KmzReader(new ZipInputStream(in)).parseDoc(instance);
    }

    private DataSet parseDoc(ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        byte[] buffer;
        ZipEntry entry;
        do {
            if ((entry = this.zis.getNextEntry()) != null) continue;
            Main.warn((String)"No KML file found");
            return null;
        } while (!entry.getName().toLowerCase().endsWith(".kml"));
        long size = entry.getSize();
        if (size > 0L) {
            buffer = new byte[(int)size];
            int off = 0;
            int count = 0;
            while ((count = this.zis.read(buffer, off, (int)size)) > 0) {
                off += count;
                size -= (long)count;
            }
        } else {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            do {
                if ((b = this.zis.read()) == -1) continue;
                out.write(b);
            } while (b != -1);
            buffer = out.toByteArray();
        }
        return KmlReader.parseDataSet(new ByteArrayInputStream(buffer), instance);
    }
}

