/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.openstreetmap.josm.gui.Notification;

public final class PointInfoUtils {
    private PointInfoUtils() {
    }

    public static void showNotification(String message, String type) {
        Notification note = new Notification(message);
        if ("info".equals(type)) {
            note.setIcon(1);
        } else if ("warning".equals(type)) {
            note.setIcon(2);
        } else if ("error".equals(type)) {
            note.setIcon(0);
        } else {
            note.setIcon(-1);
        }
        note.setDuration(Notification.TIME_SHORT);
        note.show();
    }

    public static String formatCoordinates(double lat, double lon) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        DecimalFormat df = new DecimalFormat("#.00000", symbols);
        return "(" + df.format(lat) + ", " + df.format(lon) + ")";
    }
}

