/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class CommonObjectDataSubRecord
extends SubRecord {
    public static final short sid = 21;
    private static final BitField locked = BitFieldFactory.getInstance(1);
    private static final BitField printable = BitFieldFactory.getInstance(16);
    private static final BitField autofill = BitFieldFactory.getInstance(8192);
    private static final BitField autoline = BitFieldFactory.getInstance(16384);
    private short field_1_objectType;
    private int field_2_objectId;
    private short field_3_option;
    private int field_4_reserved1;
    private int field_5_reserved2;
    private int field_6_reserved3;

    public CommonObjectDataSubRecord() {
    }

    public CommonObjectDataSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 18) {
            throw new RecordFormatException("Expected size 18 but got (" + n + ")");
        }
        this.field_1_objectType = littleEndianInput.readShort();
        this.field_2_objectId = littleEndianInput.readUShort();
        this.field_3_option = littleEndianInput.readShort();
        this.field_4_reserved1 = littleEndianInput.readInt();
        this.field_5_reserved2 = littleEndianInput.readInt();
        this.field_6_reserved3 = littleEndianInput.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ftCmo]\n");
        stringBuffer.append("    .objectType           = ").append("0x").append(HexDump.toHex(this.getObjectType())).append(" (").append(this.getObjectType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .objectId             = ").append("0x").append(HexDump.toHex(this.getObjectId())).append(" (").append(this.getObjectId()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .option               = ").append("0x").append(HexDump.toHex(this.getOption())).append(" (").append(this.getOption()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .locked                   = ").append(this.isLocked()).append('\n');
        stringBuffer.append("         .printable                = ").append(this.isPrintable()).append('\n');
        stringBuffer.append("         .autofill                 = ").append(this.isAutofill()).append('\n');
        stringBuffer.append("         .autoline                 = ").append(this.isAutoline()).append('\n');
        stringBuffer.append("    .reserved1            = ").append("0x").append(HexDump.toHex(this.getReserved1())).append(" (").append(this.getReserved1()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved2            = ").append("0x").append(HexDump.toHex(this.getReserved2())).append(" (").append(this.getReserved2()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved3            = ").append("0x").append(HexDump.toHex(this.getReserved3())).append(" (").append(this.getReserved3()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/ftCmo]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(21);
        littleEndianOutput.writeShort(this.getDataSize());
        littleEndianOutput.writeShort(this.field_1_objectType);
        littleEndianOutput.writeShort(this.field_2_objectId);
        littleEndianOutput.writeShort(this.field_3_option);
        littleEndianOutput.writeInt(this.field_4_reserved1);
        littleEndianOutput.writeInt(this.field_5_reserved2);
        littleEndianOutput.writeInt(this.field_6_reserved3);
    }

    @Override
    protected int getDataSize() {
        return 18;
    }

    public short getSid() {
        return 21;
    }

    @Override
    public Object clone() {
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.field_1_objectType = this.field_1_objectType;
        commonObjectDataSubRecord.field_2_objectId = this.field_2_objectId;
        commonObjectDataSubRecord.field_3_option = this.field_3_option;
        commonObjectDataSubRecord.field_4_reserved1 = this.field_4_reserved1;
        commonObjectDataSubRecord.field_5_reserved2 = this.field_5_reserved2;
        commonObjectDataSubRecord.field_6_reserved3 = this.field_6_reserved3;
        return commonObjectDataSubRecord;
    }

    public short getObjectType() {
        return this.field_1_objectType;
    }

    public int getObjectId() {
        return this.field_2_objectId;
    }

    public short getOption() {
        return this.field_3_option;
    }

    public int getReserved1() {
        return this.field_4_reserved1;
    }

    public int getReserved2() {
        return this.field_5_reserved2;
    }

    public int getReserved3() {
        return this.field_6_reserved3;
    }

    public boolean isLocked() {
        return locked.isSet(this.field_3_option);
    }

    public boolean isPrintable() {
        return printable.isSet(this.field_3_option);
    }

    public boolean isAutofill() {
        return autofill.isSet(this.field_3_option);
    }

    public boolean isAutoline() {
        return autoline.isSet(this.field_3_option);
    }
}

