/*
 * Decompiled with CFR 0.152.
 */
package ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.Geometry;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.NearestWaySegment;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.StopArea;
import ru.rodsoft.openstreetmap.josm.plugins.customizepublictransportstop.StopAreaOperationBase;

public class CreateNewStopPointOperation
extends StopAreaOperationBase {
    public CreateNewStopPointOperation(DataSet currentDataSet) {
        super(currentDataSet);
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point p) {
        TreeMap<Double, List<Node>> nearestMap = new TreeMap<Double, List<Node>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = 200.0;
            snapDistanceSq *= snapDistanceSq;
            for (Node n : ds.searchNodes(this.getBBox(p, 200))) {
                List<Object> nlist;
                double d;
                double dist = Main.map.mapView.getPoint2D(n).distanceSq(p);
                if (!(d < snapDistanceSq)) continue;
                if (nearestMap.containsKey(dist)) {
                    nlist = nearestMap.get(dist);
                } else {
                    nlist = new LinkedList();
                    nearestMap.put(dist, nlist);
                }
                nlist.add(n);
            }
        }
        return nearestMap;
    }

    private BBox getBBox(Point p, int snapDistance) {
        return new BBox(Main.map.mapView.getLatLon(p.x - snapDistance, p.y - snapDistance), Main.map.mapView.getLatLon(p.x + snapDistance, p.y + snapDistance));
    }

    public AbstractMap.SimpleEntry<Double, Node> getNearestNode(LatLon platformCoord, StopArea stopArea) {
        Point p = Main.map.mapView.getPoint(platformCoord);
        Map<Double, List<Node>> dist_nodes = this.getNearestNodesImpl(p);
        Double[] distances = dist_nodes.keySet().toArray(new Double[0]);
        distances = this.sort(distances);
        Integer distanceIndex = -1;
        Node nearestNode = null;
        block0: while ((distanceIndex = Integer.valueOf(distanceIndex + 1)) < distances.length && nearestNode == null) {
            List<Node> nodes = dist_nodes.get(distances[distanceIndex]);
            for (Node node : nodes) {
                for (Way way : this.getCurrentDataSet().getWays()) {
                    if (!way.getNodes().contains(node) || !this.testWay(way, stopArea).booleanValue()) continue;
                    nearestNode = node;
                    return new AbstractMap.SimpleEntry<Double, Node>(distances[distanceIndex], nearestNode);
                }
                if (nearestNode == null) continue;
                continue block0;
            }
        }
        return null;
    }

    public Double[] sort(Double[] distances) {
        Integer i = 0;
        while (i < distances.length - 1) {
            Integer n;
            Integer j = i + 1;
            while (j < distances.length) {
                if (distances[i] > distances[j]) {
                    Double d = distances[i];
                    distances[i.intValue()] = distances[j];
                    distances[j.intValue()] = d;
                }
                n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
            Integer n3 = i;
            n = i = Integer.valueOf(i + 1);
        }
        return distances;
    }

    public Boolean testWay(Way way, StopArea stopArea) {
        String highway;
        if (stopArea.isTrainStation.booleanValue() || stopArea.isTrainStop.booleanValue()) {
            if ("rail".equals(way.getKeys().get((Object)"railway")) && "main".equals(way.getKeys().get((Object)"usage"))) {
                return true;
            }
            return false;
        }
        if (stopArea.isTram.booleanValue()) {
            if ("tram".equals(way.getKeys().get((Object)"railway"))) {
                return true;
            }
            return false;
        }
        String[] highwayValues = new String[]{"trunk", "primary", "secondary", "tertiary", "unclassified", "residential", "service", "bus_guideway", "road", "trunk_link", "primary_link", "secondary_link", "tertiary_link"};
        if ((stopArea.isBus.booleanValue() || stopArea.isTrolleybus.booleanValue() || stopArea.isShareTaxi.booleanValue()) && (highway = way.getKeys().get((Object)"highway")) != null) {
            Integer i = 0;
            while (i < highwayValues.length) {
                if (highwayValues[i].equals(highway)) {
                    return true;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return false;
    }

    private Map<Double, List<WaySegment>> getNearestWaySegmentsImpl(Point p) {
        TreeMap<Double, List<WaySegment>> nearestMap = new TreeMap<Double, List<WaySegment>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = Main.pref.getInteger("mappaint.segment.snap-distance", 200);
            snapDistanceSq *= snapDistanceSq;
            for (Way w : ds.searchWays(this.getBBox(p, Main.pref.getInteger("mappaint.segment.snap-distance", 200)))) {
                Node lastN = null;
                int i = -2;
                for (Node n : w.getNodes()) {
                    double b;
                    ++i;
                    if (n.isDeleted() || n.isIncomplete()) continue;
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    Point2D A = Main.map.mapView.getPoint2D(lastN);
                    Point2D B = Main.map.mapView.getPoint2D(n);
                    double c = A.distanceSq(B);
                    double a = p.distanceSq(B);
                    double perDistSq = Double.longBitsToDouble(Double.doubleToLongBits(a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c) >> 32 << 32);
                    if (perDistSq < snapDistanceSq && a < c + snapDistanceSq && b < c + snapDistanceSq) {
                        List<WaySegment> wslist;
                        if (nearestMap.containsKey(perDistSq)) {
                            wslist = (List)nearestMap.get(perDistSq);
                        } else {
                            wslist = new LinkedList();
                            nearestMap.put(perDistSq, wslist);
                        }
                        wslist.add(new WaySegment(w, i));
                    }
                    lastN = n;
                }
            }
        }
        return nearestMap;
    }

    protected NearestWaySegment getNearestWaySegment(LatLon platformCoord, StopArea stopArea) {
        Point p = Main.map.mapView.getPoint(platformCoord);
        Map<Double, List<WaySegment>> dist_waySegments = this.getNearestWaySegmentsImpl(p);
        for (Map.Entry<Double, List<WaySegment>> entry : dist_waySegments.entrySet()) {
            for (WaySegment waySegment : entry.getValue()) {
                if (!this.testWay(waySegment.way, stopArea).booleanValue()) continue;
                Node n = waySegment.getFirstNode();
                Node lastN = waySegment.getSecondNode();
                EastNorth newPosition = Geometry.closestPointToSegment((EastNorth)n.getEastNorth(), (EastNorth)lastN.getEastNorth(), (EastNorth)Projections.project((LatLon)platformCoord));
                LatLon newNodePosition = Projections.inverseProject((EastNorth)newPosition);
                Point2D lastN2D = Main.map.mapView.getPoint2D(lastN);
                Point2D n2D = Main.map.mapView.getPoint2D(n);
                Point2D newNodePosition2D = Main.map.mapView.getPoint2D(newNodePosition);
                Double distCurrenNodes = lastN2D.distance(n2D);
                if (!(newNodePosition2D.distance(lastN2D) < distCurrenNodes) || !(newNodePosition2D.distance(n2D) < distCurrenNodes)) continue;
                return new NearestWaySegment(entry.getKey(), waySegment, new Node(newNodePosition));
            }
        }
        return null;
    }

    protected Node createNodeOnWay(Node newStopNode, WaySegment waySegment) {
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)newStopNode));
        List wayNodes = waySegment.way.getNodes();
        wayNodes.add(waySegment.lowerIndex + 1, newStopNode);
        Way newWay = new Way(waySegment.way);
        newWay.setNodes(wayNodes);
        Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)waySegment.way, (OsmPrimitive)newWay));
        return newStopNode;
    }

    @Override
    public StopArea performCustomizing(StopArea stopArea) {
        LatLon platformCoord = null;
        platformCoord = stopArea.selectedObject instanceof Node ? ((Node)stopArea.selectedObject).getCoor() : CreateNewStopPointOperation.getCenterOfWay(stopArea.selectedObject);
        if (platformCoord == null) {
            return stopArea;
        }
        AbstractMap.SimpleEntry<Double, Node> nearestNode = this.getNearestNode(platformCoord, stopArea);
        NearestWaySegment nearestWaySegment = this.getNearestWaySegment(platformCoord, stopArea);
        Node newStopPointNode = null;
        if (nearestNode != null && nearestWaySegment != null) {
            Double segmentDist = Main.map.mapView.getPoint2D(platformCoord).distanceSq(Main.map.mapView.getPoint2D(nearestWaySegment.newNode));
            Double nodeDistSq = nearestNode.getKey();
            newStopPointNode = segmentDist < nodeDistSq - 2.0 ? this.createNodeOnWay(nearestWaySegment.newNode, nearestWaySegment.waySegment) : nearestNode.getValue();
        } else if (nearestNode != null && nearestWaySegment == null) {
            newStopPointNode = nearestNode.getValue();
        } else if (nearestNode == null && nearestWaySegment != null) {
            newStopPointNode = this.createNodeOnWay(nearestWaySegment.newNode, nearestWaySegment.waySegment);
        }
        if (newStopPointNode != null) {
            stopArea.stopPoints.add(newStopPointNode);
        }
        return stopArea;
    }
}

