/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class StopChecker
extends Checker {
    Set<OsmPrimitive> members;

    protected StopChecker(Relation relation, Test test) {
        super(relation, test);
        this.members = relation.getMemberPrimitives();
    }

    protected void performStopAreaStopPositionTest() {
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaStopPosition(member)) continue;
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3762);
        builder.message(I18n.tr((String)"PT: Stop area relation has no stop position", (Object[])new Object[0]));
        builder.primitives(primitives);
        TestError e = builder.build();
        this.errors.add(e);
    }

    protected void performStopAreaPlatformTest() {
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaPlatform(member)) continue;
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3763);
        builder.message(I18n.tr((String)"PT: Stop area relation has no platform", (Object[])new Object[0]));
        builder.primitives(primitives);
        TestError e = builder.build();
        this.errors.add(e);
    }

    protected void performStopAreaRelationsTest() {
        HashMap<Long, Long> stopPositionRelationIds = new HashMap<Long, Long>();
        HashMap<Long, Long> platformRelationIds = new HashMap<Long, Long>();
        for (OsmPrimitive member : this.members) {
            if (StopUtils.verifyStopAreaStopPosition(member)) {
                for (Relation referrer : OsmPrimitive.getFilteredList((Collection)member.getReferrers(), Relation.class)) {
                    if (referrer.get("type") != "route") continue;
                    stopPositionRelationIds.put(referrer.getId(), referrer.getId());
                }
                continue;
            }
            if (!StopUtils.verifyStopAreaPlatform(member)) continue;
            for (Relation referrer : OsmPrimitive.getFilteredList((Collection)member.getReferrers(), Relation.class)) {
                if (referrer.get("type") != "route") continue;
                platformRelationIds.put(referrer.getId(), referrer.getId());
            }
        }
        if (stopPositionRelationIds.isEmpty()) {
            return;
        }
        if (stopPositionRelationIds.equals(platformRelationIds)) {
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3764);
        builder.message(I18n.tr((String)"PT: Route relations of stop position(s) and platform(s) of stop area members diverge", (Object[])new Object[0]));
        builder.primitives(primitives);
        TestError e = builder.build();
        this.errors.add(e);
    }
}

