/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class FaheyProjection
extends Projection {
    private static final double TOL = 1.0E-6;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = Math.tan(0.5 * lpphi);
        out.y = 1.819152 * out.x;
        out.x = 0.819152 * lplam * this.asqrt(1.0 - out.x * out.x);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double d;
        out.y = 2.0 * Math.atan(out.y /= 1.819152);
        out.y = 1.0 - xyy * xyy;
        out.x = Math.abs(d) < 1.0E-6 ? 0.0 : xyx / (0.819152 * Math.sqrt(xyy));
        return out;
    }

    private double asqrt(double v) {
        return v <= 0.0 ? 0.0 : Math.sqrt(v);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Fahey";
    }
}

