/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Stack;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;

public class FormulaRenderer {
    public static String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook, Ptg[] ptgArray) {
        if (ptgArray == null || ptgArray.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgArray.length; ++i) {
            String[] stringArray;
            Object object;
            Ptg ptg = ptgArray[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof ParenthesisPtg) {
                object = (String)stack.pop();
                stack.push("(" + (String)object + ")");
                continue;
            }
            if (ptg instanceof AttrPtg) {
                object = (AttrPtg)ptg;
                if (((AttrPtg)object).isOptimizedIf() || ((AttrPtg)object).isOptimizedChoose() || ((AttrPtg)object).isSkip() || ((AttrPtg)object).isSpace() || ((AttrPtg)object).isSemiVolatile()) continue;
                if (((AttrPtg)object).isSum()) {
                    stringArray = FormulaRenderer.getOperands(stack, ((AttrPtg)object).getNumberOfOperands());
                    stack.push(((AttrPtg)object).toFormulaString(stringArray));
                    continue;
                }
                throw new RuntimeException("Unexpected tAttr: " + ((AttrPtg)object).toString());
            }
            if (ptg instanceof WorkbookDependentFormula) {
                object = (WorkbookDependentFormula)((Object)ptg);
                stack.push(object.toFormulaString(formulaRenderingWorkbook));
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString());
                continue;
            }
            object = (OperationPtg)ptg;
            stringArray = FormulaRenderer.getOperands(stack, ((OperationPtg)object).getNumberOfOperands());
            stack.push(((OperationPtg)object).toFormulaString(stringArray));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String string = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return string;
    }

    private static String[] getOperands(Stack<String> stack, int n) {
        String[] stringArray = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            if (stack.isEmpty()) {
                String string = "Too few arguments supplied to operation. Expected (" + n + ") operands but got (" + (n - i - 1) + ")";
                throw new IllegalStateException(string);
            }
            stringArray[i] = stack.pop();
        }
        return stringArray;
    }
}

