/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.HashMap;
import java.util.Map;
import org.jopendocument.util.StringUtils;

public final class FileUtils {
    private static final Map<String, String> ext2mime = new HashMap<String, String>();
    public static final StringUtils.Escaper FILENAME_ESCAPER;

    private FileUtils() {
    }

    public static final String findMimeType(String string) {
        for (Map.Entry<String, String> entry : ext2mime.entrySet()) {
            if (!string.toLowerCase().endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        ext2mime.put(".xml", "text/xml");
        ext2mime.put(".jpg", "image/jpeg");
        ext2mime.put(".png", "image/png");
        ext2mime.put(".tiff", "image/tiff");
        FILENAME_ESCAPER = new StringUtils.Escaper('\'', 'Q');
        FILENAME_ESCAPER.add('\"', 'D').add(':', 'C').add('/', 'S').add('\\', 'A');
        FILENAME_ESCAPER.add('<', 'L').add('>', 'G').add('*', 'R').add('|', 'P').add('?', 'M');
    }
}

