/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.util.retry;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetryMode;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetrySetup;

public abstract class RetryAgent<T> {
    private RetrySetup setup;

    public RetryAgent() {
        this(RetrySetup.DEFAULT);
    }

    public RetryAgent(RetrySetup setup) {
        this.setup = setup;
    }

    protected abstract T target() throws Exception;

    protected abstract void cleanup() throws Exception;

    public T run() throws Exception {
        T result;
        if (this.setup.getMode() == RetryMode.COUNTED) {
            result = this.runCounted();
        } else if (this.setup.getMode() == RetryMode.TIMED) {
            result = this.runTimed();
        } else {
            throw new RuntimeException("Unsupported retry mode: '" + (Object)((Object)this.setup.getMode()) + "'");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private T runCounted() throws Exception {
        T result = null;
        boolean success = false;
        int attempts = this.setup.getStopCondition();
        int delay = this.setup.getBaseDelay();
        do {
            --attempts;
            result = this.target();
            success = true;
            try {
                this.cleanup();
            }
            catch (Exception e) {
                Main.error((String)"Could not clean up", (Object[])new Object[]{e});
            }
            continue;
            catch (Exception e) {
                try {
                    if (attempts <= 0) {
                        throw e;
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e1) {
                        Main.error((Throwable)e1);
                    }
                    delay = delay * 3 / 2;
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanup();
                    }
                    catch (Exception e2) {
                        Main.error((String)"Could not clean up", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e3) {
                    Main.error((String)"Could not clean up", (Object[])new Object[]{e3});
                }
            }
        } while (!success && attempts > 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private T runTimed() throws Exception {
        T result = null;
        boolean success = false;
        int delay = this.setup.getBaseDelay();
        int maxTime = this.setup.getStopCondition();
        do {
            long time;
            block14: {
                time = System.currentTimeMillis();
                result = this.target();
                success = true;
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    Main.error((String)"Could not clean up", (Object[])new Object[]{e});
                }
                break block14;
                catch (Exception e) {
                    try {
                        if (maxTime - delay <= 0) {
                            throw e;
                        }
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e1) {
                            Main.error((Throwable)e1);
                            throw e;
                        }
                        delay = delay * 3 / 2;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.cleanup();
                        }
                        catch (Exception e2) {
                            Main.error((String)"Could not clean up", (Object[])new Object[]{e2});
                        }
                        throw throwable;
                    }
                    try {
                        this.cleanup();
                    }
                    catch (Exception e3) {
                        Main.error((String)"Could not clean up", (Object[])new Object[]{e3});
                    }
                }
            }
            time = System.currentTimeMillis() - time;
            maxTime = (int)((long)maxTime - time);
        } while (!success && maxTime > 0);
        return result;
    }
}

