/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.util.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.util.http.HttpResponse;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetryAgent;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetrySetup;

public class HttpConnector {
    private final int timeout = 20000;
    private final RetrySetup retrySetup;
    protected HttpURLConnection connection;

    public HttpConnector(RetrySetup retrySetup) {
        this.retrySetup = retrySetup;
    }

    public HttpResponse executeGET(final URL url) throws IOException {
        RetryAgent<Boolean> agent = new RetryAgent<Boolean>(this.retrySetup){

            @Override
            protected Boolean target() throws IOException {
                HttpConnector.this.connection = (HttpURLConnection)url.openConnection();
                HttpConnector.this.connection.setConnectTimeout(20000);
                HttpConnector.this.connection.setReadTimeout(20000);
                HttpConnector.this.connection.connect();
                return true;
            }

            @Override
            protected void cleanup() throws IOException {
            }
        };
        try {
            agent.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        int responseCode = this.connection.getResponseCode();
        String responseMessage = this.connection.getResponseMessage();
        String responseContent = null;
        if (responseCode == 200 || responseCode == 201 || responseCode == 204) {
            responseContent = this.readContent(this.connection.getContent());
        }
        HttpResponse response = new HttpResponse(responseCode, responseMessage, responseContent);
        return response;
    }

    public HttpResponse executePOST(final URL url, final Map<String, String> requestHeaders, final Map<String, String> requestParameters) throws IOException {
        HttpResponse response = null;
        RetryAgent<Boolean> agent = new RetryAgent<Boolean>(this.retrySetup){

            @Override
            protected Boolean target() throws IOException {
                HttpConnector.this.connection = (HttpURLConnection)url.openConnection();
                HttpConnector.this.connection.setConnectTimeout(20000);
                HttpConnector.this.connection.setReadTimeout(20000);
                if (requestHeaders != null) {
                    for (String key : requestHeaders.keySet()) {
                        HttpConnector.this.connection.addRequestProperty(key, (String)requestHeaders.get(key));
                    }
                }
                StringBuffer sbEncodeParameters = new StringBuffer();
                if (requestParameters != null) {
                    HttpConnector.this.connection.setDoOutput(true);
                    sbEncodeParameters.append(HttpConnector.this.encodeParameters(requestParameters));
                }
                HttpConnector.this.connection.connect();
                if (sbEncodeParameters.length() > 0) {
                    try (OutputStreamWriter out = new OutputStreamWriter(HttpConnector.this.connection.getOutputStream());){
                        out.write(sbEncodeParameters.toString());
                    }
                }
                return true;
            }

            @Override
            protected void cleanup() throws IOException {
            }
        };
        try {
            agent.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        int responseCode = this.connection.getResponseCode();
        String responseMessage = this.connection.getResponseMessage();
        String responseContent = null;
        if (responseCode == 200 || responseCode == 201 || responseCode == 204) {
            responseContent = this.readContent(this.connection.getContent());
        }
        response = new HttpResponse(responseCode, responseMessage, responseContent);
        return response;
    }

    protected String readContent(Object obj) throws IOException {
        String result = "";
        InputStreamReader in = new InputStreamReader((InputStream)obj);
        BufferedReader buff = new BufferedReader(in);
        String line = "";
        while ((line = buff.readLine()) != null) {
            result = result + line;
        }
        return result;
    }

    protected String encodeParameters(Map<String, String> postParameters) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (String key : postParameters.keySet()) {
            if (i != 0) {
                buf.append("&");
            }
            try {
                buf.append(key).append("=").append(URLEncoder.encode(postParameters.get(key), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Main.error((Throwable)e);
            }
            ++i;
        }
        return buf.toString();
    }
}

