/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.lakewalker.Lakewalker;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerException;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerPlugin;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

class LakewalkerAction
extends JosmAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Cursor oldCursor;
    protected Thread executeThread;
    protected boolean cancel;
    protected boolean active = false;
    protected Collection<Command> commands = new LinkedList<Command>();
    protected Collection<Way> ways = new ArrayList<Way>();

    LakewalkerAction(String name) {
        super(name, "lakewalker-sml", I18n.tr((String)"Lake Walker.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:lakewalker", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Lake Walker", (Object[])new Object[0])}), (int)76, (int)5010), true);
        this.name = name;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.map == null || Main.map.mapView == null || this.active) {
            return;
        }
        this.active = true;
        this.oldCursor = Main.map.mapView.getCursor();
        Main.map.mapView.setCursor(ImageProvider.getCursor((String)"crosshair", (String)"lakewalker-sml"));
        Main.map.mapView.addMouseListener((MouseListener)this);
    }

    private void cleanupCache() {
        long maxCacheAge = System.currentTimeMillis() - (long)(Main.pref.getInteger("lakewalker.maxcacheage", 100) * 24 * 60 * 60) * 1000L;
        long maxCacheSize = (long)(Main.pref.getInteger("lakewalker.maxcachesize", 300) * 1024) * 1024L;
        for (String wmsFolder : LakewalkerPreferences.WMSLAYERS) {
            File wmsCacheDir = new File(LakewalkerPlugin.getLakewalkerCacheDir(), wmsFolder);
            if (wmsCacheDir.exists() && wmsCacheDir.isDirectory()) {
                File[] wmsCache = wmsCacheDir.listFiles();
                Arrays.sort(wmsCache, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return (int)(f2.lastModified() - f1.lastModified());
                    }
                });
                long folderSize = 0L;
                boolean quickdelete = false;
                for (File cacheEntry : wmsCache) {
                    if (!cacheEntry.isFile()) continue;
                    if (!quickdelete) {
                        if ((folderSize += cacheEntry.length()) > maxCacheSize) {
                            quickdelete = true;
                        } else if (cacheEntry.lastModified() < maxCacheAge) {
                            quickdelete = true;
                        }
                    }
                    if (!quickdelete) continue;
                    cacheEntry.delete();
                }
                continue;
            }
            if (wmsCacheDir.mkdirs()) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error creating cache directory: {0}", (Object[])new Object[]{wmsCacheDir.getPath()}));
        }
    }

    protected void lakewalk(Point clickPoint) {
        final LatLon pos = Main.map.mapView.getLatLon(clickPoint.x, clickPoint.y);
        final LatLon topLeft = Main.map.mapView.getLatLon(0, 0);
        final LatLon botRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), Main.map.mapView.getHeight());
        final int waylen = Main.pref.getInteger("lakewalker.max_segs_in_way", 500);
        final int maxnode = Main.pref.getInteger("lakewalker.max_nodes", 50000);
        final int threshold = Main.pref.getInteger("lakewalker.thresholdvalue", 90);
        final double epsilon = Main.pref.getDouble("lakewalker.epsilon", 3.0E-4);
        final int resolution = Main.pref.getInteger("lakewalker.landsat_res", 4000);
        final int tilesize = Main.pref.getInteger("lakewalker.landsat_size", 2000);
        final String startdir = Main.pref.get("lakewalker.startdir", "east");
        final String wmslayer = Main.pref.get("lakewalker.wms", "IR1");
        try {
            PleaseWaitRunnable lakewalkerTask = new PleaseWaitRunnable(I18n.tr((String)"Tracing", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    this.progressMonitor.subTask(I18n.tr((String)"checking cache...", (Object[])new Object[0]));
                    LakewalkerAction.this.cleanupCache();
                    LakewalkerAction.this.processnodelist(pos, topLeft, botRight, waylen, maxnode, threshold, epsilon, resolution, tilesize, startdir, wmslayer, this.progressMonitor.createSubTaskMonitor(-1, false));
                }

                protected void finish() {
                }

                protected void cancel() {
                    LakewalkerAction.this.cancel();
                }
            };
            Thread executeThread = new Thread((Runnable)lakewalkerTask);
            executeThread.start();
        }
        catch (Exception ex) {
            System.out.println("Exception caught: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processnodelist(LatLon pos, LatLon topLeft, LatLon botRight, int waylen, int maxnode, int threshold, double epsilon, int resolution, int tilesize, String startdir, String wmslayer, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(null, 3);
        try {
            ArrayList<double[]> nodelist = new ArrayList();
            Lakewalker lw = new Lakewalker(waylen, maxnode, threshold, epsilon, resolution, tilesize, startdir, wmslayer);
            try {
                nodelist = lw.trace(pos.lat(), pos.lon(), topLeft.lon(), botRight.lon(), topLeft.lat(), botRight.lat(), progressMonitor.createSubTaskMonitor(1, false));
            }
            catch (LakewalkerException e) {
                System.out.println(e.getMessage());
            }
            System.out.println(nodelist.size() + " nodes generated");
            progressMonitor.subTask(I18n.tr((String)"Running vertex reduction...", (Object[])new Object[0]));
            nodelist = lw.vertexReduce(nodelist, epsilon);
            progressMonitor.worked(1);
            progressMonitor.subTask(I18n.tr((String)"Running Douglas-Peucker approximation...", (Object[])new Object[0]));
            nodelist = lw.douglasPeucker(nodelist, epsilon, 0);
            progressMonitor.worked(1);
            progressMonitor.subTask(I18n.tr((String)"Removing duplicate nodes...", (Object[])new Object[0]));
            nodelist = lw.duplicateNodeRemove(nodelist);
            if (nodelist.size() == 0) {
                return;
            }
            Way way = new Way();
            Node n = null;
            Node fn = null;
            double eastOffset = Main.pref.getDouble("lakewalker.east_offset", 0.0);
            double northOffset = Main.pref.getDouble("lakewalker.north_offset", 0.0);
            int nodesinway = 0;
            for (int i = 0; i < nodelist.size(); ++i) {
                if (this.cancel) {
                    return;
                }
                try {
                    LatLon ll = new LatLon(nodelist.get(i)[0] + northOffset, nodelist.get(i)[1] + eastOffset);
                    n = new Node(ll);
                    if (fn == null) {
                        fn = n;
                    }
                    this.commands.add((Command)new AddCommand((OsmPrimitive)n));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                way.addNode(n);
                if (nodesinway > Main.pref.getInteger("lakewalker.max_segs_in_way", 500)) {
                    String waytype = Main.pref.get("lakewalker.waytype", "water");
                    if (!waytype.equals("none")) {
                        way.put("natural", waytype);
                    }
                    way.put("source", Main.pref.get("lakewalker.source", "Landsat"));
                    this.commands.add((Command)new AddCommand((OsmPrimitive)way));
                    way = new Way();
                    way.addNode(n);
                    nodesinway = 0;
                }
                ++nodesinway;
            }
            String waytype = Main.pref.get("lakewalker.waytype", "water");
            if (!waytype.equals("none")) {
                way.put("natural", waytype);
            }
            way.put("source", Main.pref.get("lakewalker.source", "Landsat"));
            way.addNode(fn);
            this.commands.add((Command)new AddCommand((OsmPrimitive)way));
            if (!this.commands.isEmpty()) {
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Lakewalker trace", (Object[])new Object[0]), this.commands));
                this.getLayerManager().getEditDataSet().setSelected(this.ways);
            } else {
                System.out.println("Failed");
            }
            this.commands = new LinkedList<Command>();
            this.ways = new ArrayList<Way>();
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.active) {
            this.active = false;
            Main.map.mapView.removeMouseListener((MouseListener)this);
            Main.map.mapView.setCursor(this.oldCursor);
            this.lakewalk(e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

