/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2.preferences;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;

public class ServerParamList {
    ArrayList<ServerParam> m_listServerParam = new ArrayList();
    ServerParam m_oActivParam = null;
    String m_strFilename;

    public ServerParamList(String filename) {
        this.m_strFilename = filename;
        if (filename == null) {
            this.loadDefault();
        } else {
            this.load();
        }
    }

    public void load() {
        try (BufferedReader oReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_strFilename), "UTF-8"));){
            String strLine;
            StringBuilder oBuilder = new StringBuilder();
            while ((strLine = oReader.readLine()) != null) {
                oBuilder.append(strLine).append('\n');
                if (!strLine.equals("")) continue;
                this.m_listServerParam.add(ServerParam.unserialize(oBuilder.toString()));
                oBuilder = new StringBuilder();
            }
        }
        catch (Exception e) {
            this.loadDefault();
        }
    }

    public void loadDefault() {
        try (InputStream oIP = this.getClass().getResourceAsStream("/resources/serverParam.cfg");
             BufferedReader oReader = new BufferedReader(new InputStreamReader(oIP));){
            String strLine;
            StringBuilder oBuilder = new StringBuilder();
            while ((strLine = oReader.readLine()) != null) {
                oBuilder.append(strLine).append('\n');
                if (!strLine.equals("")) continue;
                this.m_listServerParam.add(ServerParam.unserialize(oBuilder.toString()));
                oBuilder = new StringBuilder();
            }
        }
        catch (Exception e) {
            Main.warn((String)("Tracer2 warning: can't load file " + this.m_strFilename));
        }
    }

    public void save() {
        try (OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_strFilename), "UTF-8");){
            for (ServerParam param : this.m_listServerParam) {
                oWriter.write(param.serialize());
            }
        }
        catch (Exception e) {
            Main.warn((String)("Tracer2 warning: can't save file " + this.m_strFilename));
        }
    }

    public List<ServerParam> getParamList() {
        return this.m_listServerParam;
    }

    public ServerParam getActivParam() {
        return this.m_oActivParam;
    }

    public void setActivParam(ServerParam param) {
        if (this.m_listServerParam.contains(param)) {
            this.m_oActivParam = param;
        }
    }

    public List<ServerParam> getEnableParamList() {
        ArrayList<ServerParam> listParam = new ArrayList<ServerParam>();
        for (ServerParam param : this.m_listServerParam) {
            if (!param.isEnabled()) continue;
            listParam.add(param);
        }
        return listParam;
    }

    public void addParam(ServerParam param) {
        this.m_listServerParam.add(param);
    }

    public void removeParam(ServerParam param) {
        param.setEnabled(false);
        this.m_listServerParam.remove(param);
    }
}

