/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.util.Collections;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditTableModel;
import org.openstreetmap.josm.tools.I18n;

public class IncompleteAddressesTableModel
extends AddressEditTableModel {
    private static final long serialVersionUID = -5951629033395186324L;
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{I18n.tr((String)"Country", (Object[])new Object[0]), I18n.trc((String)"address", (String)"City"), I18n.tr((String)"Postcode", (Object[])new Object[0]), I18n.tr((String)"Street", (Object[])new Object[0]), I18n.tr((String)"Number", (Object[])new Object[0])};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};

    public IncompleteAddressesTableModel(AddressEditContainer addressContainer) {
        super(addressContainer);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return 0;
        }
        return this.addressContainer.getNumberOfIncompleteAddresses();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OSMAddress aNode = (OSMAddress)this.getEntityOfRow(row);
        if (aNode == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return aNode.getCountry();
            }
            case 1: {
                return aNode.getCity();
            }
            case 2: {
                return aNode.getPostalCode();
            }
            case 3: {
                return aNode.getStreetName();
            }
            case 4: {
                return aNode.getHouseNumber();
            }
        }
        throw new RuntimeException("Invalid column index: " + column);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return COLUMN_CLASSES[arg0];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public IOSMEntity getEntityOfRow(int row) {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return null;
        }
        if (row < 0 || row >= this.addressContainer.getNumberOfIncompleteAddresses()) {
            return null;
        }
        return this.addressContainer.getIncompleteAddresses().get(row);
    }

    @Override
    public int getRowOfEntity(IOSMEntity entity) {
        if (this.addressContainer == null || this.addressContainer.getIncompleteAddresses() == null) {
            return -1;
        }
        return this.addressContainer.getIncompleteAddresses().indexOf(entity);
    }

    @Override
    protected void sortByColumn(int column, boolean ascending) {
        if (this.addressContainer.getNumberOfIncompleteAddresses() == 0) {
            return;
        }
        Collections.sort(this.addressContainer.getIncompleteAddresses(), new IncompleteAddressModelSorter(column, ascending));
    }

    static class IncompleteAddressModelSorter
    extends AddressEditTableModel.ColumnSorter<OSMAddress> {
        public IncompleteAddressModelSorter(int column, boolean asc) {
            super(column, asc);
        }

        @Override
        public int compare(OSMAddress arg0, OSMAddress arg1) {
            int cc = 0;
            switch (this.getColumn()) {
                case 0: {
                    cc = arg0.getCountry().compareTo(arg1.getCountry());
                    break;
                }
                case 1: {
                    cc = arg0.getCity().compareTo(arg1.getCity());
                    break;
                }
                case 2: {
                    cc = arg0.getPostalCode().compareTo(arg1.getPostalCode());
                    break;
                }
                case 3: {
                    cc = arg0.getStreetName().compareTo(arg1.getStreetName());
                    break;
                }
                case 4: {
                    cc = arg0.getHouseNumber().compareTo(arg1.getHouseNumber());
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid column index: " + this.getColumn());
                }
            }
            if (!this.isAscending()) {
                cc = -cc;
            }
            return cc;
        }
    }
}

