/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryExportDialog;
import org.openstreetmap.josm.plugins.mapillary.io.export.MapillaryExportManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryExportAction
extends JosmAction {
    private static final long serialVersionUID = 6009490043174837948L;
    private MapillaryExportDialog dialog;

    public MapillaryExportAction() {
        super(I18n.tr((String)"Export pictures", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Export pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Export Mapillary", (String)I18n.tr((String)"Export Mapillary pictures", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryExport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        JOptionPane pane = new JOptionPane();
        JButton ok = new JButton("Ok");
        ok.addActionListener(new OKAction(pane));
        JButton cancel = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        cancel.addActionListener(new CancelAction(pane));
        this.dialog = new MapillaryExportDialog(ok);
        pane.setMessage(this.dialog);
        pane.setOptions(new JButton[]{ok, cancel});
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Export images", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0 && this.dialog.chooser != null) {
            if (this.dialog.group.isSelected(this.dialog.all.getModel())) {
                this.export(MapillaryLayer.getInstance().getData().getImages());
            } else if (this.dialog.group.isSelected(this.dialog.sequence.getModel())) {
                ConcurrentSkipListSet<MapillaryAbstractImage> images = new ConcurrentSkipListSet<MapillaryAbstractImage>();
                for (MapillaryAbstractImage image : MapillaryLayer.getInstance().getData().getMultiSelectedImages()) {
                    if (image instanceof MapillaryImage) {
                        if (images.contains(image)) continue;
                        images.addAll(image.getSequence().getImages());
                        continue;
                    }
                    images.add(image);
                }
                this.export(images);
            } else if (this.dialog.group.isSelected(this.dialog.selected.getModel())) {
                this.export(MapillaryLayer.getInstance().getData().getMultiSelectedImages());
            }
        } else if (this.dialog.group.isSelected(this.dialog.rewrite.getModel())) {
            ArrayList<MapillaryImportedImage> images = new ArrayList<MapillaryImportedImage>();
            MapillaryLayer.getInstance().getData().getImages().stream().filter(img -> img instanceof MapillaryImportedImage).forEach(img -> images.add((MapillaryImportedImage)img));
            try {
                Main.worker.submit((Runnable)((Object)new MapillaryExportManager(images)));
            }
            catch (IOException e1) {
                Main.error((Throwable)e1);
            }
        }
        dlg.dispose();
    }

    public void export(Set<MapillaryAbstractImage> images) {
        Main.worker.submit((Runnable)((Object)new MapillaryExportManager(images, this.dialog.chooser.getSelectedFile().toString())));
    }

    private static class CancelAction
    implements ActionListener {
        private final JOptionPane pane;

        public CancelAction(JOptionPane pane) {
            this.pane = pane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pane.setValue(2);
        }
    }

    private static class OKAction
    implements ActionListener {
        private final JOptionPane pane;

        public OKAction(JOptionPane pane) {
            this.pane = pane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pane.setValue(0);
        }
    }
}

