/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.IAddressEditContainerListener;
import org.openstreetmap.josm.plugins.fixAddresses.IOSMEntity;

public abstract class AddressEditTableModel
extends DefaultTableModel
implements IAddressEditContainerListener {
    protected AddressEditContainer addressContainer;
    protected int sortCol = 0;
    protected boolean isSortAsc = true;

    public AddressEditTableModel(AddressEditContainer addressContainer) {
        this.addressContainer = addressContainer;
        addressContainer.addChangedListener(this);
    }

    @Override
    public void containerChanged(AddressEditContainer container) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressEditTableModel.this.fireTableDataChanged();
                }
            });
        }
    }

    @Override
    public void entityChanged(IOSMEntity entity) {
        int row = this.getRowOfEntity(entity);
        if (row != -1) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public abstract IOSMEntity getEntityOfRow(int var1);

    public abstract int getRowOfEntity(IOSMEntity var1);

    protected abstract void sortByColumn(int var1, boolean var2);

    protected static abstract class ColumnSorter<E>
    implements Comparator<E> {
        private int column;
        private boolean ascending;

        public ColumnSorter(int column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }

        protected int getColumn() {
            return this.column;
        }

        protected boolean isAscending() {
            return this.ascending;
        }

        @Override
        public abstract int compare(E var1, E var2);
    }

    class ColumnListener
    extends MouseAdapter {
        protected JTable table;

        public ColumnListener(JTable t) {
            this.table = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex;
            TableColumnModel colModel = this.table.getColumnModel();
            int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (AddressEditTableModel.this.sortCol == modelIndex) {
                AddressEditTableModel.this.isSortAsc = !AddressEditTableModel.this.isSortAsc;
            } else {
                AddressEditTableModel.this.sortCol = modelIndex;
            }
            for (int i = 0; i < colModel.getColumnCount(); ++i) {
                TableColumn column = colModel.getColumn(i);
                column.setHeaderValue(AddressEditTableModel.this.getColumnName(column.getModelIndex()));
            }
            this.table.getTableHeader().repaint();
            AddressEditTableModel.this.sortByColumn(AddressEditTableModel.this.sortCol, AddressEditTableModel.this.isSortAsc);
            this.table.tableChanged(new TableModelEvent(AddressEditTableModel.this));
            this.table.repaint();
        }
    }
}

