/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.utils.ValidationUtil;

public final class MapillaryURL {
    private static final String CLIENT_ID = "T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz";
    private static final String BASE_API_V2_URL = "https://a.mapillary.com/v2/";
    private static final String BASE_API_V3_URL = "https://a.mapillary.com/v3/";
    private static final String BASE_WEBSITE_URL = "https://www.mapillary.com/";
    private static final String LEGACY_WEBSITE_URL = "https://legacy.mapillary.com/";

    private MapillaryURL() {
    }

    public static URL browseEditURL(String imgKey) {
        ValidationUtil.throwExceptionForInvalidImgKey(imgKey, false);
        return MapillaryURL.string2URL(BASE_WEBSITE_URL, "map/e/", imgKey);
    }

    public static URL browseImageURL(String key) {
        ValidationUtil.throwExceptionForInvalidImgKey(key, false);
        return MapillaryURL.string2URL(BASE_WEBSITE_URL, "map/im/", key);
    }

    public static URL browseUploadImageURL() {
        return MapillaryURL.string2URL(BASE_WEBSITE_URL, "map/upload/im");
    }

    public static URL connectURL(String redirectURI) {
        HashMap<String, String> parts = new HashMap<String, String>();
        if (redirectURI != null && redirectURI.length() >= 1) {
            parts.put("redirect_uri", redirectURI);
        }
        parts.put("response_type", "token");
        parts.put("scope", "user:read public:upload public:write");
        return MapillaryURL.string2URL(LEGACY_WEBSITE_URL, "connect", MapillaryURL.queryString(parts));
    }

    public static URL searchImageInfoURL(Bounds bounds, int page, IMAGE_SELECTOR selector) {
        String selectorString = "";
        if (selector != null) {
            switch (selector) {
                case BLURRED_ONLY: {
                    selectorString = "/b";
                    break;
                }
                case COMMENTED_ONLY: {
                    selectorString = "/cm";
                    break;
                }
                case OBJ_REC_ONLY: {
                    selectorString = "/or";
                    break;
                }
                default: {
                    selectorString = "";
                }
            }
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        MapillaryURL.putBoundsInQueryStringParts(parts, bounds);
        parts.put("page", Integer.toString(page));
        parts.put("limit", "20");
        return MapillaryURL.string2URL(BASE_API_V2_URL, "search/im", selectorString, MapillaryURL.queryString(parts));
    }

    public static URL searchSequenceURL(Bounds bounds, int page) {
        HashMap<String, String> parts = new HashMap<String, String>();
        MapillaryURL.putBoundsInQueryStringParts(parts, bounds);
        parts.put("page", Integer.toString(page));
        parts.put("limit", "10");
        return MapillaryURL.string2URL(BASE_API_V2_URL, "search/s", MapillaryURL.queryString(parts));
    }

    public static URL uploadSecretsURL() {
        return MapillaryURL.string2URL(BASE_API_V2_URL, "me/uploads/secrets", MapillaryURL.queryString(null));
    }

    public static URL submitChangesetURL() {
        return MapillaryURL.string2URL(BASE_API_V3_URL, "changeset", MapillaryURL.queryString(null));
    }

    public static URL userURL() {
        return MapillaryURL.string2URL(BASE_API_V2_URL, "me", MapillaryURL.queryString(null));
    }

    private static void putBoundsInQueryStringParts(Map<String, String> parts, Bounds bounds) {
        if (bounds != null) {
            parts.put("min_lat", String.format(Locale.UK, "%f", bounds.getMin().lat()));
            parts.put("max_lat", String.format(Locale.UK, "%f", bounds.getMax().lat()));
            parts.put("min_lon", String.format(Locale.UK, "%f", bounds.getMin().lon()));
            parts.put("max_lon", String.format(Locale.UK, "%f", bounds.getMax().lon()));
        }
    }

    private static String queryString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?client_id=").append(CLIENT_ID);
        if (parts != null) {
            for (Map.Entry<String, String> entry : parts.entrySet()) {
                try {
                    ret.append('&').append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Main.error((Throwable)e);
                }
            }
        }
        return ret.toString();
    }

    private static URL string2URL(String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; strings != null && i < strings.length; ++i) {
            builder.append(strings[i]);
        }
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)new Exception(String.format("The class '%s' produces malformed URLs like '%s'!", MapillaryURL.class.getName(), builder), e));
            return null;
        }
    }

    public static enum IMAGE_SELECTOR {
        BLURRED_ONLY,
        COMMENTED_ONLY,
        OBJ_REC_ONLY;

    }
}

