/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;

public class MapillarySequenceDownloadThread
extends Thread {
    private final Bounds bounds;
    private final int page;
    private final ExecutorService ex;

    public MapillarySequenceDownloadThread(ExecutorService ex, Bounds bounds, int page) {
        this.bounds = bounds;
        this.page = page;
        this.ex = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(MapillaryURL.searchSequenceURL(this.bounds, this.page).openStream(), "UTF-8"));){
            JsonObject jsonall = Json.createReader((Reader)br).readObject();
            if (!jsonall.getBoolean("more") && !this.ex.isShutdown()) {
                this.ex.shutdown();
            }
            JsonArray jsonseq = jsonall.getJsonArray("ss");
            boolean isSequenceWrong = false;
            for (int i = 0; i < jsonseq.size(); ++i) {
                JsonObject jsonobj = jsonseq.getJsonObject(i);
                JsonArray cas = jsonobj.getJsonArray("cas");
                JsonArray coords = jsonobj.getJsonArray("coords");
                JsonArray keys = jsonobj.getJsonArray("keys");
                ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
                for (int j = 0; j < cas.size(); ++j) {
                    try {
                        images.add(new MapillaryImage(keys.getString(j), new LatLon(coords.getJsonArray(j).getJsonNumber(1).doubleValue(), coords.getJsonArray(j).getJsonNumber(0).doubleValue()), cas.getJsonNumber(j).doubleValue()));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        Main.warn((String)("Mapillary bug at " + MapillaryURL.searchSequenceURL(this.bounds, this.page)));
                        isSequenceWrong = true;
                    }
                }
                if (!isSequenceWrong) {
                    MapillarySequence sequence = new MapillarySequence(jsonobj.getString("key"), jsonobj.getJsonNumber("captured_at").longValue());
                    List finalImages = images.parallelStream().filter(MapillarySequenceDownloadThread::isInside).collect(Collectors.toList());
                    Class<MapillarySequenceDownloadThread> clazz = MapillarySequenceDownloadThread.class;
                    // MONITORENTER : org.openstreetmap.josm.plugins.mapillary.io.download.MapillarySequenceDownloadThread.class
                    Class<MapillaryAbstractImage> clazz2 = MapillaryAbstractImage.class;
                    // MONITORENTER : org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage.class
                    for (MapillaryImage img : finalImages) {
                        if (MapillaryLayer.getInstance().getData().getImages().contains(img)) {
                            MapillaryImage lambdaImg = img;
                            img = (MapillaryImage)MapillaryLayer.getInstance().getData().getImages().parallelStream().filter(source -> source.equals(lambdaImg)).findAny().get();
                            sequence.add(img);
                            img.setSequence(sequence);
                            finalImages.set(finalImages.indexOf(img), img);
                            continue;
                        }
                        img.setSequence(sequence);
                        sequence.add(img);
                    }
                    // MONITOREXIT : clazz2
                    // MONITOREXIT : clazz
                    MapillaryLayer.getInstance().getData().add(new ConcurrentSkipListSet<MapillaryAbstractImage>(finalImages), false);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Main.error((String)String.format("Error reading the url %s, this might be a Mapillary problem.", MapillaryURL.searchSequenceURL(this.bounds, this.page)), (Object[])new Object[]{e});
        }
        MapillaryData.dataUpdated();
    }

    private static boolean isInside(MapillaryAbstractImage image) {
        return MapillaryLayer.getInstance().getData().getBounds().parallelStream().anyMatch(b -> b.contains(image.getLatLon()));
    }
}

