/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryMainDialog;

public class MapillaryData {
    private final Set<MapillaryAbstractImage> images;
    private MapillaryAbstractImage selectedImage = null;
    private MapillaryAbstractImage highlightedImage;
    private final Set<MapillaryAbstractImage> multiSelectedImages;
    private final List<MapillaryDataListener> listeners = new CopyOnWriteArrayList<MapillaryDataListener>();
    private final List<Bounds> bounds;

    protected MapillaryData() {
        this.images = Collections.newSetFromMap(new ConcurrentHashMap());
        this.multiSelectedImages = Collections.newSetFromMap(new ConcurrentHashMap());
        this.bounds = new CopyOnWriteArrayList<Bounds>();
        this.addListener(MapillaryPlugin.getWalkAction());
        this.addListener(MapillaryPlugin.getZoomAction());
        this.addListener(MapillaryPlugin.getUploadAction());
        if (Main.main != null) {
            this.addListener(MapillaryMainDialog.getInstance());
        }
    }

    public synchronized void add(MapillaryAbstractImage image) {
        this.add(image, true);
    }

    public synchronized void add(MapillaryAbstractImage image, boolean update) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
        if (update) {
            MapillaryData.dataUpdated();
        }
        this.fireImagesAdded();
    }

    public synchronized void add(Set<MapillaryAbstractImage> images) {
        this.add(images, true);
    }

    public synchronized void add(Set<MapillaryAbstractImage> images, boolean update) {
        for (MapillaryAbstractImage image : images) {
            this.add(image, update);
        }
    }

    public final void addListener(MapillaryDataListener lis) {
        this.listeners.add(lis);
    }

    public void addMultiSelectedImage(MapillaryAbstractImage image) {
        if (!this.multiSelectedImages.contains(image)) {
            if (this.getSelectedImage() == null) {
                this.setSelectedImage(image);
            } else {
                this.multiSelectedImages.add(image);
            }
        }
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
    }

    public void addMultiSelectedImage(Set<MapillaryAbstractImage> images) {
        images.stream().filter(image -> !this.multiSelectedImages.contains(image)).forEach(image -> {
            if (this.getSelectedImage() == null) {
                this.setSelectedImage((MapillaryAbstractImage)image);
            } else {
                this.multiSelectedImages.add((MapillaryAbstractImage)image);
            }
        });
        Main.map.mapView.repaint();
    }

    public List<Bounds> getBounds() {
        return this.bounds;
    }

    public synchronized void remove(MapillaryAbstractImage image) {
        if (Main.main != null && MapillaryMainDialog.getInstance().getImage() != null) {
            MapillaryMainDialog.getInstance().setImage(null);
            MapillaryMainDialog.getInstance().updateImage();
        }
        this.setSelectedImage(null);
        this.images.remove(image);
        if (image.getSequence() != null) {
            image.getSequence().remove(image);
        }
        if (Main.main != null) {
            MapillaryData.dataUpdated();
        }
    }

    public synchronized void remove(Set<MapillaryAbstractImage> images) {
        images.forEach(this::remove);
    }

    public void removeListener(MapillaryDataListener lis) {
        this.listeners.remove(lis);
    }

    public void setHighlightedImage(MapillaryAbstractImage image) {
        this.highlightedImage = image;
    }

    public MapillaryAbstractImage getHighlightedImage() {
        return this.highlightedImage;
    }

    public static synchronized void dataUpdated() {
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
    }

    public synchronized Set<MapillaryAbstractImage> getImages() {
        return this.images;
    }

    public synchronized Set<MapillarySequence> getSequences() {
        Set<MapillarySequence> result = this.getImages().stream().map(MapillaryAbstractImage::getSequence).collect(Collectors.toSet());
        return result;
    }

    public MapillaryAbstractImage getSelectedImage() {
        return this.selectedImage;
    }

    private void fireImagesAdded() {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.stream().filter(lis -> lis != null).forEach(MapillaryDataListener::imagesAdded);
    }

    public void selectNext() {
        this.selectNext(Main.pref.getBoolean("mapillary.move-to-picture", true));
    }

    public void selectNext(boolean moveToPicture) {
        if (this.getSelectedImage() == null) {
            throw new IllegalStateException();
        }
        if (this.getSelectedImage().getSequence() == null) {
            throw new IllegalStateException();
        }
        MapillaryAbstractImage tempImage = this.selectedImage;
        while (tempImage.next() != null) {
            if (!(tempImage = tempImage.next()).isVisible()) continue;
            this.setSelectedImage(tempImage, moveToPicture);
            break;
        }
    }

    public void selectPrevious() {
        this.selectPrevious(Main.pref.getBoolean("mapillary.move-to-picture", true));
    }

    public void selectPrevious(boolean moveToPicture) {
        if (this.getSelectedImage() == null) {
            throw new IllegalStateException();
        }
        if (this.getSelectedImage().getSequence() == null) {
            throw new IllegalStateException();
        }
        MapillaryAbstractImage tempImage = this.selectedImage;
        while (tempImage.previous() != null) {
            if (!(tempImage = tempImage.previous()).isVisible()) continue;
            this.setSelectedImage(tempImage, moveToPicture);
            break;
        }
    }

    public void setSelectedImage(MapillaryAbstractImage image) {
        this.setSelectedImage(image, false);
    }

    public void setSelectedImage(MapillaryAbstractImage image, boolean zoom) {
        MapillaryAbstractImage oldImage = this.selectedImage;
        this.selectedImage = image;
        this.multiSelectedImages.clear();
        if (image != null) {
            this.multiSelectedImages.add(image);
        }
        if (image != null && Main.main != null && image instanceof MapillaryImage) {
            MapillaryImage mapillaryImage = (MapillaryImage)image;
            if (mapillaryImage.next() != null) {
                CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.next());
                if (mapillaryImage.next().next() != null) {
                    CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.next().next());
                }
            }
            if (mapillaryImage.previous() != null) {
                CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.previous());
                if (mapillaryImage.previous().previous() != null) {
                    CacheUtils.downloadPicture((MapillaryImage)mapillaryImage.previous().previous());
                }
            }
        }
        if (zoom && Main.main != null) {
            Main.map.mapView.zoomTo(this.getSelectedImage().getMovingLatLon());
        }
        if (Main.main != null) {
            Main.map.mapView.repaint();
        }
        this.fireSelectedImageChanged(oldImage, this.selectedImage);
    }

    private void fireSelectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.stream().filter(lis -> lis != null).forEach(lis -> lis.selectedImageChanged(oldImage, newImage));
    }

    public Set<MapillaryAbstractImage> getMultiSelectedImages() {
        return this.multiSelectedImages;
    }

    public synchronized void setImages(Set<MapillaryAbstractImage> images) {
        this.images.clear();
        this.images.addAll(images);
    }

    public int size() {
        return this.images.size();
    }
}

