/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitOnIntersectionsAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Split adjacent ways", (Object[])new Object[0]);

    public SplitOnIntersectionsAction() {
        super(TITLE, "dumbutils/splitonintersections", I18n.tr((String)"Split adjacent ways on T-intersections", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:splitonintersections", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Split adjacent ways", (Object[])new Object[0])}), (int)80, (int)5010), true);
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Command> list = new ArrayList<Command>();
        List selectedWays = OsmPrimitive.getFilteredList((Collection)this.getLayerManager().getEditDataSet().getSelected(), Way.class);
        HashMap splitWays = new HashMap();
        for (Way way : selectedWays) {
            if (way.getNodesCount() <= 1 || way.hasIncompleteNodes() || way.isClosed()) continue;
            for (Node node : new Node[]{way.getNode(0), way.getNode(way.getNodesCount() - 1)}) {
                Iterator it;
                List refs = OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class);
                refs.remove(way);
                if (selectedWays.size() > 1) {
                    it = refs.iterator();
                    while (it.hasNext()) {
                        if (selectedWays.contains(it.next())) continue;
                        it.remove();
                    }
                }
                it = refs.iterator();
                while (it.hasNext()) {
                    Way w = (Way)it.next();
                    if (!w.isDeleted() && !w.isIncomplete() && w.isInnerNode(node)) continue;
                    it.remove();
                }
                if (refs.size() == 1) {
                    if (splitWays.containsKey(refs.get(0))) {
                        ((List)splitWays.get(refs.get(0))).add(node);
                        continue;
                    }
                    ArrayList<Node> nodes = new ArrayList<Node>(1);
                    nodes.add(node);
                    splitWays.put((Way)refs.get(0), nodes);
                    continue;
                }
                if (refs.size() <= 1) continue;
                new Notification(I18n.tr((String)"There are several ways containing one of the splitting nodes. Select ways participating in this operation.", (Object[])new Object[0])).setIcon(2).show();
                return;
            }
        }
        for (Way splitWay : splitWays.keySet()) {
            List wayChunks = SplitWayAction.buildSplitChunks((Way)splitWay, (List)((List)splitWays.get(splitWay)));
            if (wayChunks == null) continue;
            ArrayList sel = new ArrayList(selectedWays.size());
            sel.addAll(selectedWays);
            SplitWayAction.SplitWayResult result = SplitWayAction.splitWay((OsmDataLayer)this.getLayerManager().getEditLayer(), (Way)splitWay, (List)wayChunks, sel);
            list.add(result.getCommand());
        }
        if (!list.isEmpty()) {
            Main.main.undoRedo.add((Command)(list.size() == 1 ? (Command)list.get(0) : new SequenceCommand(TITLE, list)));
            this.getLayerManager().getEditDataSet().clearSelection();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean ok = false;
        if (selection != null) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Way) {
                    ok = true;
                    continue;
                }
                ok = false;
                break;
            }
        }
        this.setEnabled(ok);
    }
}

