/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdLayer;

public class OdOsmDataLayer
extends OsmDataLayer
implements OdLayer {
    private final OdDataLayer dataLayer;

    public OdOsmDataLayer(OdDataLayer dataLayer, DataSet data, String name) {
        super(data, name, null);
        this.dataLayer = dataLayer;
    }

    public final void removeForbiddenTags() {
        if (this.dataLayer != null && this.dataLayer.handler != null && this.dataLayer.handler.hasForbiddenTags()) {
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    OdOsmDataLayer.this.data.clearSelection();
                    for (OsmPrimitive p : OdOsmDataLayer.this.data.allPrimitives()) {
                        if (!((OdOsmDataLayer)OdOsmDataLayer.this).dataLayer.handler.isForbidden((IPrimitive)p)) continue;
                        OdOsmDataLayer.this.data.addSelected(new PrimitiveId[]{p});
                        List nodes = null;
                        if (p instanceof Way) {
                            nodes = ((Way)p).getNodes();
                        }
                        if (nodes == null) continue;
                        for (Node n : nodes) {
                            ArrayList<OsmPrimitive> refferingAllowedWays = new ArrayList<OsmPrimitive>();
                            for (OsmPrimitive referrer : n.getReferrers()) {
                                if (!(referrer instanceof Way) || ((OdOsmDataLayer)OdOsmDataLayer.this).dataLayer.handler.isForbidden((IPrimitive)referrer)) continue;
                                refferingAllowedWays.add(referrer);
                            }
                            if (!refferingAllowedWays.isEmpty()) continue;
                            OdOsmDataLayer.this.data.addSelected(new PrimitiveId[]{n});
                        }
                    }
                    Collection sel = OdOsmDataLayer.this.data.getSelected();
                    if (!sel.isEmpty()) {
                        Main.main.menu.purge.actionPerformed(null);
                    }
                }
            });
        }
    }

    @Override
    public OdDataLayer getDataLayer() {
        return this.dataLayer;
    }
}

