/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.auto_tools.actions;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SplittingTool
extends MapMode {
    private Point mousePos;
    private double toleranceMultiplier;
    private static int snapToIntersectionThreshold;
    int counter = 0;

    public SplittingTool(MapFrame mapFrame) {
        super(I18n.tr((String)"Knife tool", (Object[])new Object[0]), "iconknife", I18n.tr((String)"Split way.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:KnifeTool", (String)I18n.tr((String)"Mode:KnifeTool", (Object[])new Object[]{I18n.tr((String)"Split", (Object[])new Object[0])}), (int)84, (int)5003), mapFrame, ImageProvider.getCursor((String)"crosshair", null));
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.toleranceMultiplier = 0.01 * (double)NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3 || e.getButton() != 1 || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Main.map.mapView.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == Main.map.mapMode.getShortcut().getAssignedKey()) {
                    ++SplittingTool.this.counter;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (SplittingTool.this.counter != 0) {
                    Main.map.selectMapMode((MapMode)Main.map.mapModeSelect);
                    SplittingTool.this.counter = 0;
                }
            }
        });
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        DataSet ds = Main.getLayerManager().getEditDataSet();
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(ds.getSelected());
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        ArrayList<Way> replacedWays = new ArrayList<Way>();
        boolean newNode = false;
        Node n = null;
        n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        if (OsmPrimitive.getFilteredList(newSelection, Node.class).size() == 1 && OsmPrimitive.getFilteredList(newSelection, Way.class).isEmpty()) {
            newSelection.clear();
            Main.getLayerManager().getEditDataSet().setSelected(newSelection);
        }
        if (n != null) {
            if (!newSelection.isEmpty()) {
                this.SplitRoad(n, ds, newSelection);
                Main.map.selectMapMode((MapMode)Main.map.mapModeSelect);
                return;
            }
        } else if (n != null) {
            EastNorth foundPoint = n.getEastNorth();
            double tolerance = Main.map.mapView.getDist100Pixel() * this.toleranceMultiplier;
            if (foundPoint.distance(foundPoint) > tolerance) {
                n = new Node(foundPoint);
                newNode = true;
            }
        } else {
            EastNorth mouseEN = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            n = new Node(mouseEN);
            newNode = true;
        }
        if (newNode) {
            if (n.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot add a node outside of the world.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                return;
            }
            cmds.add((Command)new AddCommand((OsmPrimitive)n));
            List wss = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(n), OsmPrimitive.isSelectablePredicate);
            this.insertNodeIntoAllNearbySegments(wss, n, newSelection, cmds, replacedWays, reuseWays);
        }
        SequenceCommand c = new SequenceCommand("Add node into way and connect", cmds);
        Main.main.undoRedo.add((Command)c);
        if (OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class).isEmpty()) {
            Main.getLayerManager().getEditDataSet().removePrimitive(n.getPrimitiveId());
        } else {
            this.SplitRoad(n, ds, newSelection);
            Main.map.selectMapMode((MapMode)Main.map.mapModeSelect);
        }
    }

    private void insertNodeIntoAllNearbySegments(List<WaySegment> wss, Node n, Collection<OsmPrimitive> newSelection, Collection<Command> cmds, List<Way> replacedWays, List<Way> reuseWays) {
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            is.add(ws.lowerIndex);
        }
        HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            Way w = (Way)insertPoint.getKey();
            List is = (List)insertPoint.getValue();
            Way wnew = new Way(w);
            SplittingTool.pruneSuccsAndReverse(is);
            Iterator iterator = is.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                segSet.add((Pair<Node, Node>)Pair.sort((Pair)new Pair((Object)w.getNode(i), (Object)w.getNode(i + 1))));
                wnew.addNode(i + 1, n);
            }
            cmds.add((Command)new ChangeCommand((OsmPrimitive)insertPoint.getKey(), (OsmPrimitive)wnew));
            replacedWays.add((Way)insertPoint.getKey());
            reuseWays.add(wnew);
        }
        SplittingTool.adjustNode(segSet, n);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        double q;
        EastNorth pB;
        EastNorth pA;
        Pair<Node, Node> seg;
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> i = segs.iterator();
                seg = i.next();
                pA = ((Node)seg.a).getEastNorth();
                pB = ((Node)seg.b).getEastNorth();
                seg = i.next();
                EastNorth pC = ((Node)seg.a).getEastNorth();
                EastNorth pD = ((Node)seg.b).getEastNorth();
                double u = SplittingTool.det(pB.east() - pA.east(), pB.north() - pA.north(), pC.east() - pD.east(), pC.north() - pD.north());
                if (u == 0.0) {
                    return;
                }
                q = SplittingTool.det(pB.north() - pC.north(), pB.east() - pC.east(), pD.north() - pC.north(), pD.east() - pC.east()) / u;
                EastNorth intersection = new EastNorth(pB.east() + q * (pA.east() - pB.east()), pB.north() + q * (pA.north() - pB.north()));
                if (!(Main.map.mapView.getPoint2D(n).distance(Main.map.mapView.getPoint2D(intersection)) < (double)snapToIntersectionThreshold)) break;
                n.setEastNorth(intersection);
                return;
            }
        }
        EastNorth p = n.getEastNorth();
        seg = segs.iterator().next();
        pA = ((Node)seg.a).getEastNorth();
        pB = ((Node)seg.b).getEastNorth();
        double a = p.distanceSq(pB);
        double b = p.distanceSq(pA);
        double c = pA.distanceSq(pB);
        q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(pB.east() + q * (pA.east() - pB.east()), pB.north() + q * (pA.north() - pB.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    public void SplitRoad(Node node, DataSet ds, Collection<OsmPrimitive> newSelection) {
        LinkedList selectionToSplit = new LinkedList(ds.getSelected());
        newSelection.add((OsmPrimitive)node);
        Way way = null;
        for (Way w : Utils.filteredCollection((Collection)node.getReferrers(), Way.class)) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            way = w;
        }
        newSelection.add((OsmPrimitive)way);
        List selectedNodes = OsmPrimitive.getFilteredList(newSelection, Node.class);
        List selectedWays = OsmPrimitive.getFilteredList(newSelection, Way.class);
        List selectedRelations = OsmPrimitive.getFilteredList(newSelection, Relation.class);
        List<Way> applicableWays = this.getApplicableWays(selectedWays, selectedNodes);
        if (applicableWays == null) {
            new Notification(I18n.tr((String)"The current selection cannot be used for splitting - no node is selected.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.tr((String)"The selected nodes do not share the same way.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.size() > 1) {
            Iterator<Way> it = applicableWays.iterator();
            block3: while (it.hasNext()) {
                Way w = it.next();
                for (Node no : selectedNodes) {
                    if (w.isInnerNode(no)) continue;
                    it.remove();
                    continue block3;
                }
            }
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.tr((String)"The selected node is not in the middle of any way.", (Object[])new Object[]{"The selected nodes are not in the middle of any way.", selectedNodes.size()})).setIcon(2).show();
            return;
        }
        Way selectedWay = null;
        selectedWay = selectionToSplit != null && selectionToSplit.size() == 1 && applicableWays.contains(OsmPrimitive.getFilteredList(selectionToSplit, Way.class).get(0)) ? (Way)OsmPrimitive.getFilteredList(selectionToSplit, Way.class).get(0) : applicableWays.get(0);
        List wayChunks = SplitWayAction.buildSplitChunks((Way)selectedWay, (List)selectedNodes);
        if (wayChunks != null) {
            ArrayList sel = new ArrayList(selectedWays.size() + selectedRelations.size());
            sel.addAll(selectedWays);
            sel.addAll(selectedRelations);
            SplitWayAction.SplitWayResult result = SplitWayAction.splitWay((OsmDataLayer)Main.getLayerManager().getEditLayer(), (Way)selectedWay, (List)wayChunks, sel);
            Main.main.undoRedo.add(result.getCommand());
            Way way2 = (Way)result.getNewWays().get(0);
            try {
                if (selectedWay.firstNode().equals((Object)way2.firstNode())) {
                    SplittingTool.selectTheWay(selectedWay, way2, selectedWay.lastNode(), way2.lastNode(), selectedWay.firstNode());
                } else if (selectedWay.firstNode().equals((Object)way2.lastNode())) {
                    SplittingTool.selectTheWay(selectedWay, way2, selectedWay.lastNode(), way2.firstNode(), selectedWay.firstNode());
                } else if (selectedWay.lastNode().equals((Object)way2.firstNode())) {
                    SplittingTool.selectTheWay(selectedWay, way2, selectedWay.firstNode(), way2.lastNode(), selectedWay.lastNode());
                } else if (selectedWay.lastNode().equals((Object)way2.lastNode())) {
                    SplittingTool.selectTheWay(selectedWay, way2, selectedWay.firstNode(), way2.firstNode(), selectedWay.lastNode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<Way> getApplicableWays(List<Way> selectedWays, List<Node> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return null;
        }
        if (selectedNodes.size() == 1) {
            Node n = selectedNodes.get(0);
            List referedWays = OsmPrimitive.getFilteredList((Collection)n.getReferrers(), Way.class);
            Way inTheMiddle = null;
            boolean foundSelected = false;
            for (Way w : referedWays) {
                if (selectedWays.contains(w)) {
                    foundSelected = true;
                }
                if (w.getNode(0) == n || w.getNode(w.getNodesCount() - 1) == n) continue;
                if (inTheMiddle == null) {
                    inTheMiddle = w;
                    continue;
                }
                inTheMiddle = null;
                break;
            }
            if (foundSelected && inTheMiddle != null) {
                return Collections.singletonList(inTheMiddle);
            }
        }
        ArrayList<Way> result = new ArrayList<Way>(OsmPrimitive.getFilteredList((Collection)selectedNodes.get(0).getReferrers(), Way.class));
        for (int i = 1; i < selectedNodes.size(); ++i) {
            List ref = selectedNodes.get(i).getReferrers();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (ref.contains(it.next())) continue;
                it.remove();
            }
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (((Way)it.next()).getNodesCount() > 2) continue;
            it.remove();
        }
        if (selectedWays.isEmpty()) {
            return result;
        }
        it = result.iterator();
        while (it.hasNext()) {
            if (selectedWays.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    public static void selectTheWay(Way way, Way way2, Node n1, Node n2, Node common) {
        int ws1 = OsmPrimitive.getFilteredList((Collection)n1.getReferrers(), Way.class).size();
        int ws2 = OsmPrimitive.getFilteredList((Collection)n2.getReferrers(), Way.class).size();
        int wsc = OsmPrimitive.getFilteredList((Collection)common.getReferrers(), Way.class).size();
        try {
            if (ws1 > 2 && ws2 > 2 || ws1 <= 2 && ws2 <= 2) {
                if (way.getLength() > way2.getLength()) {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way2});
                } else {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way});
                }
            } else if (ws1 > 2 && ws2 <= 2) {
                if (wsc > 2) {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way2});
                } else {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way});
                }
            } else if (ws1 <= 2 && ws2 > 2) {
                if (wsc > 2) {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way});
                } else {
                    Main.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{way2});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

