/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.jrt.core;

import com.innovant.josm.jrt.core.RoutingGraphDelegator;
import com.innovant.josm.jrt.core.RoutingProfile;
import com.innovant.josm.jrt.osm.OsmEdge;
import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordShortestPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

public class RoutingGraph {
    private final RoutingProfile routingProfile;
    private RouteType routeType;
    private final DataSet data;
    static Logger logger = Logger.getLogger(RoutingGraph.class);
    private static Collection<String> excludedHighwayValues = Arrays.asList("bus_stop", "traffic_signals", "street_lamp", "stop", "construction", "platform", "give_way", "proposed", "milestone", "speed_camera", "abandoned");
    private Graph<Node, OsmEdge> graph = null;
    private RoutingGraphDelegator rgDelegator = null;
    private Map<String, Double> waySpeeds;

    public Graph<Node, OsmEdge> getGraph() {
        return this.graph;
    }

    private void addEdgeBidirectional(Way way, Node from, Node to) {
        this.addEdge(way, from, to);
        this.addEdge(way, to, from);
    }

    private void addEdgeReverseOneway(Way way, Node from, Node to) {
        this.addEdge(way, to, from);
    }

    private void addEdgeNormalOneway(Way way, Node from, Node to) {
        this.addEdge(way, from, to);
    }

    public RoutingGraph(DataSet data) {
        this.data = data;
        this.routeType = RouteType.SHORTEST;
        this.routingProfile = new RoutingProfile("default");
        this.routingProfile.setOnewayUse(true);
        this.setWaySpeeds(this.routingProfile.getWaySpeeds());
        logger.debug((Object)"Created RoutingGraph");
    }

    public void createGraph() {
        logger.debug((Object)"Creating Graph...");
        this.graph = new DirectedWeightedMultigraph<Node, OsmEdge>(OsmEdge.class);
        this.rgDelegator = new RoutingGraphDelegator(this.graph);
        this.rgDelegator.setRouteType(this.routeType);
        for (Way way : this.data.getWays()) {
            if (way == null || way.isDeleted() || !this.isvalidWay(way) || way.getNodes().size() < 1) continue;
            Node from = null;
            Node to = null;
            List nodes = way.getNodes();
            int nodes_count = nodes.size();
            String oneway_val = way.get("oneway");
            String junction_val = way.get("junction");
            from = (Node)nodes.get(0);
            this.graph.addVertex(from);
            for (int i = 1; i < nodes_count; ++i) {
                to = (Node)nodes.get(i);
                if (to == null || to.isDeleted()) continue;
                this.graph.addVertex(to);
                if (!this.routingProfile.isOnewayUsed()) {
                    this.addEdgeBidirectional(way, from, to);
                } else if (oneway_val == null && junction_val == "roundabout") {
                    this.addEdgeNormalOneway(way, from, to);
                } else if (oneway_val == null || oneway_val == "false" || oneway_val == "no" || oneway_val == "0") {
                    this.addEdgeBidirectional(way, from, to);
                } else if (oneway_val == "-1") {
                    this.addEdgeReverseOneway(way, from, to);
                } else if (oneway_val == "1" || oneway_val == "yes" || oneway_val == "true") {
                    this.addEdgeNormalOneway(way, from, to);
                }
                from = to;
            }
        }
        logger.debug((Object)"End Create Graph");
        logger.debug((Object)("Vertex: " + this.graph.vertexSet().size()));
        logger.debug((Object)("Edges: " + this.graph.edgeSet().size()));
    }

    private void addEdge(Way way, Node from, Node to) {
        LatLon fromLL = from.getCoor();
        LatLon toLL = from.getCoor();
        if (fromLL == null || toLL == null) {
            return;
        }
        OsmEdge edge = new OsmEdge(way, from, to);
        double length = edge.getLength();
        edge.setSpeed(12.1);
        this.graph.addEdge(from, to, edge);
        double weight = this.getWeight(way, length);
        this.setWeight(edge, length);
        logger.debug((Object)("edge for way " + way.getId() + "(from node " + from.getId() + " to node " + to.getId() + ") has weight: " + weight));
        ((DirectedWeightedMultigraph)this.graph).setEdgeWeight(edge, weight);
    }

    private void setWeight(OsmEdge osmedge, double length) {
        osmedge.setLength(length);
        if (this.waySpeeds.containsKey(osmedge.getWay().get("highway"))) {
            osmedge.setSpeed(this.waySpeeds.get(osmedge.getWay().get("highway")));
        }
    }

    private double getWeight(Way way, double length) {
        double speed = 1.0;
        switch (this.routeType) {
            case SHORTEST: {
                if (!this.waySpeeds.containsKey("residential")) break;
                speed = this.waySpeeds.get("residential");
                break;
            }
            case FASTEST: {
                if (this.waySpeeds.containsKey(way.get("highway"))) {
                    speed = this.waySpeeds.get(way.get("highway"));
                }
                logger.debug((Object)("Speed=" + speed));
                break;
            }
        }
        return length / speed;
    }

    public boolean isvalidWay(Way way) {
        String highway = way.get("highway");
        return highway != null && !excludedHighwayValues.contains(highway) || way.get("junction") != null || way.get("service") != null;
    }

    public List<OsmEdge> applyAlgorithm(List<Node> nodes, Algorithm algorithm) {
        List<OsmEdge> path = new ArrayList<OsmEdge>();
        double totalWeight = 0.0;
        RoutingLayer layer = (RoutingLayer)Main.getLayerManager().getActiveLayer();
        RoutingModel routingModel = layer.getRoutingModel();
        if (this.graph == null || routingModel.getOnewayChanged()) {
            this.createGraph();
        }
        logger.debug((Object)"apply algorithm between nodes ");
        for (Node node : nodes) {
            logger.debug((Object)node.getId());
        }
        logger.debug((Object)"-----------------------------------");
        Graph<Node, OsmEdge> g = this.graph;
        block0 : switch (algorithm) {
            case ROUTING_ALG_DIJKSTRA: {
                logger.debug((Object)"Using Dijkstra algorithm");
                DijkstraShortestPath<Node, OsmEdge> routingk = null;
                for (int index = 1; index < nodes.size(); ++index) {
                    routingk = new DijkstraShortestPath<Node, OsmEdge>(g, nodes.get(index - 1), nodes.get(index));
                    if (routingk.getPathEdgeList() == null) {
                        logger.debug((Object)"no path found!");
                        break block0;
                    }
                    path.addAll(routingk.getPathEdgeList());
                    totalWeight += routingk.getPathLength();
                }
                break;
            }
            case ROUTING_ALG_BELLMANFORD: {
                logger.debug((Object)"Using Bellman Ford algorithm");
                for (int index = 1; index < nodes.size(); ++index) {
                    path = BellmanFordShortestPath.findPathBetween(this.rgDelegator, nodes.get(index - 1), nodes.get(index));
                    if (path != null) continue;
                    logger.debug((Object)"no path found!");
                    return null;
                }
                break;
            }
            default: {
                logger.debug((Object)"Wrong algorithm");
            }
        }
        logger.debug((Object)("shortest path found: " + path + "\nweight: " + totalWeight));
        return path;
    }

    public int getVertexCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.vertexSet().size();
        }
        return value;
    }

    public int getEdgeCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.edgeSet().size();
        }
        return value;
    }

    public void setTypeRoute(RouteType routetype) {
        this.routeType = routetype;
        this.rgDelegator.setRouteType(routetype);
    }

    public RouteType getTypeRoute() {
        return this.routeType;
    }

    public Map<String, Double> getWaySpeeds() {
        return this.waySpeeds;
    }

    public void setWaySpeeds(Map<String, Double> waySpeeds) {
        this.waySpeeds = waySpeeds;
    }

    public void resetGraph() {
        this.graph = null;
    }

    public RoutingProfile getRoutingProfile() {
        return this.routingProfile;
    }

    public static enum RouteType {
        FASTEST,
        SHORTEST;

    }

    public static enum Algorithm {
        ROUTING_ALG_DIJKSTRA,
        ROUTING_ALG_BELLMANFORD;

    }
}

