/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.czechaddress.DatabaseLoadException;
import org.openstreetmap.josm.plugins.czechaddress.StringUtils;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;
import org.openstreetmap.josm.plugins.czechaddress.parser.XMLParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MvcrParser
extends XMLParser {
    Region curRegion = null;
    ViToCi curViToCi = null;
    Suburb curSuburb = null;
    Street curStreet = null;
    String filRegion = null;
    String filViToCi = null;
    String filSuburb = null;
    String filStreet = null;
    static final String URL_DEFAULT = "http://aplikace.mvcr.cz/adresy/Download.aspx";
    static final String URL_PREFERENCES_KEY = "czechaddress.databaseurl";
    static final String[] OLD_URLS = new String[]{"http://aplikace.mvcr.cz/adresa/adresy.zip"};

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("a")) {
            String cp = StringUtils.tryTrim(attributes.getValue("p"));
            String co = StringUtils.tryTrim(attributes.getValue("o"));
            if (cp == null && co == null) {
                return;
            }
            ElementWithHouses topElem = this.curStreet;
            if (topElem == null) {
                topElem = this.curSuburb;
            }
            if (topElem == null) {
                topElem = this.curViToCi;
            }
            if (topElem == null) {
                topElem = this.curRegion;
            }
            topElem.addHouse(new House(cp, co));
            return;
        }
        if (name.equals("ulice")) {
            String nazev = StringUtils.tryTrim(attributes.getValue("nazev"));
            if (this.filStreet != null && !nazev.equals(this.filStreet)) {
                this.curStreet = null;
                return;
            }
            ElementWithStreets topElem = this.curSuburb;
            if (topElem == null) {
                topElem = this.curViToCi;
            }
            if (topElem == null) {
                topElem = this.curRegion;
            }
            this.curStreet = new Street(StringUtils.capitalize(nazev));
            topElem.addStreet(this.curStreet);
            return;
        }
        if (name.equals("cast")) {
            if (this.curViToCi == null) {
                return;
            }
            String nazev = StringUtils.tryTrim(attributes.getValue("nazev"));
            if (this.filSuburb != null && !nazev.equals(this.filSuburb)) {
                this.curSuburb = null;
                this.curStreet = null;
                return;
            }
            this.curSuburb = new Suburb(StringUtils.capitalize(nazev));
            this.curViToCi.addSuburb(this.curSuburb);
            return;
        }
        if (name.equals("obec")) {
            String nazev = StringUtils.tryTrim(attributes.getValue("nazev"));
            if (this.filViToCi != null && !nazev.equals(this.filViToCi)) {
                this.curViToCi = null;
                this.curSuburb = null;
                this.curStreet = null;
                return;
            }
            this.curViToCi = new ViToCi(StringUtils.capitalize(nazev));
            this.curRegion.addViToCi(this.curViToCi);
            return;
        }
        if (name.equals("oblast")) {
            if (this.filRegion != null && !attributes.getValue("nazev").trim().equals(this.filRegion)) {
                this.curRegion = null;
                this.curViToCi = null;
                this.curSuburb = null;
                this.curStreet = null;
                return;
            }
            this.curRegion = new Region(StringUtils.capitalize(StringUtils.tryTrim(attributes.getValue("nazev"))), StringUtils.capitalize(StringUtils.tryTrim(attributes.getValue("kraj"))), StringUtils.capitalize(StringUtils.tryTrim(attributes.getValue("okres"))));
            this.target.regions.add(this.curRegion);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("cast")) {
            this.curSuburb = null;
        } else if (name.equals("obec")) {
            this.curSuburb = null;
            this.curViToCi = null;
        } else if (name.equals("oblast")) {
            this.curSuburb = null;
            this.curViToCi = null;
            this.curRegion = null;
        } else if (name.equals("ulice")) {
            this.curStreet = null;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public void setFilter(String filterRegion, String filterViToCi, String filterSuburb, String filterStreet) {
        if (filterRegion != null) {
            this.filRegion = filterRegion.toUpperCase();
        }
        if (filterViToCi != null) {
            this.filViToCi = filterViToCi.toUpperCase();
        }
        if (filterSuburb != null) {
            this.filSuburb = filterSuburb.toUpperCase();
        }
        if (filterStreet != null) {
            this.filStreet = filterStreet.toUpperCase();
        }
    }

    @Override
    protected String getDatabaseUrl() {
        for (String oldUrl : OLD_URLS) {
            if (!Main.pref.get(URL_PREFERENCES_KEY, URL_DEFAULT).equals(oldUrl)) continue;
            Main.pref.put(URL_PREFERENCES_KEY, URL_DEFAULT);
            break;
        }
        return Main.pref.get(URL_PREFERENCES_KEY, URL_DEFAULT);
    }

    @Override
    protected String getDatabasePath() {
        return this.storageDir + "-adresy.zip";
    }

    @Override
    protected InputStream getDatabaseStream() throws DatabaseLoadException {
        ZipInputStream zis;
        ZipEntry zipEntry = null;
        try {
            zis = new ZipInputStream(new FileInputStream(this.getDatabasePath()));
            while ((zipEntry = zis.getNextEntry()) != null && !zipEntry.getName().equals("adresy.xml")) {
            }
        }
        catch (IOException ioexp) {
            throw new DatabaseLoadException("Chyba p\u0159i \u010dten\u00ed archivu s datab\u00e1z\u00ed.", ioexp);
        }
        if (zipEntry == null) {
            throw new DatabaseLoadException("ZIP archiv s datab\u00e1z\u00ed neobsahuje soubor 'adresy.xml'.");
        }
        return zis;
    }
}

