/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;

public class ParentResolver
implements Comparable<ParentResolver> {
    public Street parentStreet = null;
    public Suburb parentSuburb = null;
    public ViToCi parentViToCi = null;
    public Region parentRegion = null;

    public ParentResolver(AddressElement queryElement) {
        if (queryElement.getParent() instanceof Street) {
            this.parentStreet = (Street)queryElement.getParent();
            queryElement = queryElement.getParent();
        }
        if (queryElement.getParent() instanceof Suburb) {
            this.parentSuburb = (Suburb)queryElement.getParent();
            queryElement = queryElement.getParent();
        }
        if (queryElement.getParent() instanceof ViToCi) {
            this.parentViToCi = (ViToCi)queryElement.getParent();
            queryElement = queryElement.getParent();
        }
        if (queryElement.getParent() instanceof Region) {
            this.parentRegion = (Region)queryElement.getParent();
            queryElement = queryElement.getParent();
        }
    }

    public String getIsIn() {
        String result = "";
        String last = "";
        if (this.parentSuburb != null && !last.equals(this.parentSuburb.getName())) {
            result = result + this.parentSuburb.getName() + ", ";
            last = this.parentSuburb.getName();
        }
        if (this.parentViToCi != null && !last.equals(this.parentViToCi.getName())) {
            result = result + this.parentViToCi.getName() + ", ";
            last = this.parentViToCi.getName();
        }
        if (this.parentRegion != null && this.parentRegion.getNuts3Name() != null && !last.equals(this.parentRegion.getNuts3Name())) {
            result = result + this.parentRegion.getNuts3Name() + " kraj, ";
            last = this.parentRegion.getNuts3Name();
        }
        return result + "CZ";
    }

    @Override
    public int compareTo(ParentResolver o) {
        int val = 0;
        if (this.parentRegion != null && o.parentRegion != null) {
            val = this.parentRegion.compareTo(o.parentRegion);
        }
        if (val != 0) {
            return val;
        }
        if (this.parentViToCi != null && o.parentViToCi != null) {
            val = this.parentViToCi.compareTo(o.parentViToCi);
        }
        if (val != 0) {
            return val;
        }
        if (this.parentSuburb != null && o.parentSuburb != null) {
            val = this.parentSuburb.compareTo(o.parentSuburb);
        }
        if (val != 0) {
            return val;
        }
        if (this.parentStreet != null && o.parentStreet != null) {
            val = this.parentStreet.compareTo(o.parentStreet);
        }
        return val;
    }
}

