/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;

public abstract class ElementWithStreets
extends ElementWithHouses {
    private ArrayList<Street> streets = new ArrayList();

    public ElementWithStreets(String name) {
        super(name);
    }

    public void addStreet(Street streetToAdd) {
        streetToAdd.setParent(this);
        this.streets.add(streetToAdd);
    }

    public void addStreets(Collection<Street> streetsToAdd) {
        this.streets.ensureCapacity(this.streets.size() + streetsToAdd.size());
        for (Street streetToAdd : streetsToAdd) {
            this.addStreet(streetToAdd);
        }
    }

    public void setStreets(ArrayList<Street> streets) {
        this.streets = streets;
        for (Street street : streets) {
            street.setParent(this);
        }
    }

    public List<Street> getStreets() {
        return this.streets;
    }

    public List<Street> getAllStreets() {
        return this.getStreets();
    }

    public Street findStreet(String streetName) {
        if (streetName == null) {
            return null;
        }
        streetName = streetName.toUpperCase();
        for (Street street : this.streets) {
            if (!street.getName().toUpperCase().equals(streetName)) continue;
            return street;
        }
        return null;
    }

    public List<House> getAllHouses() {
        ArrayList<House> result = new ArrayList<House>(20 * this.streets.size());
        result.addAll(this.houses);
        for (Street street : this.streets) {
            result.addAll(street.getHouses());
        }
        return result;
    }
}

