/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;

public class MapillaryTrafficSignDownloadThread
extends Thread {
    private final Bounds bounds;
    private final int page;
    private final ExecutorService ex;

    public MapillaryTrafficSignDownloadThread(ExecutorService ex, Bounds bounds, int page) {
        this.bounds = bounds;
        this.page = page;
        this.ex = ex;
    }

    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(MapillaryURL.searchImageInfoURL(this.bounds, this.page, MapillaryURL.IMAGE_SELECTOR.OBJ_REC_ONLY).openStream(), "UTF-8"));){
            JsonObject jsonobj = Json.createReader((Reader)br).readObject();
            if (!jsonobj.getBoolean("more")) {
                this.ex.shutdown();
            }
            JsonArray jsonarr = jsonobj.getJsonArray("ims");
            for (int i = 0; i < jsonarr.size(); ++i) {
                int j;
                JsonArray rects = jsonarr.getJsonObject(i).getJsonArray("rects");
                JsonArray rectversions = jsonarr.getJsonObject(i).getJsonArray("rectversions");
                String key = jsonarr.getJsonObject(i).getString("key");
                if (rectversions != null) {
                    for (j = 0; j < rectversions.size(); ++j) {
                        rects = rectversions.getJsonObject(j).getJsonArray("rects");
                        for (int k = 0; k < rects.size(); ++k) {
                            JsonObject data = rects.getJsonObject(k);
                            for (MapillaryAbstractImage image : MapillaryLayer.getInstance().getData().getImages()) {
                                if (!(image instanceof MapillaryImage) || !((MapillaryImage)image).getKey().equals(key)) continue;
                                ((MapillaryImage)image).addSign(data.getString("type"));
                            }
                        }
                    }
                    continue;
                }
                if (rects == null) continue;
                for (j = 0; j < rects.size(); ++j) {
                    JsonObject data = rects.getJsonObject(j);
                    for (MapillaryAbstractImage image : MapillaryLayer.getInstance().getData().getImages()) {
                        if (!(image instanceof MapillaryImage) || !((MapillaryImage)image).getKey().equals(key)) continue;
                        ((MapillaryImage)image).addSign(data.getString("type"));
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            Main.error((Throwable)e);
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }
}

