/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.infomode;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

class InfoPanel
extends JPanel {
    private Collection<GpxTrack> tracks;
    private GpxTrack trk;
    private DateFormat df;
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JLabel label3 = new JLabel();
    private JLabel label4 = new JLabel();
    private JLabel label5 = new JLabel();
    private JLabel label6 = new JLabel();
    private JButton but1 = new JButton(I18n.tr((String)"Delete this", (Object[])new Object[0]));
    private JButton but2 = new JButton(I18n.tr((String)"Delete this&older", (Object[])new Object[0]));

    InfoPanel() {
        super(new GridBagLayout());
        this.df = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.label1, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label2, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label3, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label4, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label5, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.label6, GBC.eol().insets(10, 0, 0, 0));
        this.add((Component)this.but1, GBC.std().insets(10, 5, 0, 0));
        this.add((Component)this.but2, GBC.eop().insets(10, 5, 0, 0));
        this.label6.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String s = InfoPanel.this.label6.getText();
                OpenBrowser.displayUrl((String)s.substring(9, s.length() - 11));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.but1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.tracks != null) {
                    InfoPanel.this.tracks.remove(InfoPanel.this.trk);
                }
                Main.map.mapView.repaint();
            }
        });
        this.but2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.tracks == null) {
                    return;
                }
                HashSet<GpxTrack> toRemove = new HashSet<GpxTrack>();
                double tm = -1.0;
                for (GpxTrackSegment seg : InfoPanel.this.trk.getSegments()) {
                    for (WayPoint S : seg.getWayPoints()) {
                        if (!(S.time > tm)) continue;
                        tm = S.time;
                    }
                }
                for (GpxTrack track : InfoPanel.this.tracks) {
                    boolean f = true;
                    block3: for (GpxTrackSegment seg : track.getSegments()) {
                        for (WayPoint S : seg.getWayPoints()) {
                            if (!(S.time > tm)) continue;
                            f = false;
                            break block3;
                        }
                    }
                    if (!f) continue;
                    toRemove.add(track);
                }
                InfoPanel.this.tracks.removeAll(toRemove);
                Main.map.mapView.repaint();
            }
        });
    }

    void setData(WayPoint wp, GpxTrack trk, double vel, Collection<GpxTrack> tracks) {
        this.tracks = tracks;
        this.trk = trk;
        if (wp.time == 0.0) {
            this.label1.setText(I18n.tr((String)"No timestamp", (Object[])new Object[0]));
            this.but2.setVisible(false);
        } else {
            this.label1.setText(this.df.format(wp.getTime()));
            this.but2.setVisible(true);
        }
        if (vel > 0.0) {
            this.label2.setText(String.format("%.1f " + I18n.tr((String)"km/h", (Object[])new Object[0]), vel));
        } else {
            this.label2.setText(null);
        }
        String s = (String)trk.getAttributes().get("name");
        if (s != null) {
            this.label3.setText(I18n.tr((String)"Track name: ", (Object[])new Object[0]) + s);
        } else {
            this.label3.setText(null);
        }
        s = (String)trk.getAttributes().get("desc");
        this.label4.setText(s);
        s = (String)wp.attr.get("ele");
        String s1 = "";
        try {
            s1 = String.format("H=%3.1f   ", Double.parseDouble(s));
        }
        catch (Exception e) {
            Main.warn((Throwable)e);
        }
        s1 = s1 + "L=" + (int)trk.length();
        this.label5.setText(s1);
        if (trk.getAttributes().containsKey("url")) {
            this.label6.setText(String.format("<html><u>%s</u></html>", trk.getAttributes().get("url").toString()));
        } else {
            this.label6.setText(null);
        }
    }
}

