/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Utils;
import org.mapdb.Volume;

public class StoreDirect
implements Engine {
    protected static final long MASK_OFFSET = 0xFFFFFFFFFFFFL;
    protected static final long MASK_SIZE = 0x7FFF000000000000L;
    protected static final long MASK_IS_LINKED = Long.MIN_VALUE;
    protected static final long HEADER = 9032094932889042394L;
    protected static final int MAX_REC_SIZE = Short.MAX_VALUE;
    protected static final int PHYS_FREE_SLOTS_COUNT = 2048;
    protected static final int IO_INDEX_SIZE = 8;
    protected static final int IO_PHYS_SIZE = 16;
    protected static final int IO_FREE_RECID = 120;
    protected static final int IO_USER_START = 16512;
    public static final String DATA_FILE_EXT = ".p";
    static final int LONG_STACK_PER_PAGE = 204;
    static final int LONG_STACK_PAGE_SIZE = 1232;
    protected final ReentrantReadWriteLock[] locks = Utils.newReadWriteLocks(32);
    protected final ReentrantLock structuralLock = new ReentrantLock();
    protected Volume index;
    protected Volume phys;
    protected long physSize;
    protected long indexSize;
    protected final boolean deleteFilesAfterClose;
    protected final boolean readOnly;

    public StoreDirect(Volume.Factory volFac, boolean readOnly, boolean deleteFilesAfterClose) {
        this.readOnly = readOnly;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.index = volFac.createIndexVolume();
        this.phys = volFac.createPhysVolume();
        if (this.index.isEmpty()) {
            this.createStructure();
        } else {
            this.checkHeaders();
            this.indexSize = this.index.getLong(8L);
            this.physSize = this.index.getLong(16L);
        }
    }

    public StoreDirect(Volume.Factory volFac) {
        this(volFac, false, false);
    }

    protected void checkHeaders() {
        if (this.index.getLong(0L) != 9032094932889042394L || this.phys.getLong(0L) != 9032094932889042394L) {
            throw new IOError(new IOException("storage has invalid header"));
        }
    }

    protected void createStructure() {
        this.indexSize = 16576L;
        this.index.ensureAvailable(this.indexSize);
        int i = 0;
        while ((long)i < this.indexSize) {
            this.index.putLong(i, 0L);
            i += 8;
        }
        this.index.putLong(0L, 9032094932889042394L);
        this.index.putLong(8L, this.indexSize);
        this.physSize = 16L;
        this.phys.ensureAvailable(this.physSize);
        this.phys.putLong(0L, 9032094932889042394L);
        this.index.putLong(16L, this.physSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long[] indexVals;
        long ioRecid;
        DataOutput2 out = this.serialize(value, serializer);
        this.structuralLock.lock();
        try {
            ioRecid = this.freeIoRecidTake(true);
            indexVals = this.physAllocate(out.pos, true);
        }
        finally {
            this.structuralLock.unlock();
        }
        this.put2(out, ioRecid, indexVals);
        return (ioRecid - 16512L) / 8L;
    }

    private void put2(DataOutput2 out, long ioRecid, long[] indexVals) {
        this.index.putLong(ioRecid, indexVals[0]);
        if (indexVals.length == 1 || indexVals[1] == 0L) {
            this.phys.putData(indexVals[0] & 0xFFFFFFFFFFFFL, out.buf, 0, out.pos);
        } else {
            int outPos = 0;
            for (int i = 0; i < indexVals.length; ++i) {
                int c = StoreDirect.ccc(indexVals.length, i);
                long indexVal = indexVals[i];
                boolean isLast = (indexVal & Long.MIN_VALUE) == 0L;
                if (isLast != (i == indexVals.length - 1)) {
                    throw new InternalError();
                }
                int size = (int)((indexVal & 0x7FFF000000000000L) >> 48);
                long offset = indexVal & 0xFFFFFFFFFFFFL;
                this.phys.putData(offset + (long)c, out.buf, outPos, size - c);
                outPos += size - c;
                if (c > 0) {
                    this.phys.putLong(offset, indexVals[i + 1]);
                }
                if (c != 12) continue;
                this.phys.putInt(offset + 8L, out.pos);
            }
            if (outPos != out.pos) {
                throw new InternalError();
            }
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.readLock(this.locks, recid);
        try {
            A a = this.get2(ioRecid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            Utils.readUnlock(this.locks, recid);
        }
    }

    protected <A> A get2(long ioRecid, Serializer<A> serializer) throws IOException {
        DataInput2 di;
        long indexVal = this.index.getLong(ioRecid);
        int size = (int)((indexVal & 0x7FFF000000000000L) >>> 48);
        long offset = indexVal & 0xFFFFFFFFFFFFL;
        if ((indexVal & Long.MIN_VALUE) == 0L) {
            di = this.phys.getDataInput(offset, size);
        } else {
            int totalSize = this.phys.getInt(offset + 8L);
            int pos = 0;
            int c = 12;
            byte[] buf = new byte[totalSize];
            while (true) {
                DataInput2 in = this.phys.getDataInput(offset + (long)c, size - c);
                in.readFully(buf, pos, size - c);
                pos += size - c;
                if (c == 0) break;
                long next = this.phys.getLong(offset);
                offset = next & 0xFFFFFFFFFFFFL;
                size = (int)((next & 0x7FFF000000000000L) >>> 48);
                c = (next & Long.MIN_VALUE) == 0L ? 0 : 8;
            }
            if (pos != totalSize) {
                throw new InternalError();
            }
            di = new DataInput2(buf);
            size = totalSize;
        }
        int start = di.pos;
        A ret = serializer.deserialize(di, size);
        if (size + start > di.pos) {
            throw new InternalError("data were not fully read, check your serializier");
        }
        if (size + start < di.pos) {
            throw new InternalError("data were read beyond record size, check your serializier");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        DataOutput2 out = this.serialize(value, serializer);
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long[] indexVals;
            this.structuralLock.lock();
            try {
                indexVals = this.physAllocate(out.pos, true);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.put2(out, ioRecid, indexVals);
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long[] indexVals;
            A oldVal = this.get2(ioRecid, serializer);
            if (oldVal == null && expectedOldValue != null || oldVal != null && !oldVal.equals(expectedOldValue)) {
                boolean bl = false;
                return bl;
            }
            DataOutput2 out = this.serialize(newValue, serializer);
            this.structuralLock.lock();
            try {
                indexVals = this.physAllocate(out.pos, true);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.put2(out, ioRecid, indexVals);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        long ioRecid = 16512L + recid * 8L;
        Utils.writeLock(this.locks, recid);
        try {
            long indexVal = this.index.getLong(ioRecid);
            this.index.putLong(ioRecid, 0L);
            long[] linkedRecords = null;
            int linkedPos = 0;
            if ((indexVal & Long.MIN_VALUE) != 0L) {
                linkedRecords = new long[2];
                long linkedVal = this.phys.getLong(indexVal & 0xFFFFFFFFFFFFL);
                while (true) {
                    if (linkedPos == linkedRecords.length) {
                        linkedRecords = Arrays.copyOf(linkedRecords, linkedRecords.length * 2);
                    }
                    linkedRecords[linkedPos] = linkedVal;
                    if ((linkedVal & Long.MIN_VALUE) == 0L) break;
                    ++linkedPos;
                    linkedVal = this.phys.getLong(linkedVal & 0xFFFFFFFFFFFFL);
                }
            }
            this.structuralLock.lock();
            try {
                this.freeIoRecidPut(ioRecid);
                this.freePhysPut(indexVal);
                if (linkedRecords != null) {
                    for (int i = 0; i < linkedPos; ++i) {
                        this.freePhysPut(linkedRecords[i]);
                    }
                }
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            Utils.writeUnlock(this.locks, recid);
        }
    }

    protected long[] physAllocate(int size, boolean ensureAvail) {
        if ((long)size == 0L) {
            return new long[]{0L};
        }
        if (size < Short.MAX_VALUE) {
            long indexVal = this.freePhysTake(size, ensureAvail);
            return new long[]{indexVal |= (long)size << 48};
        }
        long[] ret = new long[2];
        int retPos = 0;
        int c = 12;
        while (size > 0) {
            if (retPos == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            int allocSize = Math.min(size, Short.MAX_VALUE);
            size -= allocSize - c;
            long indexVal = this.freePhysTake(allocSize, ensureAvail);
            indexVal |= (long)allocSize << 48;
            if (c != 0) {
                indexVal |= Long.MIN_VALUE;
            }
            ret[retPos++] = indexVal;
            c = size <= Short.MAX_VALUE ? 0 : 8;
        }
        if (size != 0) {
            throw new InternalError();
        }
        return Arrays.copyOf(ret, retPos);
    }

    protected static long roundTo16(long offset) {
        long rem = offset % 16L;
        if (rem != 0L) {
            offset += 16L - rem;
        }
        return offset;
    }

    protected static int ccc(int size, int i) {
        return size == 1 || i == size - 1 ? 0 : (i == 0 ? 12 : 8);
    }

    @Override
    public void close() {
        this.structuralLock.lock();
        Utils.writeLockAll(this.locks);
        if (!this.readOnly) {
            this.index.putLong(16L, this.physSize);
            this.index.putLong(8L, this.indexSize);
        }
        this.index.sync();
        this.phys.sync();
        this.index.close();
        this.phys.close();
        if (this.deleteFilesAfterClose) {
            this.index.deleteFile();
            this.phys.deleteFile();
        }
        this.index = null;
        this.phys = null;
        Utils.writeUnlockAll(this.locks);
        this.structuralLock.unlock();
    }

    @Override
    public boolean isClosed() {
        return this.index == null;
    }

    @Override
    public void commit() {
        if (!this.readOnly) {
            this.index.putLong(16L, this.physSize);
            this.index.putLong(8L, this.indexSize);
        }
        this.index.sync();
        this.phys.sync();
    }

    @Override
    public void rollback() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("rollback not supported with journal disabled");
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void compact() {
        if (this.readOnly) {
            throw new IllegalAccessError();
        }
        this.index.putLong(16L, this.physSize);
        this.index.putLong(8L, this.indexSize);
        if (this.index.getFile() == null) {
            throw new UnsupportedOperationException("compact not supported for memory storage yet");
        }
        this.structuralLock.lock();
        for (ReentrantReadWriteLock l : this.locks) {
            l.writeLock().lock();
        }
        try {
            File indexFile = this.index.getFile();
            File physFile = this.phys.getFile();
            boolean isRaf = this.index instanceof Volume.RandomAccessFileVol;
            Volume.Factory fab = Volume.fileFactory(false, isRaf, new File(indexFile + ".compact"));
            StoreDirect store2 = new StoreDirect(fab);
            store2.structuralLock.lock();
            long recid = this.longStackTake(120L);
            while (recid != 0L) {
                store2.longStackPut(recid, 120L);
                recid = this.longStackTake(120L);
            }
            store2.index.putLong(8L, this.indexSize);
            for (long ioRecid = 16512L; ioRecid < this.indexSize; ioRecid += 8L) {
                byte[] bb = this.get2(ioRecid, Serializer.BYTE_ARRAY_SERIALIZER);
                long[] indexVals = store2.physAllocate(bb.length, true);
                DataOutput2 out = new DataOutput2();
                out.buf = bb;
                out.pos = bb.length;
                store2.index.ensureAvailable(ioRecid + 8L);
                store2.put2(out, ioRecid, indexVals);
            }
            File indexFile2 = store2.index.getFile();
            File physFile2 = store2.phys.getFile();
            store2.structuralLock.unlock();
            store2.close();
            long time = System.currentTimeMillis();
            File indexFile_ = new File(indexFile.getPath() + "_" + time + "_orig");
            File physFile_ = new File(physFile.getPath() + "_" + time + "_orig");
            this.index.close();
            this.phys.close();
            if (!indexFile.renameTo(indexFile_)) {
                throw new InternalError("could not rename file");
            }
            if (!physFile.renameTo(physFile_)) {
                throw new InternalError("could not rename file");
            }
            if (!indexFile2.renameTo(indexFile)) {
                throw new InternalError("could not rename file");
            }
            if (!physFile2.renameTo(physFile)) {
                throw new InternalError("could not rename file");
            }
            indexFile_.delete();
            physFile_.delete();
            Volume.Factory fac2 = Volume.fileFactory(false, isRaf, indexFile);
            this.index = fac2.createIndexVolume();
            this.phys = fac2.createPhysVolume();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.structuralLock.unlock();
            for (ReentrantReadWriteLock l : this.locks) {
                l.writeLock().unlock();
            }
        }
    }

    protected long longStackTake(long ioList) {
        if (!this.structuralLock.isLocked()) {
            throw new InternalError();
        }
        if (ioList < 120L || ioList >= 16512L) {
            throw new IllegalArgumentException("wrong ioList: " + ioList);
        }
        long dataOffset = this.index.getLong(ioList) & 0xFFFFFFFFFFFFL;
        if (dataOffset == 0L) {
            return 0L;
        }
        int numberOfRecordsInPage = this.phys.getUnsignedByte(dataOffset);
        if (numberOfRecordsInPage <= 0) {
            throw new InternalError();
        }
        if (numberOfRecordsInPage > 204) {
            throw new InternalError();
        }
        long ret = this.phys.getSixLong(dataOffset + 2L + (long)(numberOfRecordsInPage * 6));
        if (numberOfRecordsInPage == 1) {
            long previousListPhysid = this.phys.getSixLong(dataOffset + 2L);
            if (previousListPhysid != 0L) {
                this.index.putLong(ioList, previousListPhysid | 0x4D0000000000000L);
            } else {
                this.index.putLong(ioList, 0L);
            }
            this.freePhysPut(dataOffset | 0x4D0000000000000L);
        } else {
            this.phys.putUnsignedByte(dataOffset, (byte)(numberOfRecordsInPage - 1));
        }
        return ret;
    }

    protected void longStackPut(long ioList, long offset) {
        offset &= 0xFFFFFFFFFFFFL;
        if (!this.structuralLock.isLocked()) {
            throw new InternalError();
        }
        if (ioList < 120L || ioList >= 16512L) {
            throw new InternalError("wrong ioList: " + ioList);
        }
        long listPhysid2 = this.index.getLong(ioList) & 0xFFFFFFFFFFFFL;
        if (listPhysid2 == 0L) {
            long listPhysid = this.freePhysTake(1232, true) & 0xFFFFFFFFFFFFL;
            if (listPhysid == 0L) {
                throw new InternalError();
            }
            this.phys.putSixLong(listPhysid + 2L, 0L);
            this.phys.putUnsignedByte(listPhysid, 1);
            this.phys.putSixLong(listPhysid + 8L, offset);
            this.index.putLong(ioList, 0x4D0000000000000L | listPhysid);
        } else {
            int numberOfRecordsInPage = this.phys.getUnsignedByte(listPhysid2);
            if (numberOfRecordsInPage == 204) {
                long listPhysid = this.freePhysTake(1232, true) & 0xFFFFFFFFFFFFL;
                if (listPhysid == 0L) {
                    throw new InternalError();
                }
                this.phys.putSixLong(listPhysid + 2L, listPhysid2);
                this.phys.putUnsignedByte(listPhysid, 1);
                this.phys.putSixLong(listPhysid + 8L, offset);
                this.index.putLong(ioList, 0x4D0000000000000L | listPhysid);
            } else {
                this.phys.putSixLong(listPhysid2 + 8L + (long)(6 * numberOfRecordsInPage), offset);
                this.phys.putUnsignedByte(listPhysid2, (byte)(numberOfRecordsInPage + 1));
            }
        }
    }

    protected void freeIoRecidPut(long ioRecid) {
        this.longStackPut(120L, ioRecid);
    }

    protected long freeIoRecidTake(boolean ensureAvail) {
        long ioRecid = this.longStackTake(120L);
        if (ioRecid != 0L) {
            return ioRecid;
        }
        this.indexSize += 8L;
        if (ensureAvail) {
            this.index.ensureAvailable(this.indexSize);
        }
        return this.indexSize - 8L;
    }

    protected static final long size2ListIoRecid(long size) {
        return 128L + (size - 1L) / 16L * 8L;
    }

    protected void freePhysPut(long indexVal) {
        long size = (indexVal & 0x7FFF000000000000L) >>> 48;
        this.longStackPut(StoreDirect.size2ListIoRecid(size), indexVal & 0xFFFFFFFFFFFFL);
    }

    protected long freePhysTake(int size, boolean ensureAvail) {
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        long ret = this.longStackTake(StoreDirect.size2ListIoRecid(size));
        if (ret != 0L) {
            return ret;
        }
        if (this.physSize % 0x40000000L + (long)size > 0x40000000L) {
            this.physSize += 0x40000000L - this.physSize % 0x40000000L;
        }
        long physSize2 = this.physSize;
        this.physSize = StoreDirect.roundTo16(this.physSize + (long)size);
        if (ensureAvail) {
            this.phys.ensureAvailable(this.physSize);
        }
        return physSize2;
    }

    protected <A> DataOutput2 serialize(A value, Serializer<A> serializer) {
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            return out;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

