/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikipediaApp;

public class WikidataTagCellRenderer
extends DefaultTableCellRenderer {
    final Map<String, CompletableFuture<String>> labelCache = new ConcurrentHashMap<String, CompletableFuture<String>>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        List<String> ids;
        if (column != 1 || !(value instanceof Map) || ((Map)value).size() != 1) {
            return null;
        }
        String key = table.getValueAt(row, 0).toString();
        if (!("wikidata".equals(key) || key != null && key.endsWith(":wikidata"))) {
            return null;
        }
        String id = ((Map)value).keySet().iterator().next().toString();
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (WikipediaApp.WIKIDATA_PATTERN.matcher(id).matches()) {
            return this.renderValues(Collections.singleton(id), table, component);
        }
        if (id.contains(";") && (ids = Arrays.asList(id.split("\\s*;\\s*"))).stream().allMatch(i -> WikipediaApp.WIKIDATA_PATTERN.matcher((CharSequence)i).matches())) {
            return this.renderValues(ids, table, component);
        }
        return null;
    }

    protected JLabel renderValues(Collection<String> ids, JTable table, JLabel component) {
        ids.forEach(id -> this.labelCache.computeIfAbsent((String)id, x -> CompletableFuture.supplyAsync(() -> WikipediaApp.getLabelForWikidata(x, Locale.getDefault(), new String[0]))));
        ArrayList<String> texts = new ArrayList<String>(ids.size());
        for (String id2 : ids) {
            String label;
            if (!this.labelCache.get(id2).isDone()) {
                this.labelCache.get(id2).thenRun(() -> GuiHelper.runInEDT(table::repaint));
                return null;
            }
            try {
                label = this.labelCache.get(id2).get();
            }
            catch (InterruptedException | ExecutionException e) {
                Main.warn((String)("Could not fetch Wikidata label for " + id2));
                Main.warn((Throwable)e);
                return null;
            }
            if (label == null) {
                return null;
            }
            texts.add(WikipediaApp.WikidataEntry.getLabelText(id2, label));
        }
        component.setText("<html>" + texts.stream().collect(Collectors.joining("; ")));
        component.setToolTipText("<html>" + Utils.joinAsHtmlUnorderedList(texts));
        return component;
    }
}

