/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.videomapping.video.GPSVideoPlayer;
import org.openstreetmap.josm.tools.I18n;

public class VideoPositionLayer
extends Layer {
    private List<WayPoint> gpsTrack;
    private ImageIcon layerIcon = new ImageIcon("images/videomapping.png");
    private DateFormat gpsTimeFormat;
    private WayPoint iconPosition;
    private final int GPS_INTERVALL = 1000;
    private GPSVideoPlayer gpsVideoPlayer;
    private boolean autoCenter;

    public VideoPositionLayer(GpxLayer gpsLayer) {
        super("videolayer");
        this.gpsTrack = this.importGPSLayer(gpsLayer.data);
        this.gpsTimeFormat = new SimpleDateFormat("HH:mm:ss");
        this.iconPosition = this.gpsTrack.get(0);
        Main.getLayerManager().addLayer((Layer)this);
    }

    private List<WayPoint> importGPSLayer(GpxData gps) {
        LinkedList<WayPoint> ls = new LinkedList<WayPoint>();
        for (GpxTrack trk : gps.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                ls.addAll(segment.getWayPoints());
            }
        }
        Collections.sort(ls);
        return ls;
    }

    public void paint(Graphics2D g, MapView map, Bounds bound) {
        this.paintGpsTrack(g, map);
        this.paintSyncedTrack(g, map);
        this.paintPositionIcon(g, map);
    }

    private void paintGpsTrack(Graphics2D g, MapView map) {
        g.setColor(Color.YELLOW);
        for (WayPoint n : this.gpsTrack) {
            Point p = map.getPoint(n.getEastNorth());
            g.drawOval(p.x - 2, p.y - 2, 4, 4);
        }
    }

    private void paintSyncedTrack(Graphics2D g, MapView map) {
        g.setColor(Color.GREEN);
        for (WayPoint n : this.gpsTrack) {
            if (!n.attr.containsKey("synced")) continue;
            Point p = map.getPoint(n.getEastNorth());
            g.drawOval(p.x - 2, p.y - 2, 4, 4);
        }
    }

    private void paintPositionIcon(Graphics2D g, MapView map) {
        if (this.iconPosition != null) {
            Point p = map.getPoint(this.iconPosition.getEastNorth());
            this.layerIcon.paintIcon(null, g, p.x - this.layerIcon.getIconWidth() / 2, p.y - this.layerIcon.getIconHeight() / 2);
            g.drawString(this.gpsTimeFormat.format(this.iconPosition.getTime()), p.x - 15, p.y - 15);
        }
    }

    public WayPoint interpolate(Date GPSTime) {
        WayPoint before = this.getWayPointBefore(GPSTime);
        if (before == null) {
            return null;
        }
        long diff = GPSTime.getTime() - before.getTime().getTime();
        assert (diff >= 0L);
        assert (diff < 1000L);
        float perc = (float)diff / 1000.0f * 100.0f;
        return this.interpolate(before, perc);
    }

    public WayPoint getWayPointBefore(Date GPSTime) {
        assert (GPSTime.after(this.getFirstWayPoint().getTime()));
        assert (GPSTime.before(this.getLastWayPoint().getTime()));
        Date first = this.getFirstWayPoint().getTime();
        long diff = GPSTime.getTime() - first.getTime();
        int id = (int)(diff / 1000L);
        return 0 <= id && id < this.gpsTrack.size() ? this.gpsTrack.get(id) : null;
    }

    public WayPoint getFirstWayPoint() {
        return this.gpsTrack.isEmpty() ? null : this.gpsTrack.get(0);
    }

    public WayPoint getLastWayPoint() {
        return this.gpsTrack.isEmpty() ? null : this.gpsTrack.get(this.gpsTrack.size() - 1);
    }

    private WayPoint interpolate(WayPoint first, float percent) {
        assert (percent > 0.0f);
        assert (percent < 100.0f);
        WayPoint next = this.gpsTrack.get(this.gpsTrack.indexOf(first) + 1);
        WayPoint leftP = this.getLeftPoint(first, next);
        WayPoint rightP = this.getRightPoint(first, next);
        double dX = (rightP.getCoor().lon() - leftP.getCoor().lon()) * (double)(percent /= 100.0f);
        double dY = (rightP.getCoor().lat() - leftP.getCoor().lat()) * (double)percent;
        if (first == leftP) {
            return new WayPoint(new LatLon(leftP.getCoor().lat() + dY, leftP.getCoor().lon() + dX));
        }
        return new WayPoint(new LatLon(rightP.getCoor().lat() - dY, rightP.getCoor().lon() - dX));
    }

    private WayPoint getLeftPoint(WayPoint p1, WayPoint p2) {
        if (p1.getCoor().lon() < p2.getCoor().lon()) {
            return p1;
        }
        return p2;
    }

    private WayPoint getRightPoint(WayPoint p1, WayPoint p2) {
        if (p1.getCoor().lon() > p2.getCoor().lon()) {
            return p1;
        }
        return p2;
    }

    public Date getGPSDate() {
        return this.iconPosition.getTime();
    }

    public WayPoint getCurrentWayPoint() {
        return this.iconPosition;
    }

    public List<WayPoint> getTrack() {
        return this.gpsTrack;
    }

    public void jump(Date GPSTime) {
        this.setIconPosition(this.getWayPointBefore(GPSTime));
    }

    public void setIconPosition(WayPoint wp) {
        this.iconPosition = wp;
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.repaint();
            if (this.autoCenter) {
                Main.map.mapView.zoomTo(this.iconPosition.getCoor());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        WayPoint wp;
        if (e.getButton() == 1 && (wp = this.getNearestWayPoint(e.getPoint())) != null) {
            if (this.gpsVideoPlayer.areAllVideosSynced()) {
                this.gpsVideoPlayer.jumpTo(wp.getTime());
            }
            this.setIconPosition(wp);
        }
    }

    private WayPoint getNearestWayPoint(Point mouse) {
        int MAX = 10;
        Rectangle rect = new Rectangle(mouse.x - 5, mouse.y - 5, 10, 10);
        for (WayPoint n : this.gpsTrack) {
            Point p = Main.map.mapView.getPoint(n.getEastNorth());
            if (!rect.contains(p)) continue;
            return n;
        }
        return null;
    }

    public Icon getIcon() {
        return this.layerIcon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction((Layer)this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Shows current position in the video", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public void setGPSVideoPlayer(GPSVideoPlayer player) {
        this.gpsVideoPlayer = player;
    }

    public void setAutoCenter(boolean enabled) {
        this.autoCenter = enabled;
    }

    public void unload() {
        Main.getLayerManager().removeLayer((Layer)this);
    }
}

