/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AngleSnap;
import buildings_tools.BuildingsToolsPlugin;
import buildings_tools.ToolSettings;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.I18n;

class Building {
    private final EastNorth[] en = new EastNorth[4];
    double meter = 0.0;
    private double len = 0.0;
    private double width;
    private double heading;
    private AngleSnap angleSnap = new AngleSnap();
    private Double drawingAngle;

    Building() {
    }

    public void clearAngleSnap() {
        this.angleSnap.clear();
        this.drawingAngle = null;
    }

    public void addAngleSnap(Node[] nodes) {
        this.drawingAngle = this.angleSnap.addSnap(nodes);
    }

    public void addAngleSnap(Way way) {
        this.angleSnap.addSnap(way);
        if (this.drawingAngle == null) {
            this.drawingAngle = this.angleSnap.getAngle();
        }
    }

    public double getLength() {
        return this.len;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isRectDrawing() {
        return this.drawingAngle != null && ToolSettings.getWidth() == 0.0 && ToolSettings.getLenStep() == 0.0;
    }

    public Double getDrawingAngle() {
        return this.drawingAngle;
    }

    public void reset() {
        this.len = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.en[i] = null;
        }
    }

    public EastNorth getPoint(int num) {
        return this.en[num];
    }

    private void updMetrics() {
        this.meter = 1.0 / Math.cos(Math.toRadians(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]).lat()));
        this.len = 0.0;
    }

    public void setBase(EastNorth base) {
        this.en[0] = base;
        this.updMetrics();
    }

    public void setBase(Node base) {
        this.en[0] = BuildingsToolsPlugin.latlon2eastNorth(base.getCoor());
        this.updMetrics();
    }

    private double projection1(EastNorth p) {
        EastNorth vec = p.subtract(this.en[0]);
        return (Math.sin(this.heading) * vec.east() + Math.cos(this.heading) * vec.north()) / this.meter;
    }

    private double projection2(EastNorth p) {
        EastNorth vec = p.subtract(this.en[0]);
        return (Math.cos(this.heading) * vec.east() - Math.sin(this.heading) * vec.north()) / this.meter;
    }

    private void updatePos() {
        if (this.len == 0.0) {
            return;
        }
        EastNorth p1 = this.en[0];
        this.en[1] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter);
        this.en[2] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter + Math.cos(this.heading) * this.width * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter - Math.sin(this.heading) * this.width * this.meter);
        this.en[3] = new EastNorth(p1.east() + Math.cos(this.heading) * this.width * this.meter, p1.north() - Math.sin(this.heading) * this.width * this.meter);
    }

    public void setLengthWidth(double length, double width) {
        this.len = length;
        this.width = width;
        this.updatePos();
    }

    public void setWidth(EastNorth p3) {
        this.width = this.projection2(p3);
        this.updatePos();
    }

    public void setPlace(EastNorth p2, double width, double lenstep, boolean ignoreConstraints) {
        if (this.en[0] == null) {
            throw new IllegalStateException("setPlace() called without the base point");
        }
        this.heading = this.en[0].heading(p2);
        if (!ignoreConstraints) {
            this.heading = this.angleSnap.snapAngle(this.heading);
        }
        this.width = width;
        this.len = this.projection1(p2);
        if (lenstep > 0.0 && !ignoreConstraints) {
            this.len = (double)Math.round(this.len / lenstep) * lenstep;
        }
        this.updatePos();
        Main.map.statusLine.setHeading(Math.toDegrees(this.heading));
        if (this.drawingAngle != null && !ignoreConstraints) {
            double ang = Math.toDegrees(this.heading - this.drawingAngle);
            if (ang < 0.0) {
                ang += 360.0;
            }
            if (ang > 360.0) {
                ang -= 360.0;
            }
            Main.map.statusLine.setAngle(ang);
        }
    }

    public void setPlaceRect(EastNorth p2) {
        if (this.en[0] == null) {
            throw new IllegalStateException("SetPlaceRect() called without the base point");
        }
        if (!this.isRectDrawing()) {
            throw new IllegalStateException("Invalid drawing mode");
        }
        this.heading = this.drawingAngle;
        this.setLengthWidth(this.projection1(p2), this.projection2(p2));
        Main.map.statusLine.setHeading(Math.toDegrees(this.heading));
    }

    public void angFix(EastNorth point) {
        EastNorth en3 = this.en[2];
        EastNorth mid = this.en[0].getCenter(en3);
        double radius = en3.distance(mid);
        this.heading = mid.heading(point);
        this.heading = this.en[0].heading(mid.add(Math.sin(this.heading) * radius, Math.cos(this.heading) * radius));
        this.setLengthWidth(this.projection1(en3), this.projection2(en3));
        this.en[2] = en3;
    }

    public void paint(Graphics2D g, MapView mv) {
        if (this.len == 0.0) {
            return;
        }
        GeneralPath b = new GeneralPath();
        Point pp1 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]));
        Point pp2 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[1]));
        Point pp3 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[2]));
        Point pp4 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[3]));
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp2.x, pp2.y);
        b.lineTo(pp3.x, pp3.y);
        b.lineTo(pp4.x, pp4.y);
        b.lineTo(pp1.x, pp1.y);
        g.draw(b);
    }

    private Node findNode(EastNorth pos) {
        DataSet ds = Main.getLayerManager().getEditDataSet();
        LatLon l = BuildingsToolsPlugin.eastNorth2latlon(pos);
        List nodes = ds.searchNodes(new BBox(l.lon() - 1.0E-7, l.lat() - 1.0E-7, l.lon() + 1.0E-7, l.lat() + 1.0E-7));
        Node bestnode = null;
        double mindist = 3.0E-4;
        for (Node n : nodes) {
            double dist = n.getCoor().distanceSq(l);
            if (!(dist < mindist) || !n.isUsable()) continue;
            bestnode = n;
            mindist = dist;
        }
        return bestnode;
    }

    private Node getAddressNode() {
        BBox bbox = new BBox(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]), BuildingsToolsPlugin.eastNorth2latlon(this.en[1]));
        bbox.add(BuildingsToolsPlugin.eastNorth2latlon(this.en[2]));
        bbox.add(BuildingsToolsPlugin.eastNorth2latlon(this.en[3]));
        LinkedList<Node> nodes = new LinkedList<Node>();
        block0: for (Node n : Main.getLayerManager().getEditDataSet().searchNodes(bbox)) {
            if (!n.isUsable()) continue;
            for (String key : n.getKeys().keySet()) {
                if (!key.equals("building") && !key.startsWith("addr:")) continue;
                double x = this.projection1(BuildingsToolsPlugin.latlon2eastNorth(n.getCoor()));
                double y = this.projection2(BuildingsToolsPlugin.latlon2eastNorth(n.getCoor()));
                if (Math.signum(x) != Math.signum(this.len) || Math.signum(y) != Math.signum(this.width) || Math.abs(x) > Math.abs(this.len) || Math.abs(y) > Math.abs(this.width)) continue block0;
                for (OsmPrimitive p : n.getReferrers()) {
                    if (p.getType() != OsmPrimitiveType.WAY) continue;
                    continue block0;
                }
                nodes.add(n);
                continue block0;
            }
        }
        if (nodes.size() != 1) {
            return null;
        }
        return (Node)nodes.get(0);
    }

    public Way create() {
        Node addrNode;
        if (this.len == 0.0) {
            return null;
        }
        boolean[] created = new boolean[4];
        Node[] nodes = new Node[4];
        for (int i = 0; i < 4; ++i) {
            Node n = this.findNode(this.en[i]);
            if (n == null) {
                nodes[i] = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en[i]));
                created[i] = true;
            } else {
                nodes[i] = n;
                created[i] = false;
            }
            if (!nodes[i].getCoor().isOutSideWorld()) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place building outside of the world.", (Object[])new Object[0]));
            return null;
        }
        Way w = new Way();
        w.addNode(nodes[0]);
        if (this.projection2(this.en[2]) > 0.0 ^ this.len < 0.0) {
            w.addNode(nodes[1]);
            w.addNode(nodes[2]);
            w.addNode(nodes[3]);
        } else {
            w.addNode(nodes[3]);
            w.addNode(nodes[2]);
            w.addNode(nodes[1]);
        }
        w.addNode(nodes[0]);
        LinkedList<Object> cmds = new LinkedList<Object>();
        for (int i = 0; i < 4; ++i) {
            if (!created[i]) continue;
            cmds.add(new AddCommand((OsmPrimitive)nodes[i]));
        }
        cmds.add(new AddCommand((OsmPrimitive)w));
        if (ToolSettings.PROP_USE_ADDR_NODE.get().booleanValue() && (addrNode = this.getAddressNode()) != null) {
            for (Map.Entry entry : addrNode.getKeys().entrySet()) {
                w.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (OsmPrimitive p : addrNode.getReferrers()) {
                Relation r = (Relation)p;
                Relation rnew = new Relation(r);
                for (int i = 0; i < r.getMembersCount(); ++i) {
                    RelationMember member = r.getMember(i);
                    if (!addrNode.equals((Object)member.getMember())) continue;
                    rnew.removeMember(i);
                    rnew.addMember(i, new RelationMember(member.getRole(), (OsmPrimitive)w));
                }
                cmds.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)rnew));
            }
            cmds.add(new DeleteCommand((OsmPrimitive)addrNode));
        }
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create building", (Object[])new Object[0]), cmds);
        Main.main.undoRedo.add((Command)c);
        return w;
    }
}

