/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public class PngChunkIccp
extends PngChunk {
    public final String profileName;
    public final int compressionMethod;
    private final byte[] compressedProfile;
    private final byte[] uncompressedProfile;

    public byte[] getUncompressedProfile() {
        return this.uncompressedProfile;
    }

    public PngChunkIccp(int length, int chunkType, int crc, byte[] bytes) throws ImageReadException, IOException {
        super(length, chunkType, crc, bytes);
        int index = BinaryFunctions.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PngChunkIccp: No Profile Name");
        }
        byte[] nameBytes = new byte[index];
        System.arraycopy(bytes, 0, nameBytes, 0, index);
        this.profileName = new String(nameBytes, "ISO-8859-1");
        this.compressionMethod = bytes[index + 1];
        int compressedProfileLength = bytes.length - (index + 1 + 1);
        this.compressedProfile = new byte[compressedProfileLength];
        System.arraycopy(bytes, index + 1 + 1, this.compressedProfile, 0, compressedProfileLength);
        if (this.getDebug()) {
            System.out.println("ProfileName: " + this.profileName);
            System.out.println("ProfileName.length(): " + this.profileName.length());
            System.out.println("CompressionMethod: " + this.compressionMethod);
            System.out.println("CompressedProfileLength: " + compressedProfileLength);
            System.out.println("bytes.length: " + bytes.length);
        }
        this.uncompressedProfile = BinaryFunctions.getStreamBytes(new InflaterInputStream(new ByteArrayInputStream(this.compressedProfile)));
        if (this.getDebug()) {
            System.out.println("UncompressedProfile: " + Integer.toString(bytes.length));
        }
    }
}

