/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import s57.S57att;
import s57.S57box;
import s57.S57obj;
import s57.S57osm;
import s57.S57val;

public class S57map {
    public MapBounds bounds;
    public NodeTab nodes;
    public EdgeTab edges;
    public FtrMap features;
    public FtrTab index;
    public long xref;
    private long cref;
    private Feature feature;
    private Edge edge;
    private ArrayList<S57osm.KeyVal<?>> osm;
    private boolean sea;

    public S57map(boolean s) {
        this.sea = s;
        this.nodes = new NodeTab();
        this.edges = new EdgeTab();
        this.feature = new Feature();
        this.features = new FtrMap();
        this.index = new FtrTab();
        this.bounds = new MapBounds();
        this.cref = 0xFFFFFFFF0000L;
        this.xref = 0xFFF000000000000L;
    }

    public void newNode(long id, double lat, double lon, Nflag flag) {
        this.nodes.put(id, new Snode(Math.toRadians(lat), Math.toRadians(lon), flag));
        if (flag == Nflag.ANON) {
            this.edge.nodes.add(id);
        }
    }

    public void newNode(long id, double lat, double lon, double depth) {
        this.nodes.put(id, new Snode(Math.toRadians(lat), Math.toRadians(lon), depth));
    }

    public void newFeature(long id, Pflag p, long objl) {
        this.feature = new Feature();
        S57obj.Obj obj = S57obj.decodeType(objl);
        this.feature.geom = new Geom(p);
        this.feature.type = obj;
        if (obj != S57obj.Obj.UNKOBJ) {
            this.index.put(id, this.feature);
            this.feature.id = id;
        }
    }

    public void refObj(long id, int rind) {
        Rflag r = Rflag.UNKN;
        switch (rind) {
            case 1: {
                r = Rflag.MASTER;
                break;
            }
            case 2: {
                r = Rflag.SLAVE;
                break;
            }
            case 3: {
                r = Rflag.UNKN;
            }
        }
        this.feature.rels.add(new Reln(id, r));
    }

    public void endFeature() {
    }

    public void newAtt(long attl, String atvl) {
        S57att.Att att = S57att.decodeAttribute(attl);
        S57val.AttVal<?> val = S57val.decodeValue(atvl, att);
        this.feature.atts.put(att, val);
    }

    public void newPrim(long id, long ornt, long usag) {
        this.feature.geom.elems.add(new Prim(id, ornt != 2L, usag != 2L));
    }

    public void addConn(long id, int topi) {
        if (topi == 1) {
            this.edge.first = id;
        } else {
            this.edge.last = id;
        }
    }

    public void newEdge(long id) {
        this.edge = new Edge();
        this.edges.put(id, this.edge);
    }

    public void endFile() {
        Feature rel;
        Feature feature;
        long id;
        Iterator iterator = this.index.keySet().iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            feature = (Feature)this.index.get(id);
            this.sortGeom(feature);
            for (Reln reln : feature.rels) {
                rel = (Feature)this.index.get(reln.id);
                if (this.cmpGeoms(feature.geom, rel.geom)) {
                    switch (reln.reln) {
                        case SLAVE: {
                            feature.reln = Rflag.MASTER;
                            break;
                        }
                        default: {
                            feature.reln = Rflag.UNKN;
                        }
                    }
                    rel.reln = reln.reln;
                    continue;
                }
                reln.reln = Rflag.UNKN;
            }
        }
        iterator = this.index.keySet().iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            feature = (Feature)this.index.get(id);
            if (feature.reln == Rflag.UNKN) {
                feature.reln = Rflag.MASTER;
            }
            if (feature.type == S57obj.Obj.UNKOBJ || feature.reln != Rflag.MASTER) continue;
            if (this.features.get((Object)feature.type) == null) {
                this.features.put(feature.type, new ArrayList());
            }
            ((ArrayList)this.features.get((Object)feature.type)).add(feature);
        }
        iterator = this.index.keySet().iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            feature = (Feature)this.index.get(id);
            for (Reln reln : feature.rels) {
                rel = (Feature)this.index.get(reln.id);
                if (rel.reln != Rflag.SLAVE) continue;
                if (feature.objs.get((Object)rel.type) == null) {
                    feature.objs.put(rel.type, new ObjTab());
                }
                ObjTab tab = (ObjTab)feature.objs.get((Object)rel.type);
                int ix = tab.size();
                tab.put(ix, rel.atts);
            }
        }
    }

    public void addNode(long id, double lat, double lon) {
        this.nodes.put(id, new Snode(Math.toRadians(lat), Math.toRadians(lon)));
        this.feature = new Feature();
        this.feature.id = id;
        this.feature.reln = Rflag.UNKN;
        this.feature.geom.prim = Pflag.POINT;
        this.feature.geom.elems.add(new Prim(id));
        this.edge = null;
        this.osm = new ArrayList();
    }

    public void addEdge(long id) {
        this.feature = new Feature();
        this.feature.id = id;
        this.feature.reln = Rflag.UNKN;
        this.feature.geom.prim = Pflag.LINE;
        this.feature.geom.elems.add(new Prim(id));
        this.edge = new Edge();
        this.osm = new ArrayList();
    }

    public void addToEdge(long node) {
        if (this.edge.first == 0L) {
            this.edge.first = node;
            ((Snode)this.nodes.get((Object)Long.valueOf((long)node))).flg = Nflag.CONN;
        } else {
            if (this.edge.last != 0L) {
                this.edge.nodes.add(this.edge.last);
            }
            this.edge.last = node;
        }
    }

    public void addArea(long id) {
        this.feature = new Feature();
        this.feature.id = id;
        this.feature.reln = Rflag.UNKN;
        this.feature.geom.prim = Pflag.AREA;
        this.edge = null;
        this.osm = new ArrayList();
    }

    public void addToArea(long id, boolean outer) {
        this.feature.geom.elems.add(new Prim(id, outer));
    }

    public void addTag(String key, String val) {
        this.feature.reln = Rflag.MASTER;
        String[] subkeys = key.split(":");
        if (subkeys.length > 1 && subkeys[0].equals("seamark")) {
            S57obj.Obj obj = S57obj.enumType(subkeys[1]);
            if (subkeys.length > 2 && obj != S57obj.Obj.UNKOBJ) {
                AttMap atts;
                int idx = 0;
                S57att.Att att = S57att.Att.UNKATT;
                try {
                    idx = Integer.parseInt(subkeys[2]);
                    if (subkeys.length == 4) {
                        att = S57att.enumAttribute(subkeys[3], obj);
                    }
                }
                catch (Exception e) {
                    att = S57att.enumAttribute(subkeys[2], obj);
                }
                ObjTab objs = (ObjTab)this.feature.objs.get((Object)obj);
                if (objs == null) {
                    objs = new ObjTab();
                    this.feature.objs.put(obj, objs);
                }
                if ((atts = (AttMap)objs.get(idx)) == null) {
                    atts = new AttMap();
                    objs.put(idx, atts);
                }
                S57val.AttVal<?> attval = S57val.convertValue(val, att);
                if (attval.val != null) {
                    if (att == S57att.Att.VALSOU) {
                        Snode node = (Snode)this.nodes.get(this.feature.geom.elems.get((int)0).id);
                        node.val = (Double)attval.val;
                    }
                    atts.put(att, attval);
                }
            } else if (subkeys[1].equals("type")) {
                AttMap atts;
                this.feature.type = obj = S57obj.enumType(val);
                ObjTab objs = (ObjTab)this.feature.objs.get((Object)obj);
                if (objs == null) {
                    objs = new ObjTab();
                    this.feature.objs.put(obj, objs);
                }
                if ((atts = (AttMap)objs.get(0)) == null) {
                    atts = new AttMap();
                    objs.put(0, atts);
                }
                if (obj == S57obj.Obj.SOUNDG && this.feature.geom.prim == Pflag.POINT) {
                    Snode node = (Snode)this.nodes.get(this.feature.geom.elems.get((int)0).id);
                    node.flg = Nflag.DPTH;
                }
            } else if (obj != S57obj.Obj.UNKOBJ) {
                ObjTab objs;
                if (val.equals("yes") && (objs = (ObjTab)this.feature.objs.get((Object)obj)) == null) {
                    objs = new ObjTab();
                    this.feature.objs.put(obj, objs);
                }
            } else {
                S57att.Att att = S57att.enumAttribute(subkeys[1], S57obj.Obj.UNKOBJ);
                if (att != S57att.Att.UNKATT) {
                    S57val.AttVal<?> attval = S57val.convertValue(val, att);
                    if (attval.val != null) {
                        this.feature.atts.put(att, attval);
                    }
                }
            }
        } else if (!this.sea) {
            S57osm.OSMtag(this.osm, key, val);
        }
    }

    public void tagsDone(long id) {
        switch (this.feature.geom.prim) {
            case POINT: {
                Snode node = (Snode)this.nodes.get(id);
                if (node.flg == Nflag.CONN || node.flg == Nflag.DPTH || this.feature.objs.isEmpty() && this.osm.isEmpty()) break;
                node.flg = Nflag.ISOL;
                break;
            }
            case LINE: {
                this.edges.put(id, this.edge);
                ((Snode)this.nodes.get((Object)Long.valueOf((long)this.edge.first))).flg = Nflag.CONN;
                ((Snode)this.nodes.get((Object)Long.valueOf((long)this.edge.last))).flg = Nflag.CONN;
                if (this.edge.first != this.edge.last) break;
                this.feature.geom.prim = Pflag.AREA;
                break;
            }
            case AREA: {
                break;
            }
        }
        if (this.sortGeom(this.feature) && (this.edge == null || this.edge.last != 0L)) {
            if (this.feature.type != S57obj.Obj.UNKOBJ) {
                this.index.put(id, this.feature);
                if (this.features.get((Object)this.feature.type) == null) {
                    this.features.put(this.feature.type, new ArrayList());
                }
                ((ArrayList)this.features.get((Object)this.feature.type)).add(this.feature);
            }
            for (S57osm.KeyVal<?> kvx : this.osm) {
                Feature base = new Feature();
                base.reln = Rflag.MASTER;
                base.geom = this.feature.geom;
                base.type = kvx.obj;
                ObjTab objs = new ObjTab();
                base.objs.put(kvx.obj, objs);
                AttMap atts = new AttMap();
                objs.put(0, atts);
                if (kvx.att != S57att.Att.UNKATT) {
                    atts.put(kvx.att, new S57val.AttVal(kvx.conv, kvx.val));
                }
                this.index.put(++this.xref, base);
                if (this.features.get((Object)kvx.obj) == null) {
                    this.features.put(kvx.obj, new ArrayList());
                }
                ((ArrayList)this.features.get((Object)kvx.obj)).add(base);
            }
        }
    }

    public void mapDone() {
        if (!this.sea) {
            S57box.bBox(this);
        }
    }

    public boolean sortGeom(Feature feature) {
        try {
            Geom sort = new Geom(feature.geom.prim);
            long first = 0L;
            long last = 0L;
            Comp comp = null;
            boolean next = true;
            feature.geom.length = 0.0;
            feature.geom.area = 0.0;
            if (feature.geom.elems.isEmpty()) {
                return false;
            }
            if (feature.geom.prim == Pflag.POINT) {
                feature.geom.centre = (Snode)this.nodes.get(feature.geom.elems.get((int)0).id);
                return true;
            }
            Geom outer = new Geom(feature.geom.prim);
            Geom inner = new Geom(feature.geom.prim);
            for (Prim prim : feature.geom.elems) {
                if (prim.outer) {
                    outer.elems.add(prim);
                    continue;
                }
                inner.elems.add(prim);
            }
            boolean outin = true;
            int sweep = outer.elems.size();
            if (sweep == 0) {
                return false;
            }
            int prev = sweep;
            int top = 0;
            while (!outer.elems.isEmpty()) {
                Prim prim = outer.elems.remove(0);
                Edge edge = (Edge)this.edges.get(prim.id);
                if (edge == null) {
                    return false;
                }
                if (next) {
                    next = false;
                    first = edge.first;
                    last = edge.last;
                    prim.forward = true;
                    sort.elems.add(prim);
                    if (prim.outer) {
                        ++sort.outers;
                    } else {
                        ++sort.inners;
                    }
                    comp = new Comp(this.cref++, 1);
                    sort.comps.add(comp);
                } else if (edge.first == last) {
                    sort.elems.add(prim);
                    last = edge.last;
                    prim.forward = true;
                    ++comp.size;
                } else if (edge.last == first) {
                    sort.elems.add(top, prim);
                    first = edge.first;
                    prim.forward = true;
                    ++comp.size;
                } else if (edge.last == last) {
                    sort.elems.add(prim);
                    last = edge.first;
                    prim.forward = false;
                    ++comp.size;
                } else if (edge.first == first) {
                    sort.elems.add(top, prim);
                    first = edge.last;
                    prim.forward = false;
                    ++comp.size;
                } else {
                    outer.elems.add(prim);
                }
                if (--sweep != 0) continue;
                sweep = outer.elems.size();
                if (sweep == 0 || sweep == prev) {
                    if (sort.prim == Pflag.AREA && first != last) {
                        return false;
                    }
                    if (outin) {
                        if (sweep != 0) {
                            return false;
                        }
                        outer = inner;
                        outin = false;
                        sweep = outer.elems.size();
                    }
                    next = true;
                    top = sort.elems.size();
                }
                prev = sweep;
            }
            if (sort.prim == Pflag.LINE && sort.outers == 1 && sort.inners == 0 && first == last) {
                sort.prim = Pflag.AREA;
            }
            feature.geom = sort;
            if (feature.geom.prim == Pflag.AREA) {
                int ie = 0;
                int ic = 0;
                while (ie < feature.geom.elems.size()) {
                    double area = this.calcArea(feature.geom, ic);
                    if (ie == 0) {
                        feature.geom.area = Math.abs(area) * 3444.0 * 3444.0;
                    }
                    if (ie == 0 && area < 0.0 || ie > 0 && area >= 0.0) {
                        ArrayList<Prim> tmp = new ArrayList<Prim>();
                        for (int i = 0; i < feature.geom.comps.get((int)ic).size; ++i) {
                            Prim p = feature.geom.elems.remove(ie);
                            p.forward = !p.forward;
                            tmp.add(0, p);
                        }
                        feature.geom.elems.addAll(ie, tmp);
                    }
                    ie += feature.geom.comps.get((int)ic).size;
                    ++ic;
                }
            }
            feature.geom.length = this.calcLength(feature.geom);
            feature.geom.centre = this.calcCentroid(feature);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean cmpGeoms(Geom g1, Geom g2) {
        return g1.prim == g2.prim && g1.outers == g2.outers && g1.inners == g2.inners && g1.elems.size() == g2.elems.size();
    }

    double calcArea(Geom geom, int comp) {
        double llat = 0.0;
        double llon = 0.0;
        double lon = 0.0;
        double lat = 0.0;
        double sigma = 0.0;
        GeomIterator git = new GeomIterator(geom);
        for (int i = 0; i <= comp; ++i) {
            if (!git.hasComp()) continue;
            git.nextComp();
            while (git.hasEdge()) {
                git.nextEdge();
                while (git.hasNode()) {
                    Snode node = git.next();
                    if (node == null) continue;
                    llon = lon;
                    llat = lat;
                    lat = node.lat;
                    lon = node.lon;
                    sigma += lon * Math.sin(llat) - llon * Math.sin(lat);
                }
            }
            if (i == comp) continue;
            llat = 0.0;
            llon = 0.0;
            lon = 0.0;
            lat = 0.0;
            sigma = 0.0;
        }
        return sigma / 2.0;
    }

    double calcLength(Geom geom) {
        double llat = 0.0;
        double llon = 0.0;
        double lon = 0.0;
        double lat = 0.0;
        double sigma = 0.0;
        boolean first = true;
        GeomIterator git = new GeomIterator(geom);
        while (git.hasComp()) {
            git.nextComp();
            while (git.hasEdge()) {
                git.nextEdge();
                while (git.hasNode()) {
                    Snode node = git.next();
                    if (first) {
                        first = false;
                        lat = node.lat;
                        lon = node.lon;
                        continue;
                    }
                    if (node == null) continue;
                    llat = lat;
                    llon = lon;
                    lat = node.lat;
                    lon = node.lon;
                    sigma += Math.acos(Math.sin(lat) * Math.sin(llat) + Math.cos(lat) * Math.cos(llat) * Math.cos(llon - lon));
                }
            }
        }
        return sigma * 3444.0;
    }

    Snode calcCentroid(Feature feature) {
        double slon = 0.0;
        double slat = 0.0;
        double lon = 0.0;
        double lat = 0.0;
        double llon = 0.0;
        double llat = 0.0;
        double sarc = 0.0;
        boolean first = true;
        switch (feature.geom.prim) {
            case POINT: {
                return (Snode)this.nodes.get(feature.geom.elems.get((int)0).id);
            }
            case LINE: {
                GeomIterator git = new GeomIterator(feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            Snode node = git.next();
                            if (node == null) continue;
                            lat = node.lat;
                            lon = node.lon;
                            if (first) {
                                first = false;
                            } else {
                                sarc += Math.acos(Math.cos(lon - llon) * Math.cos(lat - llat));
                            }
                            llat = lat;
                            llon = lon;
                        }
                    }
                }
                double harc = sarc / 2.0;
                sarc = 0.0;
                first = true;
                git = new GeomIterator(feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    block9: while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            Snode node = git.next();
                            if (node == null) continue;
                            lat = node.lat;
                            lon = node.lon;
                            if (first) {
                                first = false;
                            } else {
                                sarc = Math.acos(Math.cos(lon - llon) * Math.cos(lat - llat));
                                if (sarc > harc) continue block9;
                            }
                            harc -= sarc;
                            llat = lat;
                            llon = lon;
                        }
                    }
                }
                return new Snode(llat + (lat - llat) * harc / sarc, llon + (lon - llon) * harc / sarc);
            }
            case AREA: {
                GeomIterator git = new GeomIterator(feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            Snode node = git.next();
                            lat = node.lat;
                            lon = node.lon;
                            if (first) {
                                first = false;
                            } else {
                                double arc = Math.acos(Math.cos(lon - llon) * Math.cos(lat - llat));
                                slat += (lat + llat) / 2.0 * arc;
                                slon += (lon + llon) / 2.0 * arc;
                                sarc += arc;
                            }
                            llon = lon;
                            llat = lat;
                        }
                    }
                }
                return new Snode(sarc > 0.0 ? slat / sarc : 0.0, sarc > 0.0 ? slon / sarc : 0.0);
            }
        }
        return null;
    }

    public class GeomIterator {
        Geom geom;
        Prim prim;
        EdgeIterator eit;
        ListIterator<Prim> ite;
        ListIterator<Comp> itc;
        Comp comp;
        int ec;
        long lastref;

        public GeomIterator(Geom g) {
            this.geom = g;
            this.lastref = 0L;
            this.ite = this.geom.elems.listIterator();
            this.itc = this.geom.comps.listIterator();
        }

        public boolean hasComp() {
            return this.itc.hasNext();
        }

        public long nextComp() {
            this.comp = this.itc.next();
            this.ec = this.comp.size;
            this.lastref = 0L;
            return this.comp.ref;
        }

        public boolean hasEdge() {
            return this.ec > 0 && this.ite.hasNext();
        }

        public long nextEdge() {
            this.prim = this.ite.next();
            this.eit = new EdgeIterator((Edge)S57map.this.edges.get(this.prim.id), this.prim.forward);
            --this.ec;
            return this.prim.id;
        }

        public boolean hasNode() {
            return this.eit.hasNext();
        }

        public long nextRef(boolean all) {
            long ref = this.eit.nextRef();
            if (!all && ref == this.lastref) {
                ref = this.eit.nextRef();
            }
            this.lastref = ref;
            return ref;
        }

        public long nextRef() {
            return this.nextRef(false);
        }

        public Snode next() {
            return (Snode)S57map.this.nodes.get(this.nextRef());
        }
    }

    public class EdgeIterator {
        Edge edge;
        boolean forward;
        ListIterator<Long> it;

        public EdgeIterator(Edge e, boolean dir) {
            this.edge = e;
            this.forward = dir;
            this.it = null;
        }

        public boolean hasNext() {
            return this.edge != null;
        }

        public long nextRef() {
            long ref = 0L;
            if (this.forward) {
                if (this.it == null) {
                    ref = this.edge.first;
                    this.it = this.edge.nodes.listIterator();
                } else if (this.it.hasNext()) {
                    ref = this.it.next();
                } else {
                    ref = this.edge.last;
                    this.edge = null;
                }
            } else if (this.it == null) {
                ref = this.edge.last;
                this.it = this.edge.nodes.listIterator(this.edge.nodes.size());
            } else if (this.it.hasPrevious()) {
                ref = this.it.previous();
            } else {
                ref = this.edge.first;
                this.edge = null;
            }
            return ref;
        }

        public Snode next() {
            return (Snode)S57map.this.nodes.get(this.nextRef());
        }
    }

    public class Feature {
        public long id = 0L;
        public Rflag reln = Rflag.UNKN;
        public Geom geom;
        public S57obj.Obj type;
        public AttMap atts;
        public RelTab rels;
        public ObjMap objs;

        Feature() {
            this.geom = new Geom(Pflag.NOSP);
            this.type = S57obj.Obj.UNKOBJ;
            this.atts = new AttMap();
            this.rels = new RelTab();
            this.objs = new ObjMap();
        }
    }

    public class Geom {
        public Pflag prim;
        public ArrayList<Prim> elems;
        public int outers;
        public int inners;
        public ArrayList<Comp> comps;
        public double area;
        public double length;
        public Snode centre;

        public Geom(Pflag p) {
            this.prim = p;
            this.elems = new ArrayList();
            this.inners = 0;
            this.outers = 0;
            this.comps = new ArrayList();
            this.area = 0.0;
            this.length = 0.0;
            this.centre = new Snode();
        }
    }

    public static enum Pflag {
        NOSP,
        POINT,
        LINE,
        AREA;

    }

    public class Comp {
        public long ref;
        public int size;

        public Comp(long r, int s) {
            this.ref = r;
            this.size = s;
        }
    }

    public class Prim {
        public long id;
        public boolean forward;
        public boolean outer;
        public boolean trunc;

        public Prim() {
            this.id = 0L;
            this.forward = true;
            this.outer = true;
            this.trunc = false;
        }

        public Prim(long i) {
            this.id = i;
            this.forward = true;
            this.outer = true;
            this.trunc = false;
        }

        public Prim(long i, boolean o) {
            this.id = i;
            this.forward = true;
            this.outer = o;
            this.trunc = false;
        }

        public Prim(long i, boolean f, boolean o) {
            this.id = i;
            this.forward = f;
            this.outer = o;
            this.trunc = false;
        }

        public Prim(long i, boolean f, boolean o, boolean t) {
            this.id = i;
            this.forward = f;
            this.outer = o;
            this.trunc = t;
        }
    }

    public class FtrTab
    extends HashMap<Long, Feature> {
    }

    public class FtrMap
    extends EnumMap<S57obj.Obj, ArrayList<Feature>> {
        public FtrMap() {
            super(S57obj.Obj.class);
        }
    }

    public class EdgeTab
    extends HashMap<Long, Edge> {
    }

    public class NodeTab
    extends HashMap<Long, Snode> {
    }

    public class AttMap
    extends HashMap<S57att.Att, S57val.AttVal<?>> {
    }

    public class ObjMap
    extends EnumMap<S57obj.Obj, ObjTab> {
        public ObjMap() {
            super(S57obj.Obj.class);
        }
    }

    public class ObjTab
    extends HashMap<Integer, AttMap> {
    }

    public class RelTab
    extends ArrayList<Reln> {
    }

    public class Reln {
        public long id;
        public Rflag reln;

        public Reln(long i, Rflag r) {
            this.id = i;
            this.reln = r;
        }
    }

    public static enum Rflag {
        UNKN,
        MASTER,
        SLAVE;

    }

    public class Edge {
        public long first = 0L;
        public long last = 0L;
        public ArrayList<Long> nodes = new ArrayList();
    }

    public class Snode {
        public double lat;
        public double lon;
        public Nflag flg;
        public double val;

        public Snode() {
            this.flg = Nflag.ANON;
            this.lat = 0.0;
            this.lon = 0.0;
            this.val = 0.0;
        }

        public Snode(double ilat, double ilon) {
            this.flg = Nflag.ANON;
            this.lat = ilat;
            this.lon = ilon;
            this.val = 0.0;
        }

        public Snode(double ilat, double ilon, Nflag iflg) {
            this.lat = ilat;
            this.lon = ilon;
            this.flg = iflg;
            this.val = 0.0;
        }

        public Snode(double ilat, double ilon, double ival) {
            this.flg = Nflag.DPTH;
            this.lat = ilat;
            this.lon = ilon;
            this.val = ival;
        }
    }

    public static enum Nflag {
        ANON,
        ISOL,
        CONN,
        TRNK,
        DPTH;

    }

    public class MapBounds {
        public double minlat = Math.toRadians(90.0);
        public double minlon = Math.toRadians(180.0);
        public double maxlat = Math.toRadians(-90.0);
        public double maxlon = Math.toRadians(-180.0);
    }
}

