/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.oauth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.oauth.OAuthUtils;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;

public final class MapillaryUser {
    private static String username;
    private static String imagesPolicy;
    private static String imagesHash;
    private static boolean isTokenValid;

    private MapillaryUser() {
    }

    public static synchronized String getUsername() {
        if (!isTokenValid) {
            return null;
        }
        if (username == null) {
            try {
                username = OAuthUtils.getWithHeader(MapillaryURL.userURL()).getString("username");
            }
            catch (IOException e) {
                Main.info((String)"Invalid Mapillary token, resetting field");
                MapillaryUser.reset();
            }
        }
        return username;
    }

    public static synchronized Map<String, String> getSecrets() {
        if (!isTokenValid) {
            return null;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        try {
            if (imagesHash == null) {
                imagesHash = OAuthUtils.getWithHeader(MapillaryURL.uploadSecretsURL()).getString("images_hash");
            }
            hash.put("images_hash", imagesHash);
            if (imagesPolicy == null) {
                imagesPolicy = OAuthUtils.getWithHeader(MapillaryURL.uploadSecretsURL()).getString("images_policy");
            }
        }
        catch (IOException e) {
            Main.info((String)"Invalid Mapillary token, resetting field");
            MapillaryUser.reset();
        }
        hash.put("images_policy", imagesPolicy);
        return hash;
    }

    public static synchronized void reset() {
        username = null;
        imagesPolicy = null;
        imagesHash = null;
        isTokenValid = false;
        Main.pref.put("mapillary.access-token", null);
    }

    public static synchronized void setTokenValid(boolean value) {
        isTokenValid = value;
    }

    static {
        isTokenValid = true;
    }
}

