/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import buildings_tools.AddressDialog;
import buildings_tools.Building;
import buildings_tools.BuildingsToolsPlugin;
import buildings_tools.ToolSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DrawBuildingAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
KeyPressReleaseListener,
ModifierListener {
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currCursor;
    private Cursor customCursor;
    private Mode mode = Mode.None;
    private Mode nextMode = Mode.None;
    private Color selectedColor = Color.red;
    private Point drawStartPos;
    private Point mousePos;
    final Building building = new Building();

    public DrawBuildingAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Draw buildings", (Object[])new Object[0]), "building", I18n.tr((String)"Draw buildings", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Draw buildings", (Object[])new Object[0])}), (int)66, (int)5003), mapFrame, DrawBuildingAction.getCursor());
        this.cursorCrosshair = DrawBuildingAction.getCursor();
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currCursor = this.cursorCrosshair;
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", (String)"building");
        }
        catch (Exception e) {
            Main.error((Throwable)e);
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setCursor(final Cursor c) {
        if (this.currCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!(Main.map.mapMode instanceof DrawBuildingAction)) {
                        return;
                    }
                    Main.map.mapView.setCursor(c);
                }
            });
            this.currCursor = c;
        }
        catch (Exception e) {
            Main.error((Throwable)e);
        }
    }

    private void showAddrDialog(Way w) {
        AddressDialog dlg = new AddressDialog();
        if (!this.alt) {
            dlg.showDialog();
            if (dlg.getValue() != 1) {
                return;
            }
        }
        dlg.saveValues();
        String tmp = dlg.getHouseNum();
        if (tmp != null && !tmp.isEmpty()) {
            w.put("addr:housenumber", tmp);
        }
        if ((tmp = dlg.getStreetName()) != null && !tmp.isEmpty()) {
            w.put("addr:street", tmp);
        }
    }

    public void enterMode() {
        super.enterMode();
        if (this.getLayerManager().getEditDataSet() == null) {
            Main.map.selectSelectTool(false);
            return;
        }
        this.selectedColor = Main.pref.getColor(I18n.marktr((String)"selected"), this.selectedColor);
        this.currCursor = this.cursorCrosshair;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        Main.map.keyDetector.addKeyListener((KeyPressReleaseListener)this);
        Main.map.keyDetector.addModifierListener((ModifierListener)this);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.updateSnap(this.getLayerManager().getEditDataSet().getSelected());
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        Main.map.keyDetector.removeKeyListener((KeyPressReleaseListener)this);
        Main.map.keyDetector.removeModifierListener((ModifierListener)this);
        DataSet.removeSelectionListener((SelectionChangedListener)this);
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
        this.mode = Mode.None;
    }

    public final void cancelDrawing() {
        this.mode = Mode.None;
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setAngle(-1.0);
        this.building.reset();
        Main.map.mapView.repaint();
        this.updateStatusLine();
    }

    public void modifiersChanged(int modifiers) {
        boolean oldCtrl = this.ctrl;
        boolean oldShift = this.shift;
        this.updateKeyModifiers(modifiers);
        if (this.ctrl != oldCtrl || this.shift != oldShift) {
            this.processMouseEvent(null);
            this.updCursor();
            if (this.mode != Mode.None) {
                Main.map.mapView.repaint();
            }
        }
    }

    public void doKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (this.mode != Mode.None) {
                e.consume();
            }
            this.cancelDrawing();
        }
    }

    public void doKeyReleased(KeyEvent e) {
    }

    private EastNorth getEastNorth() {
        Node n = this.ctrl ? null : Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        if (n == null) {
            return BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y));
        }
        return BuildingsToolsPlugin.latlon2eastNorth(n.getCoor());
    }

    private boolean isRectDrawing() {
        return this.building.isRectDrawing() && (!this.shift || ToolSettings.isBBMode());
    }

    private Mode modeDrawing() {
        EastNorth p = this.getEastNorth();
        if (this.isRectDrawing()) {
            this.building.setPlaceRect(p);
            return this.shift ? Mode.DrawingAngFix : Mode.None;
        }
        this.building.setPlace(p, ToolSettings.getWidth(), ToolSettings.getLenStep(), this.shift);
        Main.map.statusLine.setDist(this.building.getLength());
        this.nextMode = ToolSettings.getWidth() == 0.0 ? Mode.DrawingWidth : Mode.None;
        return this.nextMode;
    }

    private Mode modeDrawingWidth() {
        this.building.setWidth(this.getEastNorth());
        Main.map.statusLine.setDist(Math.abs(this.building.getWidth()));
        return Mode.None;
    }

    private Mode modeDrawingAngFix() {
        this.building.angFix(this.getEastNorth());
        return Mode.None;
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
            this.updateKeyModifiers(e);
        }
        if (this.mode == Mode.None) {
            this.nextMode = Mode.None;
            return;
        }
        if (this.mode == Mode.Drawing) {
            this.nextMode = this.modeDrawing();
        } else if (this.mode == Mode.DrawingWidth) {
            this.nextMode = this.modeDrawingWidth();
        } else if (this.mode == Mode.DrawingAngFix) {
            this.nextMode = this.modeDrawingAngFix();
        } else {
            throw new AssertionError((Object)"Invalid drawing mode");
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mode == Mode.None || this.building.getLength() == 0.0) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.building.paint(g, mv);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.drawStartPos = this.mousePos = e.getPoint();
        Node n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        if (n == null) {
            this.building.setBase(BuildingsToolsPlugin.latlon2eastNorth(Main.map.mapView.getLatLon(this.mousePos.x, this.mousePos.y)));
        } else {
            this.building.setBase(n);
        }
        this.mode = Mode.Drawing;
        this.updateStatusLine();
    }

    private void drawingAdvance(MouseEvent e) {
        this.processMouseEvent(e);
        if (this.mode != Mode.None && this.nextMode == Mode.None) {
            this.drawingFinish();
        } else {
            this.mode = this.nextMode;
            this.updateStatusLine();
        }
    }

    private void drawingFinish() {
        Way w;
        if (this.building.getLength() != 0.0 && (w = this.building.create()) != null) {
            if (!this.alt || ToolSettings.isUsingAddr()) {
                for (Map.Entry<String, String> kv : ToolSettings.getTags().entrySet()) {
                    w.put(kv.getKey(), kv.getValue());
                }
            }
            if (ToolSettings.isUsingAddr()) {
                this.showAddrDialog(w);
            }
            if (ToolSettings.isAutoSelect() && (this.getLayerManager().getEditDataSet().getSelected().isEmpty() || this.shift)) {
                this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{w});
            }
        }
        this.cancelDrawing();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.requestFocusInMapView();
        if (this.mode == Mode.None) {
            this.drawingStart(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            dragged = e.getPoint().distance(this.drawStartPos) > 10.0;
        }
        this.drawStartPos = null;
        if (this.mode == Mode.Drawing && !dragged) {
            return;
        }
        if (this.mode == Mode.None) {
            return;
        }
        this.drawingAdvance(e);
    }

    private void updCursor() {
        if (this.mousePos == null) {
            return;
        }
        if (!Main.isDisplayingMapView()) {
            return;
        }
        Node n = null;
        if (!this.ctrl) {
            n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isUsablePredicate);
        }
        if (n != null) {
            this.setCursor(this.cursorJoinNode);
        } else if (this.customCursor != null && (!this.ctrl || this.isRectDrawing())) {
            this.setCursor(this.customCursor);
        } else {
            this.setCursor(this.cursorCrosshair);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.None) {
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.None) {
            return I18n.tr((String)"Point on the corner of the building to start drawing", (Object[])new Object[0]);
        }
        if (this.mode == Mode.Drawing) {
            return I18n.tr((String)"Point on opposite end of the building", (Object[])new Object[0]);
        }
        if (this.mode == Mode.DrawingWidth) {
            return I18n.tr((String)"Set width of the building", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public final void updateSnap(Collection<? extends OsmPrimitive> newSelection) {
        this.building.clearAngleSnap();
        if (newSelection.size() <= 10) {
            LinkedList<Node> nodes = new LinkedList<Node>();
            LinkedList<Way> ways = new LinkedList<Way>();
            for (OsmPrimitive osmPrimitive : newSelection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        nodes.add((Node)osmPrimitive);
                        break;
                    }
                    case WAY: {
                        ways.add((Way)osmPrimitive);
                        break;
                    }
                }
            }
            this.building.addAngleSnap(nodes.toArray(new Node[0]));
            for (Way way : ways) {
                this.building.addAngleSnap(way);
            }
        }
        this.updateCustomCursor();
    }

    private void updateCustomCursor() {
        Double angle = this.building.getDrawingAngle();
        if (angle == null || !ToolSettings.isSoftCursor()) {
            this.customCursor = null;
            return;
        }
        int R = 9;
        int r = 3;
        BufferedImage img = new BufferedImage(32, 32, 2);
        Graphics2D g = img.createGraphics();
        GeneralPath b = new GeneralPath();
        b.moveTo(16.0 - Math.cos(angle) * 9.0, 16.0 - Math.sin(angle) * 9.0);
        b.lineTo(16.0 - Math.cos(angle) * 3.0, 16.0 - Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.cos(angle) * 9.0, 16.0 + Math.sin(angle) * 9.0);
        b.lineTo(16.0 + Math.cos(angle) * 3.0, 16.0 + Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.sin(angle) * 9.0, 16.0 - Math.cos(angle) * 9.0);
        b.lineTo(16.0 + Math.sin(angle) * 3.0, 16.0 - Math.cos(angle) * 3.0);
        b.moveTo(16.0 - Math.sin(angle) * 9.0, 16.0 + Math.cos(angle) * 9.0);
        b.lineTo(16.0 - Math.sin(angle) * 3.0, 16.0 + Math.cos(angle) * 3.0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.setColor(Color.WHITE);
        g.draw(b);
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        g.setColor(Color.BLACK);
        g.draw(b);
        this.customCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 16), "custom crosshair");
        this.updCursor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.updateSnap(newSelection);
    }

    private static enum Mode {
        None,
        Drawing,
        DrawingWidth,
        DrawingAngFix;

    }
}

