/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.Serializer;

public final class Atomic {
    private Atomic() {
    }

    public static Long createLong(DB db, java.lang.String name, long initVal) {
        db.checkNameNotExists(name);
        long recid = db.getEngine().put(initVal, Serializer.LONG_SERIALIZER);
        db.getNameDir().put(name, recid);
        return new Long(db.getEngine(), recid);
    }

    public static Long getLong(DB db, java.lang.String name) {
        java.lang.Long recid = db.nameDir.get(name);
        return recid == null ? Atomic.createLong(db, name, 0L) : new Long(db.getEngine(), recid);
    }

    public static Integer createInteger(DB db, java.lang.String name, int initVal) {
        db.checkNameNotExists(name);
        long recid = db.getEngine().put(initVal, Serializer.INTEGER_SERIALIZER);
        db.getNameDir().put(name, recid);
        return new Integer(db.getEngine(), recid);
    }

    public static Integer getInteger(DB db, java.lang.String name) {
        java.lang.Long recid = db.nameDir.get(name);
        return recid == null ? Atomic.createInteger(db, name, 0) : new Integer(db.getEngine(), recid);
    }

    public static Boolean createBoolean(DB db, java.lang.String name, boolean initVal) {
        db.checkNameNotExists(name);
        long recid = db.getEngine().put(initVal, Serializer.BOOLEAN_SERIALIZER);
        db.getNameDir().put(name, recid);
        return new Boolean(db.getEngine(), recid);
    }

    public static Boolean getBoolean(DB db, java.lang.String name) {
        java.lang.Long recid = db.nameDir.get(name);
        return recid == null ? Atomic.createBoolean(db, name, false) : new Boolean(db.getEngine(), recid);
    }

    public static String createString(DB db, java.lang.String name, java.lang.String initVal) {
        if (initVal == null) {
            throw new IllegalArgumentException("initVal may not be null");
        }
        db.checkNameNotExists(name);
        long recid = db.getEngine().put(initVal, Serializer.STRING_SERIALIZER);
        db.getNameDir().put(name, recid);
        return new String(db.getEngine(), recid);
    }

    public static String getString(DB db, java.lang.String name) {
        java.lang.Long recid = db.nameDir.get(name);
        return recid == null ? Atomic.createString(db, name, "") : new String(db.getEngine(), recid);
    }

    public static <E> Var<E> createVar(DB db, java.lang.String name, E initVal, Serializer<E> serializer) {
        db.checkNameNotExists(name);
        if (serializer == null) {
            serializer = db.getDefaultSerializer();
        }
        long recid = db.getEngine().put(initVal, serializer);
        db.getNameDir().put(name, recid);
        return new Var(db.getEngine(), recid, serializer);
    }

    public static <E> Var<E> getVar(DB db, java.lang.String name, Serializer<E> serializer) {
        java.lang.Long recid = db.nameDir.get(name);
        if (serializer == null) {
            serializer = db.getDefaultSerializer();
        }
        return recid == null ? Atomic.createVar(db, name, null, serializer) : new Var<Object>(db.getEngine(), recid, serializer);
    }

    public static final class Var<E> {
        protected final Engine engine;
        protected final long recid;
        protected final Serializer<E> serializer;

        public Var(Engine engine, long recid, Serializer<E> serializer) {
            this.engine = engine;
            this.recid = recid;
            this.serializer = serializer;
        }

        public java.lang.String toString() {
            E v = this.get();
            return v == null ? null : v.toString();
        }

        public final E get() {
            return this.engine.get(this.recid, this.serializer);
        }

        public final boolean compareAndSet(E expect, E update) {
            return this.engine.compareAndSwap(this.recid, expect, update, this.serializer);
        }

        public final void set(E newValue) {
            this.engine.update(this.recid, newValue, this.serializer);
        }

        public final E getAndSet(E newValue) {
            E current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class String {
        protected final Engine engine;
        protected final long recid;

        public String(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public java.lang.String toString() {
            return this.get();
        }

        public final java.lang.String get() {
            return this.engine.get(this.recid, Serializer.STRING_SERIALIZER);
        }

        public final boolean compareAndSet(java.lang.String expect, java.lang.String update) {
            return this.engine.compareAndSwap(this.recid, expect, update, Serializer.STRING_SERIALIZER);
        }

        public final void set(java.lang.String newValue) {
            this.engine.update(this.recid, newValue, Serializer.STRING_SERIALIZER);
        }

        public final java.lang.String getAndSet(java.lang.String newValue) {
            java.lang.String current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class Boolean {
        protected final Engine engine;
        protected final long recid;

        public Boolean(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public final boolean get() {
            return this.engine.get(this.recid, Serializer.BOOLEAN_SERIALIZER);
        }

        public final boolean compareAndSet(boolean expect, boolean update) {
            return this.engine.compareAndSwap(this.recid, expect, update, Serializer.BOOLEAN_SERIALIZER);
        }

        public final void set(boolean newValue) {
            this.engine.update(this.recid, newValue, Serializer.BOOLEAN_SERIALIZER);
        }

        public final boolean getAndSet(boolean newValue) {
            boolean current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    public static final class Long
    extends Number {
        private static final long serialVersionUID = 2882620413591274781L;
        protected final Engine engine;
        protected final long recid;

        public Long(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public final long get() {
            return this.engine.get(this.recid, Serializer.LONG_SERIALIZER);
        }

        public final void set(long newValue) {
            this.engine.update(this.recid, newValue, Serializer.LONG_SERIALIZER);
        }

        public final long getAndSet(long newValue) {
            long current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(long expect, long update) {
            return this.engine.compareAndSwap(this.recid, expect, update, Serializer.LONG_SERIALIZER);
        }

        public final long getAndIncrement() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
            }
            return current;
        }

        public final long getAndDecrement() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
            }
            return current;
        }

        public final long getAndAdd(long delta) {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return current;
        }

        public final long incrementAndGet() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + 1L)) {
            }
            return next;
        }

        public final long decrementAndGet() {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current - 1L)) {
            }
            return next;
        }

        public final long addAndGet(long delta) {
            long next;
            long current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return next;
        }

        public java.lang.String toString() {
            return java.lang.Long.toString(this.get());
        }

        @Override
        public int intValue() {
            return (int)this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }

    public static final class Integer
    extends Number {
        private static final long serialVersionUID = 4615119399830853054L;
        protected final Engine engine;
        protected final long recid;

        public Integer(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public final int get() {
            return this.engine.get(this.recid, Serializer.INTEGER_SERIALIZER);
        }

        public final void set(int newValue) {
            this.engine.update(this.recid, newValue, Serializer.INTEGER_SERIALIZER);
        }

        public final int getAndSet(int newValue) {
            int current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(int expect, int update) {
            return this.engine.compareAndSwap(this.recid, expect, update, Serializer.INTEGER_SERIALIZER);
        }

        public final int getAndIncrement() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + 1)) {
            }
            return current;
        }

        public final int getAndDecrement() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current - 1)) {
            }
            return current;
        }

        public final int getAndAdd(int delta) {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return current;
        }

        public final int incrementAndGet() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + 1)) {
            }
            return next;
        }

        public final int decrementAndGet() {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current - 1)) {
            }
            return next;
        }

        public final int addAndGet(int delta) {
            int next;
            int current;
            while (!this.compareAndSet(current = this.get(), next = current + delta)) {
            }
            return next;
        }

        public java.lang.String toString() {
            return java.lang.Integer.toString(this.get());
        }

        @Override
        public int intValue() {
            return this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }
}

