/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMember;

public final class PublicTransportHelper {
    public static final String PUBLIC_TRANSPORT = "public_transport";
    public static final String STOP_POSITION = "stop_position";
    public static final String STOP = "stop";
    public static final String STOP_AREA = "stop_area";
    public static final String PLATFORM = "platform";
    public static final String HIGHWAY = "highway";
    public static final String RAILWAY = "railway";
    public static final String BUS_STOP = "bus_stop";
    public static final String RAILWAY_HALT = "halt";
    public static final String RAILWAY_STATION = "station";

    private PublicTransportHelper() {
    }

    public static String getRoleByMember(RelationMember m) {
        if (PublicTransportHelper.isMemberStop(m)) {
            return STOP;
        }
        if (PublicTransportHelper.isMemberPlatform(m)) {
            return PLATFORM;
        }
        return null;
    }

    public static boolean isMemberStop(RelationMember m) {
        return PublicTransportHelper.isNodeStop(m);
    }

    public static boolean isMemberPlatform(RelationMember m) {
        return PublicTransportHelper.isNodePlatform(m) || PublicTransportHelper.isWayPlatform(m);
    }

    public static boolean isNodeStop(RelationMember m) {
        return PublicTransportHelper.isNodeStop(m.getMember());
    }

    public static boolean isNodeStop(OsmPrimitive p) {
        String rw;
        String pt;
        return p.getType() == OsmPrimitiveType.NODE && !p.isIncomplete() && (p.hasKey(PUBLIC_TRANSPORT) ? STOP_POSITION.equals(pt = p.get(PUBLIC_TRANSPORT)) : p.hasKey(RAILWAY) && (RAILWAY_HALT.equals(rw = p.get(RAILWAY)) || RAILWAY_STATION.equals(rw)));
    }

    public static boolean isNodePlatform(RelationMember m) {
        return PublicTransportHelper.isNodePlatform(m.getMember());
    }

    public static boolean isNodePlatform(OsmPrimitive p) {
        if (p.getType() == OsmPrimitiveType.NODE && !p.isIncomplete()) {
            String rw;
            if (p.hasKey(PUBLIC_TRANSPORT)) {
                String pt = p.get(PUBLIC_TRANSPORT);
                if (PLATFORM.equals(pt)) {
                    return true;
                }
            } else if (p.hasKey(HIGHWAY)) {
                String hw = p.get(HIGHWAY);
                if (BUS_STOP.equals(hw)) {
                    return true;
                }
                if (PLATFORM.equals(hw)) {
                    return true;
                }
            } else if (p.hasKey(RAILWAY) && PLATFORM.equals(rw = p.get(RAILWAY))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isWayPlatform(RelationMember m) {
        return PublicTransportHelper.isWayPlatform(m.getMember());
    }

    public static boolean isWayPlatform(OsmPrimitive p) {
        String rw;
        String hw;
        String pt;
        return p.getType() == OsmPrimitiveType.WAY && !p.isIncomplete() && (p.hasKey(PUBLIC_TRANSPORT) ? PLATFORM.equals(pt = p.get(PUBLIC_TRANSPORT)) : (p.hasKey(HIGHWAY) ? PLATFORM.equals(hw = p.get(HIGHWAY)) : p.hasKey(RAILWAY) && PLATFORM.equals(rw = p.get(RAILWAY))));
    }

    public static boolean isMemberRouteway(RelationMember m) {
        return PublicTransportHelper.isWayRouteway(m.getMember());
    }

    public static boolean isWayRouteway(OsmPrimitive p) {
        if (p.getType() == OsmPrimitiveType.WAY && !p.isIncomplete()) {
            return p.hasKey(HIGHWAY) || p.hasKey(RAILWAY);
        }
        return false;
    }

    public static String getNameViaStoparea(RelationMember m) {
        return PublicTransportHelper.getNameViaStoparea(m.getMember());
    }

    public static String getNameViaStoparea(OsmPrimitive prim) {
        String result = prim.getName();
        if (result != null) {
            return result;
        }
        for (OsmPrimitive refOp : prim.getReferrers()) {
            if (refOp.getType() != OsmPrimitiveType.RELATION || !refOp.hasTag(PUBLIC_TRANSPORT, STOP_AREA) || (result = refOp.getName()) == null) continue;
            return result;
        }
        return result;
    }
}

