/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class TableRecord
extends SharedValueRecordBase {
    public static final short sid = 566;
    private static final BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private int field_5_flags;
    private int field_6_res;
    private int field_7_rowInputRow;
    private int field_8_colInputRow;
    private int field_9_rowInputCol;
    private int field_10_colInputCol;

    public TableRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_5_flags = recordInputStream.readByte();
        this.field_6_res = recordInputStream.readByte();
        this.field_7_rowInputRow = recordInputStream.readShort();
        this.field_8_colInputRow = recordInputStream.readShort();
        this.field_9_rowInputCol = recordInputStream.readShort();
        this.field_10_colInputCol = recordInputStream.readShort();
    }

    public boolean isAlwaysCalc() {
        return alwaysCalc.isSet(this.field_5_flags);
    }

    @Override
    public short getSid() {
        return 566;
    }

    @Override
    protected int getExtraDataSize() {
        return 10;
    }

    @Override
    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.field_5_flags);
        littleEndianOutput.writeByte(this.field_6_res);
        littleEndianOutput.writeShort(this.field_7_rowInputRow);
        littleEndianOutput.writeShort(this.field_8_colInputRow);
        littleEndianOutput.writeShort(this.field_9_rowInputCol);
        littleEndianOutput.writeShort(this.field_10_colInputCol);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TABLE]\n");
        stringBuffer.append("    .range    = ").append(this.getRange().toString()).append("\n");
        stringBuffer.append("    .flags    = ").append(HexDump.byteToHex(this.field_5_flags)).append("\n");
        stringBuffer.append("    .alwaysClc= ").append(this.isAlwaysCalc()).append("\n");
        stringBuffer.append("    .reserved = ").append(HexDump.intToHex(this.field_6_res)).append("\n");
        CellReference cellReference = TableRecord.cr(this.field_7_rowInputRow, this.field_8_colInputRow);
        CellReference cellReference2 = TableRecord.cr(this.field_9_rowInputCol, this.field_10_colInputCol);
        stringBuffer.append("    .rowInput = ").append(cellReference.formatAsString()).append("\n");
        stringBuffer.append("    .colInput = ").append(cellReference2.formatAsString()).append("\n");
        stringBuffer.append("[/TABLE]\n");
        return stringBuffer.toString();
    }

    private static CellReference cr(int n, int n2) {
        int n3 = n2 & 0xFF;
        boolean bl = (n2 & 0x8000) == 0;
        boolean bl2 = (n2 & 0x4000) == 0;
        return new CellReference(n, n3, bl, bl2);
    }
}

