/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.impl.LiteralLabel;

public class XSDAbstractDateTimeType
extends XSDDatatype {
    public static final short YEAR_MASK = 1;
    public static final short MONTH_MASK = 2;
    public static final short DAY_MASK = 4;
    public static final short TIME_MASK = 8;
    public static final short FULL_MASK = 15;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int msscale = 8;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 9;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;

    public XSDAbstractDateTimeType(String typename) {
        super(typename);
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return value1.getValue().equals(value2.getValue());
    }

    protected void getTime(String buffer, int start, int end, int[] data, int[] timeZone) throws RuntimeException {
        int stop = start + 2;
        data[3] = this.parseInt(buffer, start, stop);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[4] = this.parseInt(buffer, start, stop += 2);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[5] = this.parseInt(buffer, start, stop += 2);
        if (stop == end) {
            return;
        }
        start = stop;
        int millisec = buffer.charAt(start) == '.' ? start : -1;
        int sign = this.findUTCSign(buffer, start, end);
        if (millisec != -1) {
            int msEnd = start = sign < 0 ? end : sign;
            while (buffer.charAt(msEnd - 1) == '0') {
                --msEnd;
            }
            data[6] = this.parseInt(buffer, millisec + 1, msEnd);
            data[8] = msEnd - millisec - 1;
        }
        if (sign > 0) {
            if (start != sign) {
                throw new RuntimeException("Error in parsing time zone");
            }
            this.getTimeZone(buffer, data, sign, end, timeZone);
        } else if (start != end) {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int getDate(String buffer, int start, int end, int[] date) throws RuntimeException {
        start = this.getYearMonth(buffer, start, end, date);
        if (buffer.charAt(start++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int stop = start + 2;
        date[2] = this.parseInt(buffer, start, stop);
        return stop;
    }

    protected int getYearMonth(String buffer, int start, int end, int[] date) throws RuntimeException {
        int i;
        if (buffer.charAt(0) == '-') {
            ++start;
        }
        if ((i = this.indexOf(buffer, start, end, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int length = i - start;
        if (length < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && buffer.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        date[0] = this.parseIntYear(buffer, i);
        if (buffer.charAt(i) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        start = ++i;
        i = start + 2;
        date[1] = this.parseInt(buffer, start, i);
        return i;
    }

    protected void parseTimeZone(String buffer, int start, int end, int[] date, int[] timeZone) throws RuntimeException {
        if (start < end) {
            int sign = this.findUTCSign(buffer, start, end);
            if (sign < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(buffer, date, sign, end, timeZone);
        }
    }

    protected void getTimeZone(String buffer, int[] data, int sign, int end, int[] timeZone) throws RuntimeException {
        data[7] = buffer.charAt(sign);
        if (buffer.charAt(sign) == 'Z') {
            if (end > ++sign) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (sign <= end - 6) {
            int stop = ++sign + 2;
            timeZone[0] = this.parseInt(buffer, sign, stop);
            if (buffer.charAt(stop++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            timeZone[1] = this.parseInt(buffer, stop, stop + 2);
            if (stop + 2 != end) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(String buffer, int start, int end, char ch) {
        for (int i = start; i < end; ++i) {
            if (buffer.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static final int getDigit(char ch) {
        return XSDAbstractDateTimeType.isDigit(ch) ? ch - 48 : -1;
    }

    protected int findUTCSign(String buffer, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = buffer.charAt(i);
            if (c != 'Z' && c != '+' && c != '-') continue;
            return i;
        }
        return -1;
    }

    protected int parseInt(String buffer, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        int digit = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        int i = start;
        do {
            if ((digit = XSDAbstractDateTimeType.getDigit(buffer.charAt(i))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        } while (++i < end);
        return -result;
    }

    protected int parseIntYear(String buffer, int end) {
        int limit;
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int digit = 0;
        if (buffer.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        while (i < end) {
            if ((digit = XSDAbstractDateTimeType.getDigit(buffer.charAt(i++))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
        }
        return -result;
    }

    public String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(25);
        this.append(message, date[0], 4);
        message.append('-');
        this.append(message, date[1], 2);
        message.append('-');
        this.append(message, date[2], 2);
        message.append('T');
        this.append(message, date[3], 2);
        message.append(':');
        this.append(message, date[4], 2);
        message.append(':');
        this.append(message, date[5], 2);
        message.append('.');
        XSDAbstractDateTimeType.appendFractionalTime(message, date[6], date[8]);
        this.append(message, (char)date[7], 0);
        return message.toString();
    }

    public static void appendFractionalTime(StringBuffer buff, int fsec, int scale) {
        int trunc;
        String msString = Integer.toString(fsec);
        for (int pad = scale - msString.length(); pad > 0; --pad) {
            buff.append('0');
        }
        for (trunc = msString.length(); trunc > 0 && msString.charAt(trunc - 1) == '0'; --trunc) {
        }
        buff.append(msString.substring(0, trunc));
    }

    protected void append(StringBuffer message, int value, int nch) {
        if (value < 0) {
            message.append('-');
            value = -value;
        }
        if (nch == 4) {
            if (value < 10) {
                message.append("000");
            } else if (value < 100) {
                message.append("00");
            } else if (value < 1000) {
                message.append("0");
            }
            message.append(value);
        } else if (nch == 2) {
            if (value < 10) {
                message.append('0');
            }
            message.append(value);
        } else if (value != 0) {
            message.append((char)value);
        }
    }

    @Override
    public RDFDatatype normalizeSubType(Object value, RDFDatatype dt) {
        if (value instanceof XSDDateTime) {
            if (dt.equals(XSDDatatype.XSDdateTime)) {
                return ((XSDDateTime)value).getNarrowedDatatype();
            }
            if (dt instanceof XSDDatatype) {
                ((XSDDateTime)value).narrowType((XSDDatatype)dt);
            }
        }
        return this;
    }
}

