/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.data.DataSourceException;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class PluginOperations {
    private static final Logger logger = Logger.getLogger(PluginOperations.class);
    static Vector<String> crsDescriptions;
    static CoordinateReferenceSystem defaultSourceCRS;
    static String defaultSourceCRSDescription;

    public static GridCoverage2D reprojectCoverage(GridCoverage2D coverage, CoordinateReferenceSystem targetCrs) throws NoSuchAuthorityCodeException, FactoryException {
        GridCoverage2D destination = null;
        CoverageProcessor processor = new CoverageProcessor();
        ParameterValueGroup resampleParams = processor.getOperation("Resample").getParameters();
        resampleParams.parameter("Source").setValue((Object)coverage);
        resampleParams.parameter("CoordinateReferenceSystem").setValue((Object)targetCrs);
        destination = (GridCoverage2D)processor.doOperation(resampleParams);
        return destination;
    }

    public static GridCoverage2D createGridFromFile(File file, CoordinateReferenceSystem refSys, boolean failIfNoPrjFile) throws IOException {
        GridCoverage2D coverage = null;
        if (!file.exists()) {
            throw new FileNotFoundException("File not found.");
        }
        String extension = null;
        String fileNameWithoutExt = null;
        int dotPos = file.getAbsolutePath().lastIndexOf(".");
        extension = file.getAbsolutePath().substring(dotPos);
        fileNameWithoutExt = file.getAbsolutePath().substring(0, dotPos);
        if (extension.equalsIgnoreCase(".tif") || extension.equalsIgnoreCase(".tiff")) {
            BufferedImage img;
            try {
                coverage = PluginOperations.readGeoTiff(file, refSys);
                return coverage;
            }
            catch (DataSourceException dse) {
                if (!dse.getMessage().contains("Coordinate Reference System is not available")) {
                    dse.printStackTrace();
                }
            }
            catch (FactoryException facte) {
                logger.fatal((Object)"Error while reading from GeoTIFF:", (Throwable)facte);
                throw new IOException(facte);
            }
            String[] postfixes = new String[]{"wld", "tfw", "tifw"};
            WorldFileReader tfwReader = null;
            for (int i = 0; i < postfixes.length; ++i) {
                File prjFile = new File(fileNameWithoutExt + "." + postfixes[i]);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                logger.debug((Object)"no projection given, no projection file found; using unprojected file.");
            }
            if ((img = ImageIO.read(file)) == null) {
                throw new IOException("Cannot read image file " + file.getAbsolutePath());
            }
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            Envelope2D bbox = new Envelope2D(null, (Rectangle2D)new Rectangle2D.Double(lowerLeft_x, lowerLeft_y, width, height));
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else if (extension.equalsIgnoreCase(".jpg") || extension.equalsIgnoreCase(".jpeg")) {
            String[] postfixes = new String[]{"wld", "jgw", "jpgw"};
            WorldFileReader tfwReader = null;
            for (int i = 0; i < postfixes.length; ++i) {
                File prjFile = new File(fileNameWithoutExt + "." + postfixes[i]);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                logger.debug((Object)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            Envelope2D bbox = new Envelope2D(null, (Rectangle2D)new Rectangle2D.Double(lowerLeft_x, lowerLeft_y, width, height));
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else if (extension.equalsIgnoreCase(".bmp")) {
            String[] postfixes = new String[]{"wld", "bmpw", "bpw"};
            WorldFileReader tfwReader = null;
            for (int i = 0; i < postfixes.length; ++i) {
                File prjFile = new File(fileNameWithoutExt + "." + postfixes[i]);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                logger.debug((Object)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            Envelope2D bbox = new Envelope2D(null, (Rectangle2D)new Rectangle2D.Double(lowerLeft_x, lowerLeft_y, width, height));
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else if (extension.equalsIgnoreCase(".png")) {
            String[] postfixes = new String[]{"wld", "pgw", "pngw"};
            WorldFileReader tfwReader = null;
            for (int i = 0; i < postfixes.length; ++i) {
                File prjFile = new File(fileNameWithoutExt + "." + postfixes[i]);
                if (!prjFile.exists()) continue;
                tfwReader = new WorldFileReader(prjFile);
            }
            if (tfwReader == null) {
                throw new IOException("No Worldfile found.");
            }
            if (refSys == null && (refSys = PluginOperations.readPrjFile(file)) == null) {
                if (failIfNoPrjFile) {
                    throw new IOException("No projection file found.");
                }
                logger.debug((Object)"no projection given, no projection file found; using unprojected file.");
            }
            BufferedImage img = ImageIO.read(file);
            double width = (double)img.getWidth() * tfwReader.getXPixelSize();
            double height = (double)img.getHeight() * -tfwReader.getYPixelSize();
            double lowerLeft_x = tfwReader.getXULC();
            double lowerLeft_y = tfwReader.getYULC() - height;
            Envelope2D bbox = new Envelope2D(null, (Rectangle2D)new Rectangle2D.Double(lowerLeft_x, lowerLeft_y, width, height));
            coverage = PluginOperations.createGridCoverage(img, bbox, refSys);
        } else {
            throw new IOException("Image type not supported. Supported formats are: \n" + Arrays.toString((Object[])SUPPORTEDIMAGETYPES.values()));
        }
        return coverage;
    }

    public static CoordinateReferenceSystem readPrjFile(File file) throws IOException {
        CoordinateReferenceSystem refSys = null;
        String prjFilename = null;
        int dotPos = file.getAbsolutePath().lastIndexOf(".");
        prjFilename = file.getAbsolutePath().substring(0, dotPos) + ".prj";
        File prjFile = new File(prjFilename);
        if (!prjFile.exists()) {
            return null;
        }
        logger.debug((Object)("Loading .prj file: " + prjFile.getAbsolutePath()));
        try (BufferedReader br = new BufferedReader(new FileReader(prjFile));){
            StringBuilder sb = new StringBuilder();
            String content = null;
            while ((content = br.readLine()) != null) {
                sb.append(content);
            }
            refSys = CRS.parseWKT((String)sb.toString().trim());
        }
        catch (FactoryException e) {
            throw new IOException("Unable to parse prj-file: '" + prjFile.getName() + "'");
        }
        return refSys;
    }

    public static GridCoverage2D createGridCoverage(BufferedImage img, Envelope2D bbox, CoordinateReferenceSystem crs) {
        bbox.setCoordinateReferenceSystem(crs);
        return new GridCoverageFactory().create((CharSequence)"", (RenderedImage)img, (Envelope)bbox);
    }

    public static GridCoverage2D readGeoTiff(File file, CoordinateReferenceSystem refSys) throws IOException, FactoryException {
        GridCoverage2D coverage = null;
        Hints hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        if (refSys != null) {
            hints.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)refSys);
        }
        GeoTiffReader reader = new GeoTiffReader((Object)file, hints);
        coverage = reader.read(null);
        return coverage;
    }

    public static void loadCRSData(Properties pluginProps) {
        String defaultcrsString = pluginProps.getProperty("default_crs_srid");
        crsDescriptions = new Vector();
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        CRSAuthorityFactory fac = CRS.getAuthorityFactory((boolean)false);
        for (String string : supportedCodes) {
            try {
                if ("WGS84(DD)".equals(string)) continue;
                InternationalString desc = fac.getDescriptionText("EPSG:" + string);
                String description = desc.toString() + " [-EPSG:" + string + "-]";
                crsDescriptions.add(description);
                if (defaultcrsString == null || !defaultcrsString.equalsIgnoreCase("EPSG:" + string)) continue;
                boolean isEastingFirst = Boolean.valueOf(pluginProps.getProperty("default_crs_eastingfirst"));
                defaultSourceCRS = CRS.decode((String)("EPSG:" + string), (boolean)isEastingFirst);
                defaultSourceCRSDescription = description;
            }
            catch (FactoryException e) {
                logger.error((Object)("Error while loading EPSG data: " + e.getMessage()));
            }
        }
    }

    public static enum POSTFIXES_WORLDFILE {
        wld,
        jgw,
        jpgw,
        pgw,
        pngw,
        tfw,
        tifw,
        bpw,
        bmpw;

    }

    public static enum SUPPORTEDIMAGETYPES {
        tiff,
        tif,
        jpg,
        jpeg,
        bmp,
        png;

    }
}

