/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_meta_t;
import uk.co.caprica.vlcj.medialist.MediaListEventListener;
import uk.co.caprica.vlcj.medialist.MediaListItem;
import uk.co.caprica.vlcj.medialist.events.MediaListEvent;
import uk.co.caprica.vlcj.medialist.events.MediaListEventFactory;
import uk.co.caprica.vlcj.player.MediaResourceLocator;
import uk.co.caprica.vlcj.player.NativeString;

public class MediaList {
    private final Logger logger = LoggerFactory.getLogger(MediaList.class);
    private final List<MediaListEventListener> eventListenerList = new ArrayList<MediaListEventListener>();
    private final MediaListEventFactory eventFactory = new MediaListEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private libvlc_media_list_t mediaListInstance;
    private libvlc_event_manager_t mediaListEventManager;
    private libvlc_callback_t callback;
    private final AtomicBoolean released = new AtomicBoolean();
    private String[] standardMediaOptions;

    public MediaList(LibVlc libvlc, libvlc_instance_t instance) {
        this(libvlc, instance, null);
    }

    public MediaList(LibVlc libvlc, libvlc_instance_t instance, libvlc_media_list_t mediaListInstance) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance(mediaListInstance);
    }

    public final void addMediaListEventListener(MediaListEventListener listener) {
        this.logger.debug("addMediaListEventListener(listener={})", (Object)listener);
        this.eventListenerList.add(listener);
    }

    public final void removeListEventListener(MediaListEventListener listener) {
        this.logger.debug("removeMediaListEventListener(listener={})", (Object)listener);
        this.eventListenerList.remove(listener);
    }

    public final void setStandardMediaOptions(String ... standardMediaOptions) {
        this.logger.debug("setStandardMediaOptions(standardMediaOptions={})", (Object)Arrays.toString(standardMediaOptions));
        this.standardMediaOptions = standardMediaOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMedia(String mrl, String ... mediaOptions) {
        this.logger.debug("addMedia(mrl={},mediaOptions={})", (Object)mrl, (Object)Arrays.toString(mediaOptions));
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, mediaDescriptor);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertMedia(int index, String mrl, String ... mediaOptions) {
        this.logger.debug("insertMedia(index={},mrl={},mediaOptions={})", new Object[]{index, mrl, Arrays.toString(mediaOptions)});
        try {
            this.lock();
            libvlc_media_t mediaDescriptor = this.newMediaDescriptor(mrl, mediaOptions);
            this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, mediaDescriptor, index);
            this.releaseMediaDescriptor(mediaDescriptor);
        }
        finally {
            this.unlock();
        }
    }

    public final void removeMedia(int index) {
        this.logger.debug("removeMedia(index={})", (Object)index);
        try {
            this.lock();
            libvlc_media_t oldMediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (oldMediaInstance != null) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, index);
                this.libvlc.libvlc_media_release(oldMediaInstance);
            }
        }
        finally {
            this.unlock();
        }
    }

    public final void clear() {
        this.logger.debug("clear()");
        try {
            this.lock();
            for (int i = this.libvlc.libvlc_media_list_count(this.mediaListInstance) - 1; i >= 0; --i) {
                this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, i);
            }
        }
        finally {
            this.unlock();
        }
    }

    public final int size() {
        this.logger.debug("size()");
        try {
            this.lock();
            int size = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            this.logger.debug("size={}", (Object)size);
            int n = size;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isReadOnly() {
        this.logger.debug("isReadOnly()");
        return this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MediaListItem> items() {
        this.logger.debug("items()");
        ArrayList<MediaListItem> result = new ArrayList<MediaListItem>();
        try {
            this.lock();
            for (int i = 0; i < this.libvlc.libvlc_media_list_count(this.mediaListInstance); ++i) {
                libvlc_media_t mediaInstance = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, i);
                result.add(this.newMediaListItem(mediaInstance));
                this.libvlc.libvlc_media_release(mediaInstance);
            }
        }
        finally {
            this.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaListItem newMediaListItem(libvlc_media_t mediaInstance) {
        List<MediaListItem> subItems;
        String name = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_meta(mediaInstance, libvlc_meta_t.libvlc_meta_Title.intValue()));
        String mrl = NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(mediaInstance));
        libvlc_media_list_t subItemList = this.libvlc.libvlc_media_subitems(mediaInstance);
        if (subItemList != null) {
            try {
                this.libvlc.libvlc_media_list_lock(subItemList);
                subItems = new ArrayList<MediaListItem>();
                for (int i = 0; i < this.libvlc.libvlc_media_list_count(subItemList); ++i) {
                    libvlc_media_t subItemInstance = this.libvlc.libvlc_media_list_item_at_index(subItemList, i);
                    subItems.add(this.newMediaListItem(subItemInstance));
                    this.libvlc.libvlc_media_release(subItemInstance);
                }
            }
            finally {
                this.libvlc.libvlc_media_list_unlock(subItemList);
            }
            this.libvlc.libvlc_media_list_release(subItemList);
        } else {
            subItems = Collections.emptyList();
        }
        return new MediaListItem(name, mrl, subItems);
    }

    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance(libvlc_media_list_t mediaListInstance) {
        this.logger.debug("createInstance()");
        if (mediaListInstance == null) {
            mediaListInstance = this.libvlc.libvlc_media_list_new(this.instance);
        } else {
            this.libvlc.libvlc_media_list_retain(mediaListInstance);
        }
        this.mediaListInstance = mediaListInstance;
        this.logger.debug("mediaListInstance={}", (Object)mediaListInstance);
        this.mediaListEventManager = this.libvlc.libvlc_media_list_event_manager(mediaListInstance);
        this.logger.debug("mediaListEventManager={}", (Object)this.mediaListEventManager);
        this.registerEventListener();
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.deregisterEventListener();
        if (this.mediaListInstance != null) {
            this.libvlc.libvlc_media_list_release(this.mediaListInstance);
        }
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    private void registerEventListener() {
        this.logger.debug("registerEventListener()");
        this.callback = new MediaListCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListEndReached.intValue()) continue;
            this.logger.debug("event={}", (Object)event);
            int result = this.libvlc.libvlc_event_attach(this.mediaListEventManager, event.intValue(), this.callback, null);
            this.logger.debug("result={}", (Object)result);
        }
    }

    private void deregisterEventListener() {
        this.logger.debug("deregisterEventListener()");
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaListItemAdded.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaListEndReached.intValue()) continue;
                this.logger.debug("event={}", (Object)event);
                this.libvlc.libvlc_event_detach(this.mediaListEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void raiseEvent(MediaListEvent mediaListEvent) {
        this.logger.trace("raiseEvent(mediaListEvent={}", (Object)mediaListEvent);
        if (mediaListEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaListEvent));
        }
    }

    private void lock() {
        this.logger.debug("lock()");
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        this.logger.debug("unlock()");
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }

    private libvlc_media_t newMediaDescriptor(String media, String ... mediaOptions) {
        libvlc_media_t mediaDescriptor;
        this.logger.debug("newMediaDescriptor(media={},mediaOptions={})", (Object)media, (Object)Arrays.toString(mediaOptions));
        media = MediaResourceLocator.encodeMrl(media);
        if (MediaResourceLocator.isLocation(media)) {
            this.logger.debug("Treating mrl as a location");
            mediaDescriptor = this.libvlc.libvlc_media_new_location(this.instance, media);
        } else {
            this.logger.debug("Treating mrl as a path");
            mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        }
        this.logger.debug("mediaDescriptor={}", (Object)mediaDescriptor);
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                this.logger.debug("standardMediaOption={}", (Object)standardMediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                this.logger.debug("mediaOption={}", (Object)mediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        return mediaDescriptor;
    }

    private void releaseMediaDescriptor(libvlc_media_t mediaDescriptor) {
        this.logger.debug("releaseMediaDescriptor(mediaDescriptor={})", (Object)mediaDescriptor);
        this.libvlc.libvlc_media_release(mediaDescriptor);
    }

    public final libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaListEvent mediaListEvent;

        private NotifyEventListenersRunnable(MediaListEvent mediaListEvent) {
            this.mediaListEvent = mediaListEvent;
        }

        @Override
        public void run() {
            MediaList.this.logger.trace("run()");
            for (int i = MediaList.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaListEventListener listener = (MediaListEventListener)MediaList.this.eventListenerList.get(i);
                try {
                    this.mediaListEvent.notify(listener);
                    continue;
                }
                catch (Exception e) {
                    MediaList.this.logger.warn("Event listener {} threw an exception", (Object)e, (Object)listener);
                }
            }
            MediaList.this.logger.trace("runnable exits");
        }
    }

    private final class MediaListCallback
    implements libvlc_callback_t {
        private MediaListCallback() {
        }

        @Override
        public void callback(libvlc_event_t event, Pointer userData) {
            MediaList.this.logger.trace("callback(event={},userData={})", (Object)event, (Object)userData);
            if (!MediaList.this.eventListenerList.isEmpty()) {
                MediaList.this.raiseEvent(MediaList.this.eventFactory.createEvent(event));
            }
        }
    }
}

