/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.gui.FinishedUploadDialog;
import org.openstreetmap.josm.tools.I18n;

public final class PluginState {
    private static boolean submittingChangeset;
    private static int runningDownloads;
    private static int imagesToUpload;
    private static int imagesUploaded;

    private PluginState() {
    }

    public static void startDownload() {
        ++runningDownloads;
    }

    public static void finishDownload() {
        if (runningDownloads == 0) {
            throw new IllegalStateException("The amount of running downlaods is less or equals to 0");
        }
        --runningDownloads;
    }

    public static boolean isDownloading() {
        return runningDownloads > 0;
    }

    public static boolean isSubmittingChangeset() {
        return submittingChangeset;
    }

    public static boolean isUploading() {
        return imagesToUpload > imagesUploaded;
    }

    public static void addImagesToUpload(int amount) {
        if (imagesToUpload <= imagesUploaded) {
            imagesToUpload = 0;
            imagesUploaded = 0;
        }
        imagesToUpload += amount;
    }

    public static int getImagesToUpload() {
        return imagesToUpload;
    }

    public static int getImagesUploaded() {
        return imagesUploaded;
    }

    public static void imageUploaded() {
        if (imagesToUpload == ++imagesUploaded && Main.main != null) {
            PluginState.finishedUploadDialog();
        }
    }

    private static void finishedUploadDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            JOptionPane pane = new JOptionPane();
            pane.setMessage(new FinishedUploadDialog());
            JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Finished upload", (Object[])new Object[0]));
            dlg.setVisible(true);
        } else {
            SwingUtilities.invokeLater(() -> PluginState.finishedUploadDialog());
        }
    }

    public static void notLoggedInToMapillaryDialog() {
        if (Main.main == null) {
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You are not logged in, please log in to Mapillary in the preferences", (Object[])new Object[0]), I18n.tr((String)"Not Logged in to Mapillary", (Object[])new Object[0]), 2);
    }

    public static String getUploadString() {
        return I18n.tr((String)"Uploading: {0}", (Object[])new Object[]{"(" + imagesUploaded + "/" + imagesToUpload + ")"});
    }

    public static void setSubmittingChangeset(boolean isSubmitting) {
        submittingChangeset = isSubmitting;
    }
}

