/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;

public final class MapillaryColorScheme {
    public static final Color SEQ_UNSELECTED = new Color(3647584);
    public static final Color SEQ_UNSELECTED_VIEW = new Color(1537346);
    public static final Color SEQ_SELECTED = new Color(46581);
    public static final Color SEQ_SELECTED_VIEW = new Color(30365);
    public static final Color SEQ_HIGHLIGHTED_IMAGE = new Color(16089370);
    public static final Color SEQ_HIGHLIGHTED_IMG_VIEW = new Color(16103450);
    public static final Color MAPILLARY_GREEN = new Color(3518317);
    public static final Color TOOLBAR_DARK_GREY = new Color(2368808);

    private MapillaryColorScheme() {
    }

    public static void styleAsDefaultPanel(JComponent ... components) {
        if (components != null && components.length >= 1) {
            for (JComponent component : components) {
                component.setBackground(Color.WHITE);
            }
        }
    }

    public static final class MapillaryButton
    extends JButton {
        private static final long serialVersionUID = 3824559897922944415L;

        public MapillaryButton(String text, Action action) {
            super(action);
            this.setText(text);
            this.setForeground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(7, 10, 7, 10));
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.getModel().isPressed()) {
                g.setColor(MAPILLARY_GREEN.darker().darker());
            } else if (this.getModel().isRollover()) {
                g.setColor(MAPILLARY_GREEN.darker());
            } else {
                g.setColor(MAPILLARY_GREEN);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 3, 3);
            super.paintComponent(g);
        }

        @Override
        public boolean isContentAreaFilled() {
            return false;
        }
    }
}

